/* sfm -- Simple File Manager
   Copyright (C) 1998 Pixel (Pascal Rigaux)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#ifndef MYMALLOC_H
#define MYMALLOC_H


extern void mystart();
extern void myexit(int status);
extern char *strconcat(char *a, char *b);
extern char *strconcat3(char *a, char *b, char *c);
extern void *anydup(void *p, int size);


#ifdef MYMALLOC

extern void *_malloc(int size, int line, char *file);
extern void _free(void *ptr, int line, char *file);
extern void *_realloc(void *ptr, int size, int line, char *file);
extern void _exit(int status);
extern char *_strdup(char *s, int line, char *file);
extern char *_strconcat(char *a, char *b, int line, char *file);
extern char *_strconcat3(char *a, char *b, char *c, int line, char *file);
extern void *_anydup(void *p, int size, int line, char *file);

#define malloc(s) _malloc(s, __LINE__, __FILE__)
#define free(p) _free(p, __LINE__, __FILE__)
#define realloc(p, s) _realloc(p, s, __LINE__, __FILE__)
#define strdup(s) _strdup(s, __LINE__, __FILE__)
#define strconcat(a, b) _strconcat(a, b, __LINE__, __FILE__)
#define strconcat3(a, b, c) _strconcat3(a, b, c, __LINE__, __FILE__)
#define anydup(p, s) _anydup(p, s, __LINE__, __FILE__)

#else

#define myexit(s) exit(s)

#endif
#endif
