/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  oneliner
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gladesig.h"
#include "gladesrc.h"

GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is an internally used function to set notebook tab widgets. */
void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}

static GList *pixmaps_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
void
add_pixmap_directory                   (gchar           *directory)
{
  pixmaps_directories = g_list_prepend (pixmaps_directories, g_strdup (directory));
}

/* This is an internally used function to check if a pixmap file exists. */
#ifndef G_DIR_SEPARATOR_S
#define G_DIR_SEPARATOR_S "/"
#endif
gchar*
check_file_exists                      (gchar           *directory,
                                        gchar           *filename)
{
  gchar *full_filename;
  struct stat s;
  gint status;

  full_filename = g_malloc (strlen (directory) + 1 + strlen (filename) + 1);
  strcpy (full_filename, directory);
  strcat (full_filename, G_DIR_SEPARATOR_S);
  strcat (full_filename, filename);

  status = stat (full_filename, &s);
  if (status == 0 && S_ISREG (s.st_mode))
    return full_filename;
  g_free (full_filename);
  return NULL;
}

/* This is an internally used function to create pixmaps. */
GtkWidget*
create_pixmap                          (GtkWidget       *widget,
                                        gchar           *filename)
{
  gchar *found_filename = NULL;
  GdkColormap *colormap;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GtkWidget *pixmap;
  GList *elem;

  /* We first try any pixmaps directories set by the application. */
  elem = pixmaps_directories;
  while (elem)
    {
      found_filename = check_file_exists ((gchar*)elem->data, filename);
      if (found_filename)
        break;
      elem = elem->next;
    }

  /* If we haven't found the pixmap, try the source directory. */
  if (!found_filename)
    {
      found_filename = check_file_exists ("pixmaps", filename);
    }

  if (!found_filename)
    {
      g_print ("Couldn't find pixmap file: %s", filename);
      return NULL;
    }

  colormap = gtk_widget_get_colormap (widget);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask,
                                                   NULL, found_filename);
  g_free (found_filename);
  if (gdkpixmap == NULL)
    return NULL;
  pixmap = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);
  return pixmap;
}

GtkWidget*
create_mainwin ()
{
  GtkWidget *mainwin;
  GtkWidget *winlayout;
  GtkWidget *toplayout;
  GtkWidget *menubar1;
  GtkWidget *commands;
  GtkWidget *commands_menu;
  GtkWidget *quit;
  GtkWidget *directories;
  GtkWidget *directories_menu;
  GtkWidget *dummy;
  GtkWidget *location;
  GtkWidget *command;
  GtkAccelGroup *accel_group;

  mainwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (mainwin, "mainwin");
  gtk_object_set_data (GTK_OBJECT (mainwin), "mainwin", mainwin);
  gtk_signal_connect (GTK_OBJECT (mainwin), "destroy",
                      GTK_SIGNAL_FUNC (on_main_destroy),
                      NULL);
  gtk_window_set_title (GTK_WINDOW (mainwin), "OneLiner");
  gtk_window_set_policy (GTK_WINDOW (mainwin), FALSE, FALSE, TRUE);

  winlayout = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (winlayout, "winlayout");
  gtk_object_set_data (GTK_OBJECT (mainwin), "winlayout", winlayout);
  gtk_widget_show (winlayout);
  gtk_container_add (GTK_CONTAINER (mainwin), winlayout);

  toplayout = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (toplayout, "toplayout");
  gtk_object_set_data (GTK_OBJECT (mainwin), "toplayout", toplayout);
  gtk_widget_show (toplayout);
  gtk_box_pack_start (GTK_BOX (winlayout), toplayout, TRUE, TRUE, 0);

  menubar1 = gtk_menu_bar_new ();
  gtk_widget_set_name (menubar1, "menubar1");
  gtk_object_set_data (GTK_OBJECT (mainwin), "menubar1", menubar1);
  gtk_widget_show (menubar1);
  gtk_box_pack_start (GTK_BOX (toplayout), menubar1, FALSE, FALSE, 0);

  commands = gtk_menu_item_new_with_label ("Commands");
  gtk_widget_set_name (commands, "commands");
  gtk_object_set_data (GTK_OBJECT (mainwin), "commands", commands);
  gtk_widget_show (commands);
  gtk_container_add (GTK_CONTAINER (menubar1), commands);

  commands_menu = gtk_menu_new ();
  gtk_widget_set_name (commands_menu, "commands_menu");
  gtk_object_set_data (GTK_OBJECT (mainwin), "commands_menu", commands_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (commands), commands_menu);

  quit = gtk_menu_item_new_with_label ("Quit");
  gtk_widget_set_name (quit, "quit");
  gtk_object_set_data (GTK_OBJECT (mainwin), "quit", quit);
  gtk_widget_show (quit);
  gtk_container_add (GTK_CONTAINER (commands_menu), quit);
  gtk_signal_connect (GTK_OBJECT (quit), "activate",
                      GTK_SIGNAL_FUNC (on_main_destroy),
                      NULL);
  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (mainwin), accel_group);
  gtk_widget_add_accelerator (quit, "activate", accel_group,
                              GDK_q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  directories = gtk_menu_item_new_with_label ("Directories");
  gtk_widget_set_name (directories, "directories");
  gtk_object_set_data (GTK_OBJECT (mainwin), "directories", directories);
  gtk_widget_show (directories);
  gtk_container_add (GTK_CONTAINER (menubar1), directories);

  directories_menu = gtk_menu_new ();
  gtk_widget_set_name (directories_menu, "directories_menu");
  gtk_object_set_data (GTK_OBJECT (mainwin), "directories_menu", directories_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (directories), directories_menu);

  dummy = gtk_menu_item_new_with_label ("dummy");
  gtk_widget_set_name (dummy, "dummy");
  gtk_object_set_data (GTK_OBJECT (mainwin), "dummy", dummy);
  gtk_widget_show (dummy);
  gtk_container_add (GTK_CONTAINER (directories_menu), dummy);

  location = gtk_label_new ("/");
  gtk_widget_set_name (location, "location");
  gtk_object_set_data (GTK_OBJECT (mainwin), "location", location);
  gtk_widget_show (location);
  gtk_box_pack_start (GTK_BOX (toplayout), location, TRUE, TRUE, 3);
  gtk_label_set_justify (GTK_LABEL (location), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (location), 1, 0.5);

  command = gtk_entry_new ();
  gtk_widget_set_name (command, "command");
  gtk_object_set_data (GTK_OBJECT (mainwin), "command", command);
  gtk_widget_show (command);
  gtk_box_pack_start (GTK_BOX (winlayout), command, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (command), "activate",
                      GTK_SIGNAL_FUNC (on_command_activate),
                      command);

  return mainwin;
}

