#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <termios.h>

char readps2(int fd)
{
	char ch;

	while(read(fd,&ch,1) && (ch==(char)0xfa || ch==(char)0xaa))
	{
		printf("<%02X>",ch&0xff);
		fflush(stdout);
	}
	return(ch);
}

int main(int argc, char **argv)
{
	int fd;
	char ch,
		getdevtype=0xf2,
		disabledev=0xf5,
		setmmplus[]={0xe6,0xe8,0,0xe8,3,0xe8,2,0xe8,1,0xe6,0xe8,3,0xe8,1,0xe8,2,0xe8,3,},
		setupmore[7]={0xf6,0xe6,0xf4,0xf3,100,0xe8,3},
		resetps2=0xff;

	if(argc>1)
		fd=open(argv[1],O_RDWR);
	else
		fd=open("/dev/mouse",O_RDWR);

	write(fd,&disabledev,1);

	tcflush(fd, TCIFLUSH);
	write(fd,&getdevtype,1);
	sleep(1);
	ch=readps2(fd);
	printf("device type=%02X(%4d)\n",ch&0xff,ch);

	write(fd,&resetps2,1);
	sleep(1);
	ch=readps2(fd);
	printf("reset response=%02X(%4d)\n",ch&0xff,ch);

	tcflush(fd, TCIFLUSH);
	write(fd,&getdevtype,1);
	sleep(1);
	ch=readps2(fd);
	printf("device type=%02X(%4d)\n",ch&0xff,ch);

	write(fd,&setmmplus,sizeof(setmmplus));
	write(fd,&setupmore,7);

	tcflush(fd, TCIFLUSH);
	write(fd,&getdevtype,1);
	sleep(1);
	ch=readps2(fd);
	printf("device type=%02X(%4d)\n",ch&0xff,ch);

	tcflush(fd, TCIFLUSH);
	write(fd,&getdevtype,1);
	sleep(1);
	ch=readps2(fd);
	printf("device type=%02X(%4d)\n",ch&0xff,ch);
	close(fd);
	return(0);
}
