// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        strarray.h
//
// Purpose:     interface to simple array of strings
//
// Created:     28 Feb 94   Michael Pichler
//
// Changed:     14 Mar 94   Michael Pichler
//
// $Id: strarray.h,v 1.3 1997/02/25 17:03:58 mpichler Exp $
//
//</file>



#ifndef harmony_scene_strarray_h
#define harmony_scene_strarray_h



class ostream;

class StringArray
{
  public:
    StringArray (const char* items);    // items are separated by whitespace
//  StringArray (const char* items, char separator);
    ~StringArray ();

    void printItems (ostream&, char separator = ' ') const;  // dump all items
    friend ostream& operator << (ostream&, const StringArray&);  // list output

    const char* item (int i) const;     // return item i (nil when out of range)
    int numItems () const  { return numitems_; }

    const char* nextItem () const;      // next item (circular)
    const char* previousItem () const;  // previous item (circular)

    int contains (const char* item) const;  // does string array contain item?

  private:
    char* data_;
    const char** item_;
    int numitems_;
    int current_;

    // prevent copying (declared, but not implemented)
    StringArray (const StringArray&);
    StringArray& operator = (const StringArray&);
};


inline const char* StringArray::item (int i) const
{
  return (i >= 0 && i < numitems_) ? item_ [i] : 0;
}


#endif
