// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1994
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        socket.h
// 
// Purpose:     
// 
// Created:     4 May 95   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: socket.h,v 1.8 1997/01/29 15:39:50 gorasche Exp $
//
// $Log: socket.h,v $
// Revision 1.8  1997/01/29 15:39:50  gorasche
// overloaded members for Win32
//
// Revision 1.7  1996/10/03 15:59:07  jfasch
// adaptions due to moving it from the previous location in DcCommon to HgUtilities
//
// Revision 1.6  1996/07/08 13:16:36  jfasch
// *** empty log message ***
//
// Revision 1.5  1996/06/12 11:30:24  jfasch
// added void listening(bool)
//
// 
// </file> 
#ifndef hg_utils_socket_h
#define hg_utils_socket_h

#include "file.h"

struct sockaddr ;
class SocketPtr ;


// <class> 
//  
// Name:             Socket
// 
// Purpose:          
// 
// base class for every kind of socket file number encapsulating class.
// implements generic socket operations (to be extended (?)).
// 
// Public Interface: 
// 
// - bool blocking() const
//   is my socket file descriptor designated as blocking ?
// - bool blocking (bool)
//   set my socket file descriptor (non)blocking
// - bool accept (int& fd)
//   accept a connection onto fd.
//   note: this will only work if I am listening (see derived classes)
// 
// Description:      hmmm
// 
// </class> 
class Socket : public HgFile {
public:
   Socket() ;
   Socket (int fd) ;
   virtual ~Socket() ;

   virtual bool close() ;
   void attach (int fd) ;

   bool blocking() const { return blocking_; }
   bool blocking (bool) ;

   bool listening() const { return get_listening_(); }

   // this is a quick hack just to set the listening_ flag. used when
   // attach()ing a file number which is already listsneing.
   void listening (bool b) { set_listening_(b); }

   bool accept (int& fd) ;
   bool accept (SocketPtr&) ;
// gorasche 150796 NT needs other commands on sockets
#ifdef WIN32
   int write (const char* buf, int nbytes) ;
   int read (char* buf, int nbytes) ;
#endif

protected:
   void set_listening_(bool) ;
   bool get_listening_() const { return listening_; }

   // just wrapped around the system accept()
   int accept_(struct sockaddr*, int* addrlen) ;

private:
   bool blocking_ ;
   bool listening_ ;

   static bool check_blocking_(int fd) ;
   static bool set_blocking_(int fd, bool) ;

private:
   Socket (const Socket&) {}
   Socket& operator = (const Socket&) { return *this; }

public:
   static const char* version1 ;
} ;
static const char* hg_utils_socket_version = Socket::version1 ;

SmartPtrdeclare (SocketPtr, Socket) 


#endif
