/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com>
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */

/* This is biggggggggggg on externs and stuff... Not all that sure that they
 * can be weened down either.. :\
 */

#include <stdio.h>
#include <sys/stat.h>
#include "config.h"
#include "rcfile.h"
#include <gnome.h>
#include "protocol.h"
#include "misc.h"
#include "gcommon.h"

#include "changes.h"
#include "excludes.h"
#include "site_widgets.h"
#include "file_widgets.h"
#include "operations.h"

int generate_pixmaps (void);
extern struct site_t *all_sites;
extern GtkWidget *site_tree, *status_bar;

bool rcfile_saved = true;

extern char *copypath, *rcfile;

/* Global widgets */
extern GtkWidget *main_area_box, *area_data;
extern GtkWidget *the_tree, *popup_win;
GtkWidget *error_log_list, *error_log_window;

/* External widgets */
extern GtkWidget *excludes_clist, *excludes_entry;
/*extern GtkWidget *name_map_clist, *name_map_local_entry, *name_map_remote_entry;*/
extern GtkWidget *main_app_window;

/* External icons */
extern GdkPixmap *closed_dir, *open_dir;
extern GdkPixmap *red_file, *green_file, *orange_file;
extern GdkBitmap *dir1_map, *dir2_map;
extern GdkBitmap *red_file_map, *green_file_map, *orange_file_map;

struct site_info *area_contents_s;

struct site_t *selected_site;
GtkCTreeNode *current_site_node;
GtkCTreeNode *site_item, *file_item;

extern int exclude_row;
extern struct proto_driver ftp_driver;
#ifdef USE_DAV
extern struct proto_driver dav_driver;
#endif
GList *errors;

GtkWidget *sitename_entry, *localpath_entry, *remotepath_entry;

/******************************************/

void color_site_node (GtkCTreeNode *node, struct site_t *site) {
 /* Implement this once you can auto generate code for a prefs dialog
  * to make it configurable.
   if (site->is_different) {
      gtk_ctree_node_set_foreground   (the_tree,
				       node,
				       color);
   }*/
}

/* Copies selected_site's infofile to infofile.bak */

void backup_infofile(void) {
  gchar *backup_name;
  int ret;

  if (!selected_site) {
    fe_status ("No site selected. Cannot backup anything.");
    return;
  }
  backup_name = malloc (BUFSIZ);
  strcpy(backup_name, selected_site->infofile);
  strcat (backup_name, ".bak");
  DEBUG(DEBUG_GNOME, "selected infofile is %s\n", selected_site->infofile);
  ret = copy_a_file(selected_site->infofile, backup_name);
  free (backup_name);
   switch (ret) {
   case 1: 
     fe_status ("Could not open infofile");
     break;
   case 2:
     fe_status ("Could not write backup file");
     break;
   case 0:
     fe_status ("The state of your files has been backed up.\nCare should be taken if restoring this state, which may be done at a later date from the backup menu.");
     break;
   default:
     fe_status ("Something is probably broken here.");
  }
}

void backup_rcfile (void) {
   gchar *rcbackup;
   gint ret;
   rcbackup = malloc (BUFSIZ);
   strcpy (rcbackup, rcfile);
   strcat (rcbackup, ".bak");
   ret = copy_a_file (rcfile, rcbackup);
   free (rcbackup);
   switch (ret) {
    case 1:
      fe_status ("Could not open the rcfile. That is not good.");
      break;
    case 2: 
      fe_status ("Could not create backup file.");
      break;
    case 0:
      fe_status ("The details of your sites have been backed up.");
      break;
    default:
      break;
   }
}

void restore_rcfile (void) {
   struct stat *backup_file;
   gchar *question, *backup_name;
   
   backup_name = malloc (BUFSIZ);
  strcpy(backup_name, rcfile);
  strcat (backup_name, ".bak");
  backup_file = malloc (sizeof (struct stat));

  if ( stat (backup_name, backup_file) == -1) {
    fe_status ("Could not find backup rcfile. Site configurations not restored.");
    free (backup_name);
    free (backup_file);
    return;
  }
  question = malloc (BUFSIZ);
  sprintf (question, "The last backup of your rcfile was modified on %s.\nAre you sure you wish to restore the site details from that date?", ctime(&(backup_file->st_ctime)));
  fe_gtk_question (question, (GnomeReplyCallback) restore_rc);
   free (question);
    free (backup_name);
    free (backup_file);
}

void restore_rc (gint button_number) {
   gint ret;
   gchar *rcfile_backup;

   if (button_number == GNOME_YES) {
      rcfile_backup = malloc (strlen (rcfile) + 5);
      strcpy(rcfile_backup, rcfile);
      strcat (rcfile_backup, ".bak");

      ret = copy_a_file (rcfile_backup, rcfile);
      switch (ret) {
       case 1:
	 fe_status ("Could not open a backup");
	 break;
       case 2:
	 fe_status ("Could not write to your rcfile");
	 break;
       case 0:
	fe_status ("Backup restored. Currently you will need to restart XSitecopy now.");
	 break;
       default:
	 printf ("there was a problem restoring.\n");
	 break;
      }
      free (rcfile_backup);
   }
}

int copy_a_file (gchar *input_name, gchar *output_name) {
   FILE *input, *output;
   gchar *buffer, *backup_name;
   
   if ( (input = fopen ( input_name, "r")) == NULL) {
      return 1;
    } else if ( (output = fopen (output_name, "w")) == NULL) {
      return 2;
    } else {
      buffer = malloc (BUFSIZ);
      while (fgets(buffer, BUFSIZ, input) != NULL) {
	fputs (buffer, output);
	memset (buffer, 0, BUFSIZ);
      }
      free(buffer);
      fclose (input);
      fclose (output);
      return 0;
    }
}

void restore_infofile(void) {
  struct stat *backup_file;
  gchar *question, *backup_name;

  if (!selected_site) {
    fe_status ("You must select a site to restore information about.");
    return;
  }
  backup_name = malloc (BUFSIZ);
  strcpy(backup_name, selected_site->infofile);
  strcat (backup_name, ".bak");
  backup_file = malloc (sizeof (struct stat));
  DEBUG(DEBUG_GNOME, "backup is %s\n", strcat (selected_site->infofile, ".bak"));
  if ( stat (backup_name, backup_file) == -1) {
    fe_status ("Could not find backup info file. File state not restored.");
    free (backup_name);
    free (backup_file);
    return;
  }
  question = malloc (BUFSIZ);
  sprintf (question, "The last backup of your files' state was modified on %s.\nAre you sure you wish to restore the file states from that date?", ctime(&(backup_file->st_ctime)));
  fe_gtk_question (question, (GnomeReplyCallback) actual_restoration);
  free (question);
  free (backup_name);
  free (backup_file);
}

void actual_restoration (gint button_number) {
  gint ret;
  gchar *buffer, *backup_name;

  if (button_number == 0) {
    backup_name = malloc (BUFSIZ);
    strcpy(backup_name, selected_site->infofile);
    strcat (backup_name, ".bak");
    ret = copy_a_file (backup_name, selected_site->infofile);
     switch (ret) {
      case 1:
	fe_status ("Could not open the backup.");
	break;
      case 2:
	fe_status ("Could not open the infofile.");
	break;
      case 0:
	fe_status ("Backup restored. Currently you will need to restart XSitecopy now.");
/*	site_destroy (selected_site);
        site_readfiles (selected_site);
	refresh_selected();*/
	break;
      default:
	break;
     }
     free(backup_name);
  }
}

/* If mode is 0, the buttons will be save, quit, cancel.
 * otherwise just quit & cancel.
 */
GtkWidget*
create_quit_save_question (const char *question, int mode)
{
  GtkWidget *quit_save_question;
  GtkWidget *dialog_vbox6;
  GtkWidget *button12;
  GtkWidget *button13;
  GtkWidget *button14;
  GtkWidget *dialog_action_area6;

  quit_save_question = gnome_message_box_new (question,
                              GNOME_MESSAGE_BOX_INFO, NULL);
  gtk_object_set_data (GTK_OBJECT (quit_save_question), "quit_save_question", quit_save_question);
  gtk_window_set_policy (GTK_WINDOW (quit_save_question), FALSE, FALSE, FALSE);
  gnome_dialog_set_close (GNOME_DIALOG (quit_save_question), TRUE);

  dialog_vbox6 = GNOME_DIALOG (quit_save_question)->vbox;
  gtk_object_set_data (GTK_OBJECT (quit_save_question), "dialog_vbox6", dialog_vbox6);
  gtk_widget_show (dialog_vbox6);

  if (!mode) {
	 gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (quit_save_question),
														  "Save then quit", GNOME_STOCK_PIXMAP_SAVE_AS);
	 button12 = g_list_last (GNOME_DIALOG (quit_save_question)->buttons)->data;
	 gtk_widget_ref (button12);
	 gtk_object_set_data_full (GTK_OBJECT (quit_save_question), "button12", button12,
										(GtkDestroyNotify) gtk_widget_unref);
	 gtk_widget_show (button12);
	 GTK_WIDGET_SET_FLAGS (button12, GTK_CAN_DEFAULT);
  }

  gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (quit_save_question),
                                          "Just quit", GNOME_STOCK_PIXMAP_EXIT);
  button13 = g_list_last (GNOME_DIALOG (quit_save_question)->buttons)->data;
  gtk_widget_ref (button13);
  gtk_object_set_data_full (GTK_OBJECT (quit_save_question), "button13", button13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button13);
  GTK_WIDGET_SET_FLAGS (button13, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (quit_save_question), GNOME_STOCK_BUTTON_CANCEL);
  button14 = g_list_last (GNOME_DIALOG (quit_save_question)->buttons)->data;
  gtk_widget_ref (button14);
  gtk_object_set_data_full (GTK_OBJECT (quit_save_question), "button14", button14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button14);
  GTK_WIDGET_SET_FLAGS (button14, GTK_CAN_DEFAULT);

  dialog_action_area6 = GNOME_DIALOG (quit_save_question)->action_area;
  gtk_widget_ref (dialog_action_area6);
  gtk_object_set_data_full (GTK_OBJECT (quit_save_question), "dialog_action_area6", dialog_action_area6,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_grab_default (button14);
  return quit_save_question;
}

void quit_please (void) {
  GtkWidget *qs;
  int button;

  if (!rcfile_saved) {
	 /* if user wants question */
	 qs = create_quit_save_question("Some of your site definitions may not be saved.\nWhat would you like to do?", 0);
	 button = gnome_dialog_run_and_close (GNOME_DIALOG(qs));
	 switch(button) {
	 case -1:
		break;
	 case 0:
		/* How should we handle this if it fails? */
		rcfile_write (rcfile, all_sites);
		gtk_main_quit();
	 case 1:
		gtk_main_quit();
	 case 2:
		/* Dialog is already closed by default. */
		return;
	 default:
		return;
	 }
  } else {
	 qs = create_quit_save_question("Are you sure you want to quit?", 1);
	 button = gnome_dialog_run_and_close (GNOME_DIALOG(qs));
	 switch(button) {
	 case -1:
		break;
	 case 0:
		gtk_main_quit();
	 case 1:
		return;
		break;
	 default:
	 }
  }
}

gint exit_handler (GtkWidget *widget, GdkEvent *event, gpointer data) {
   return (TRUE);
}

void open_new_request (void) {
  filename_request (OPENNEW);
}

/* Reads the filename from the GtkFileSelection named passed to it, and takes 
 * appropriate action depending upon the filename.
 *
 * Success: the global variable all_sites now contains the sites held within
 * the filename selected in the FileSelection. The main ctree is also rebuilt.
 */

void open_newrc (GtkWidget *ok, GtkFileSelection *fileb) {
  struct site_t *new_sites, *old_sites;
  gchar *old_rcfile, *new_rcfile;
  gchar *tmp;
  gint new_status;
  struct stat *stat_tmp;

  if ( (new_rcfile = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fileb))) == NULL)
    return;

  stat_tmp = malloc (sizeof (struct stat));
  
  if (stat((const char *) new_rcfile, stat_tmp) != 0) {
    fe_status ("File does not exist!!");
    free (stat_tmp);
    return;
  }
  if (! S_ISREG(stat_tmp->st_mode)) {
    fe_status ("You must select an actual sitecopy configuration file, (rcfile).");
    free (stat_tmp);
    return;
  }

  DEBUG(DEBUG_GNOME, "new rcfile is %s.\n", new_rcfile);
  old_rcfile = strdup (rcfile);
  rcfile = new_rcfile;
  DEBUG(DEBUG_GNOME, "About to parse new rcfile...\n");
  new_status = rcfile_read(&new_sites);

  switch (new_status) {
  case RC_OPENFILE:
    fe_status ("Could not open file");
    return;
  case RC_DIROPEN:
    fe_status ("Could not open directory.");
    return;
  case RC_PERMS:
    fe_status ("Configuration file is not valid:\nPermissions are insecure.");
    return;
  case 0:
    DEBUG(DEBUG_GNOME, "New rcfile successfully loaded into memory.\n");
    break;
  case RC_CORRUPT:
    fe_status ("Not a valid sitecopy configuration file.\n");
    rcfile = old_rcfile;
    free (new_rcfile);
    return;
  }
  if (new_sites == NULL) {
    fe_status ("Creation of new sites failed - not a valid sitecopy configuration file?");
    /* Free up some memory */
    return;
  }
  old_sites = all_sites;
  all_sites = new_sites;
  free (old_sites);
  gtk_clist_clear (GTK_CLIST (the_tree));
  fill_tree_from_all_sites(the_tree);
}

void saveas_request (void) {
  filename_request (SAVEAS);
}

void save_sites_as (GtkWidget *ok, GtkFileSelection *fileb) {
  gchar *file_to_saveas;
  
  file_to_saveas = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fileb));
  DEBUG(DEBUG_GNOME, "saving as file: %s\n", file_to_saveas);
  if (rcfile_write (file_to_saveas, all_sites) != 0) {
    fe_status ("There was a problem saving your sites.");
  } else {
    fe_status ("Site definitions saved.");
  }
  gtk_widget_destroy (GTK_WIDGET (fileb));
}

void filename_request (gint mode_num) {
  GtkWidget *filebox;

  if (mode_num == OPENNEW) {
    filebox = gtk_file_selection_new ("Choose a new sitecopy rcfile to load.");
  } else if (mode_num == SAVEAS) {
    filebox = gtk_file_selection_new ("Save your site definitions to a file.");
  } else {
    fe_status ("error with dialog creation.");
  }
  gtk_signal_connect_object (GTK_OBJECT (filebox), "destroy",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			     GTK_OBJECT (filebox));
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filebox)->cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			     GTK_OBJECT (filebox));
  if (mode_num == OPENNEW) {
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filebox)->ok_button),
			"clicked", GTK_SIGNAL_FUNC (open_newrc), filebox);
  } else if (mode_num == SAVEAS) {
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filebox)->ok_button),
			"clicked", GTK_SIGNAL_FUNC (save_sites_as), filebox);
  } else {
    fe_status ("there was an error");
  }
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filebox)->ok_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			     GTK_OBJECT (filebox));
  gtk_widget_show (filebox);
}

int make_defaults (struct site_t *a_site) {
   a_site->server = (char *) malloc (140);
   strcpy (a_site->server, "new_server_name");
   a_site->username = (char *) malloc (40);
   strcpy (a_site->username, "your_username");
   a_site->password = (char *) malloc (40);
   strcpy (a_site->password, "password");
   a_site->url = (char *) malloc (250);
   strcpy (a_site->url, "http://localhost/");
   a_site->nodelete = TRUE;
   a_site->nooverwrite = FALSE;
   a_site->checkmoved = TRUE;
   a_site->ftp_pasv_mode = TRUE;
   a_site->files = NULL;
   a_site->files_tail = NULL;
   a_site->renames = NULL;
   a_site->excludes = NULL;
   a_site->numascii = 0;
   a_site->protocol = siteproto_ftp;
   a_site->driver = &ftp_driver;
   a_site->port = 0;
   a_site->perms = sitep_ignore;
   a_site->symlinks = sitesym_ignore;
   a_site->infofile = malloc (260);
   strcpy (a_site->infofile, copypath);
   /* Didn't think we'd have to set these, but now I think we do. */
   a_site->numnew = 0;
   a_site->numchanged = 0;
   a_site->numdeleted = 0;
   a_site->nummoved = 0;
   a_site->numunchanged = 0;
   return 1;
}


void add_site (GtkButton *apply_button, gpointer user_data) {
   int ret;
   /* popup because site_readfiles() usually takes bloody ages. */
   extern GtkWidget *popup_win;
   struct site_t *site_to_add;
   GtkCTreeNode *site_im_adding;
   gchar *name, *path, *tmppath, *remotepath, *tmp, *node_label[1];
   struct ctree_attachment *extra_info;
   struct create_site_widget_set *widgets;

   /* A couple of global variables used to find what has been selected with
    * respect to the wizard's option menus. These wouldn't be necessary if
    * the (option)menu API didn't suck so bad.
    */
   extern gchar *new_proto, *new_perms, *new_sym;

   DEBUG(DEBUG_GNOME, "started add_site.\n");

   widgets = (struct create_site_widget_set *) user_data;
   
   name = gtk_entry_get_text (GTK_ENTRY (widgets->name));
   if (name == NULL) {
      fe_status ("You must supply a name for the site.");
      return;
   }
   if (strlen (name) < 2) {
      fe_status ("You must supply a name for the site.");
      return;
   }
   DEBUG(DEBUG_GNOME, "Hi! My name is %s.\n", name);
   if (strstr (name, " ") != NULL) {
     fe_status ("The site's friendly name must contain no spaces.");
     return;
   }

   path = gnome_file_entry_get_full_path (GNOME_FILE_ENTRY (widgets->local_choice), 1);
   if (path == NULL) {
      fe_status ("You must provide a local path for the site.");
      return;
   }
   DEBUG(DEBUG_GNOME, "local path is %s.\n", path);

   tmppath = gtk_entry_get_text (GTK_ENTRY (widgets->remotedir_choice));
   if (tmppath == NULL) {
      fe_status ("You must provide a remote directory for the site.");
      return;
   }
   DEBUG(DEBUG_GNOME, "remote path is %s.\n", tmppath);

   /* Create a site with the correct defaults */
   site_to_add = malloc (sizeof (struct site_t));
   site_to_add->name = (char *) strdup (name);

   make_defaults(site_to_add);

   /* Sort out the remote directory */
   site_to_add->remote_root_user = malloc (strlen(tmppath)+1);
   strcpy (site_to_add->remote_root_user, tmppath);
   
   if (*tmppath == '~') {
      site_to_add->remote_isrel = TRUE;
   } else if (*tmppath == '/') {
      site_to_add->remote_isrel = FALSE;
   } else {
      fe_status ("The remote directory must begin with either a '/' or '~/'.");
      return;
   }
   
   /* Sort out the local directory */
   if (*path == '~') {
     site_to_add->local_isrel = TRUE;
   } else if (*path == '/') {
     site_to_add->local_isrel = FALSE;
   } else {
      fe_status ("The local directory must begin with either a '/' or '~/'.");
      return;
   }
   site_to_add->local_root_user = (char *) malloc (strlen(path) + 1);
   strcpy (site_to_add->local_root_user, path);

   strcat (site_to_add->infofile, name);
   DEBUG(DEBUG_GNOME, "infofile is %s\n", site_to_add->infofile);

   /* server/host name */
   tmp = gtk_entry_get_text (GTK_ENTRY (widgets->hostname_choice));
   if (tmp && (strlen(tmp)>2) ) { 
     /* Now we know exactly how much mem to use, we can free the 
      * arbitrary amount alloc'd in make_defaults() */
     free (site_to_add->server);
     site_to_add->server = (char *) malloc (strlen(tmp) + 1);
     strcpy (site_to_add->server, tmp);
   }
   
#ifdef USE_DAV
   /* Protocol */
   if (strcmp (new_proto, "webdav") == 0) {
     site_to_add->protocol = siteproto_http;
     site_to_add->driver = &dav_driver;
   }     
#endif /* USE_DAV */

   /* User name */
   tmp = gtk_entry_get_text (GTK_ENTRY (widgets->username_choice));
   if (tmp && (strlen(tmp)>1) ) { 
     free (site_to_add->username);
     site_to_add->username = (char *) malloc (strlen(tmp) + 1);
     strcpy (site_to_add->username, tmp);
   }
   
   /* Password */
   tmp = gtk_entry_get_text (GTK_ENTRY (widgets->password_choice));
   if (tmp && (strlen(tmp)>2) ) { 
     free (site_to_add->password);
     site_to_add->password = (char *) malloc (strlen(tmp) + 1);
     strcpy (site_to_add->password, tmp);
   }

   /* URL */
   tmp = gtk_entry_get_text (GTK_ENTRY (widgets->url_choice));
   if (tmp && (strlen(tmp)>2) ) { 
     free (site_to_add->url);
     site_to_add->url = (char *) malloc (strlen(tmp) + 1);
     strcpy (site_to_add->url, tmp);
   }

   /* 'update attributes' */
   if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widgets->checkdelete_choice)))
     site_to_add->nodelete = FALSE;
   if (!GTK_TOGGLE_BUTTON (widgets->checkmove_choice)->active)
     site_to_add->checkmoved = FALSE;
   if (!GTK_TOGGLE_BUTTON (widgets->passiveftp_choice)->active)
     site_to_add->ftp_pasv_mode = FALSE;
   if (GTK_TOGGLE_BUTTON (widgets->deletefirst_choice)->active)
     site_to_add->nooverwrite = TRUE;
   
   /* Permissions */
   if (strcmp (new_perms, "ignore") == 0) {
     site_to_add->perms = sitep_ignore;
   } else if (strcmp (new_perms, "exec") == 0) {
     site_to_add->perms = sitep_exec;
   } else if (strcmp (new_perms, "all") == 0) {
     site_to_add->perms = sitep_all;
   }

   /* Sym links */
   if (strcmp (new_sym, "ignore") == 0) {
     site_to_add->symlinks = sitesym_ignore;
   } else if (strcmp (new_sym, "follow") == 0) {
     site_to_add->symlinks = sitesym_follow;
   } else if (strcmp (new_sym, "maintain") == 0) {
     site_to_add->symlinks = sitesym_maintain;
   }

   /* We need to make sure we're not adding a pile of poo to the sites list. */
   
   ret = verifysite_gnome (site_to_add);
   DEBUG(DEBUG_GNOME, "verify site produced code %d on the new site.\n", ret);
   
   /* Tag this site onto the start of the sites list */
   site_to_add->next = all_sites;
   all_sites = site_to_add;
   
   /* Add the entry to the ctree */
   tmp = malloc (strlen(site_to_add->name) +
		 strlen(site_to_add->local_root_user) + 7);
   sprintf (tmp, "%s  (%s)", site_to_add->name, site_to_add->local_root);
   node_label[0] = tmp;
   site_im_adding = gtk_ctree_insert_node (GTK_CTREE (the_tree), NULL, NULL, node_label,
					   0, NULL, NULL, NULL, NULL, false, false);
   DEBUG(DEBUG_GNOME, "added node, now freeing memory and reading file information.\n");
   free (tmp);

   /* For some highly irritating reason this never worked even when i was
      creating the dialog properly.
   gtk_widget_show_all (popup_win);
   while (gtk_events_pending() > 0)
   gtk_main_iteration();*/

   site_readfiles (site_to_add);
   
   /* Create the file entries */
   populate_site_node (site_im_adding, site_to_add);
   gtk_ctree_sort_node (GTK_CTREE (the_tree), GTK_CTREE_NODE (site_im_adding));

   /* Add the pointer to the site */
   extra_info = malloc (sizeof (struct ctree_attachment));
   extra_info->file_or_site = IS_A_SITE;
   extra_info->info_struct = (void *) site_to_add;

   gtk_ctree_node_set_row_data (GTK_CTREE (the_tree), site_im_adding,
				(gpointer) extra_info);
   /* Colour it to reflect status */
   /*   color_site_node (GTK_CTREE_NODE (site_im_adding), site_to_add);*/
   gtk_ctree_select (GTK_CTREE (the_tree), GTK_CTREE_NODE (site_im_adding));
   if (GTK_TOGGLE_BUTTON (widgets->catchup_choice)->active) {
     catchup_selected(GNOME_YES, NULL);
   } else {
     initialize_selected(GNOME_YES, NULL);
   }
   DEBUG(DEBUG_GNOME, "Our work here is done.\n");
   rcfile_saved = false;
   /*gtk_widget_hide (popup_win);*/
   close_wizard();
   return;
}

void select_ctree_cb (GtkCTree *ctree, GtkCTreeNode *node, gpointer data) {
   GtkCTreeNode *parent;
   struct site_t *current_site;
   struct site_file_t *current_file;
   void *data_to_get;
   struct ctree_attachment *actual_data;
   
   /* Make sure that any changes have been confirmed on the selected site,
    * before selected_site gets changed. This seems to get automatically done
    * by the signal handler.
    */

   current_site = malloc (sizeof (struct site_t));
   if (GTK_CTREE_ROW (node)->parent == NULL) {   /* We're at the top level */
      if ( (data_to_get = gtk_ctree_node_get_row_data (GTK_CTREE (ctree), GTK_CTREE_NODE (node))) == NULL) {
	 DEBUG(DEBUG_GNOME, "\"Data get\" returned NULL. Oh dear.\n");
      }
      actual_data = (struct ctree_attachment *) data_to_get;
      if (actual_data->file_or_site != IS_A_SITE)
	 DEBUG(DEBUG_GNOME, "Somehow you've clicked on a site, but ended up with file data!\n");
      current_site = (struct site_t *) actual_data->info_struct;

      /* Make the data shared */
      selected_site = current_site;
      current_site_node = node;
      
      gtk_container_remove (GTK_CONTAINER (main_area_box), area_data);
      area_data = make_site_info_area (current_site);
      gtk_container_add (GTK_CONTAINER (main_area_box), area_data);
   } else if (GTK_CTREE_ROW (node)->parent != NULL) {

      parent = GTK_CTREE_ROW (node)->parent;

      /* Grab the file data from that row */
      if ( (data_to_get = gtk_ctree_node_get_row_data (GTK_CTREE (ctree), GTK_CTREE_NODE (node))) == NULL) {
	 DEBUG(DEBUG_GNOME, "\"Data get\" for the file returned NULL. Oh dear.\n");
      }
      actual_data = (struct ctree_attachment *) data_to_get;
      if (actual_data->file_or_site != IS_A_FILE)
	 DEBUG(DEBUG_GNOME, "Somehow you've clicked on a file, but ended up with site data!\n");
      current_file = (struct site_file_t *) actual_data->info_struct;

      /* Grab the site data from the file's parent */
      while (GTK_CTREE_ROW (parent)->parent != NULL) {
	 parent = GTK_CTREE_ROW(parent)->parent;
	 DEBUG(DEBUG_GNOME, "Assigned parent to node->parent.\n");
      }

      if ( (data_to_get = gtk_ctree_node_get_row_data (GTK_CTREE (ctree), GTK_CTREE_NODE (parent))) == NULL) {
	 DEBUG(DEBUG_GNOME, "\"Data get\" for the file's parent returned NULL. Oh dear.\n");
      }
      actual_data = (struct ctree_attachment *) data_to_get;
      if (actual_data->file_or_site != IS_A_SITE)
	 DEBUG(DEBUG_GNOME, "Somehow you've clicked on a file, but it's parent was a file too!?\n");
      current_site = (struct site_t *) actual_data->info_struct;
      selected_site = current_site;
      current_site_node = parent;      
      if (current_file == NULL) {
	 fe_status ("Unable to access info about the selected file.");
      } else {
	 gtk_container_remove (GTK_CONTAINER (main_area_box), area_data);
	 area_data = make_file_info_area (current_file);
	 gtk_container_add (GTK_CONTAINER (main_area_box), area_data);
      }
   } else {
      g_print ("If you got to here, something is really buggered, quite frankly.\n");
   }
}

GtkWidget *create_default_main_area (void) {
   GtkWidget *vbox, *label;
   
   vbox = gtk_vbox_new (FALSE, 5);
   label = gtk_label_new ("No site is currently selected.\n\nPlease choose one from the tree view\non the left before proceeding with any more operations.");
   gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 10);
   gtk_widget_show (label);
   
   gtk_widget_show (vbox);
   return vbox;
}

GtkWidget *create_initial_main_area (void) {
   GtkWidget *vbox, *label;
   gchar *summary;
   gint num_that_need_updates = 0;
   struct site_t *tmp_site;
   
   vbox = gtk_vbox_new (FALSE, 10);
   /* TODO: Add some checking to see if this is the first time they've run sitecopy,
    * change greeting accordingly. 
    */
   label = gtk_label_new ("\nWelcome to XSitecopy!\n\n");
   gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 10);
   gtk_widget_show (label);
   
   for (tmp_site = all_sites; tmp_site != NULL; tmp_site = tmp_site->next) {
      if (tmp_site->is_different) {
	 summary = (char *) malloc (strlen (tmp_site->name) + 32);
	 sprintf (summary, "The site '%s' requires an update.", tmp_site->name);
	 label = gtk_label_new (summary);
	 gtk_widget_show (label);
	 free (summary);
	 gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 1);
	 num_that_need_updates++;
      }
   }
   if (all_sites == NULL) {
      label = gtk_label_new ("Click on \"New site\" to begin using the program.");
      gtk_widget_show (label);
      gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 10);
      
   } else if (num_that_need_updates == 0) {
      label = gtk_label_new ("All local sites are fully synchronized with the remote sites.");
      gtk_widget_show (label);
      gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 10);
   }
   gtk_widget_show (vbox);
   return vbox;
}

void site_report (void) {
   gtk_container_remove (GTK_CONTAINER (main_area_box), area_data);
   area_data = create_initial_main_area ();
   gtk_container_add (GTK_CONTAINER (main_area_box), area_data);
}

void site_web_report (void) {
   gchar lee[BUFSIZ];
   gchar *command_to_exec;
   
   if (selected_site == NULL) {
      fe_status ("For a report to be generated, a site must be selected.");
      return;
   }
   /* FIXME: path */
   sprintf (lee, "sitecopy -ll %s | awk -f changes.awk > /tmp/xsitecopy_report.html",
	    selected_site->name);
   command_to_exec = (gchar *) malloc (strlen (lee) + 1);
   /* Using snprintf to maybe try and add just a teeny bit of security? */
   snprintf (command_to_exec, (strlen(lee) + 1), lee);
   system (command_to_exec);
   system ("gnome-moz-remote --newwin /tmp/xsitecopy_report.html");
}

void redraw_main_area (void) {
   gtk_container_remove (GTK_CONTAINER (main_area_box), area_data);
   area_data = make_site_info_area (selected_site);
   gtk_container_add (GTK_CONTAINER (main_area_box), area_data);
}

void clear_main_area (void) {
   selected_site = NULL;
   gtk_container_remove (GTK_CONTAINER (main_area_box), area_data);
   area_data = create_default_main_area();
   gtk_container_add (GTK_CONTAINER (main_area_box), area_data);
}

void populate_site_node (GtkCTreeNode *site_node, struct site_t *current) {
   struct ctree_attachment *file_info_to_add;
   struct site_file_t *current_file;
   gchar *node_label[1];
   GtkCTreeNode *file_im_adding;
   extern gboolean fancy_tree;
   
   for (current_file = current->files; current_file != NULL; current_file = current_file->next ) {
     
     file_info_to_add = malloc (sizeof (struct ctree_attachment));
     file_info_to_add->file_or_site = IS_A_FILE;
     file_info_to_add->sorted_yet = MESSY;
     file_info_to_add->info_struct = (void *) current_file;
     node_label[0] = current_file->rel_local + 1;
     if (current_file->dir) {
       file_im_adding = gtk_ctree_insert_node (GTK_CTREE (the_tree), 
					       GTK_CTREE_NODE (site_node), NULL,
					       node_label, 3, closed_dir, 
					       dir1_map, open_dir, dir2_map,
					       false, false);
     } else {
       if (current_file->diff != file_unchanged) {
	 if (current_file->diff == file_changed) {
	   file_im_adding = gtk_ctree_insert_node (GTK_CTREE (the_tree), 
						   GTK_CTREE_NODE (site_node), NULL, node_label, 3,
						   orange_file, orange_file_map, 
						   orange_file, orange_file_map, 
						   FALSE, FALSE);
	 } else {
	   file_im_adding = gtk_ctree_insert_node (GTK_CTREE (the_tree), 
						   GTK_CTREE_NODE (site_node), NULL, node_label, 3,
						   red_file, red_file_map, 
						   red_file, red_file_map, 
						   FALSE, FALSE);
	 }
       } else { 
	 file_im_adding = gtk_ctree_insert_node (GTK_CTREE (the_tree), 
						 GTK_CTREE_NODE (site_node), NULL, node_label, 3,
						 green_file, green_file_map, 
						 green_file, green_file_map, 
						 FALSE, FALSE);
       }
     }
     gtk_ctree_node_set_row_data (GTK_CTREE (the_tree), file_im_adding,
				  (gpointer) file_info_to_add);
     file_item = file_im_adding;
     if (fancy_tree) {
	 if (current_file->dir) {
	   gtk_ctree_post_recursive (GTK_CTREE (the_tree), site_node,
				     GTK_CTREE_FUNC (check_dir), 
				     (gpointer) file_item);
	 }
     } /* fancy_tree */
   } /* for loop */
}  

/* This is all a bit hacky, and the growth rate is god awful */

int check_dir (GtkCTree *bler, GtkCTreeNode *node, gpointer data) {
   struct ctree_attachment *folder, *files, *info_to_add;
   GtkCTreeNode *tmp1, *just_moved;
   struct site_file_t *tmpy1, *tmpy2;
   char *folder_name;
   gchar *node_label2[1];
   
   /*folder = malloc (sizeof (struct ctree_attachment));*/
   tmp1 = GTK_CTREE_NODE (data);
   
   files = malloc (sizeof (struct ctree_attachment));
   
   files = (struct ctree_attachment *) gtk_ctree_node_get_row_data (GTK_CTREE (the_tree), GTK_CTREE_NODE (node));
   folder = (struct ctree_attachment *) gtk_ctree_node_get_row_data (GTK_CTREE (the_tree), GTK_CTREE_NODE (tmp1));

   if (files == NULL) {
      return 0;
   } else {
      if (files->sorted_yet == ORGANIZED) 
	return 2;
      if ( (tmpy1 = (struct site_file_t *) files->info_struct) == NULL)
	return 1;
   }
   if (folder == NULL) {
      return 0;
   } else {
      if ( (tmpy2 = (struct site_file_t *) folder->info_struct) == NULL)
	return 1;
   }

   /* ********************************
    * This is just not working when a port is specified in the rcfile.
    * It's madness, sheer madness.... 
    */
   
   /* Okay, so they're directories not folders. */
   folder_name = malloc (BUFSIZ);
   memset (folder_name, 0, BUFSIZ);
   if (tmpy2->rel_local == NULL)
     return 2;
   strcpy (folder_name, tmpy2->rel_local); 
   /* The 'tree' is the directory we're testing this file against, so the name
    * of tmpy2 (ie tmpy2->rel_local) is in fact the folder name. */
    
   folder_name = realloc (folder_name, strlen(folder_name) + 2);
   folder_name++;
    /* Directories have a trailing slash, file names don't, so i add one. */
   strcat (folder_name, "/");

    /* debugging */
/*   DEBUG(DEBUG_GNOME, "About to compare folder name (%s) with file's directory (%s).\n",
	 folder_name, tmpy1->directory);*/
   DEBUG(DEBUG_GNOME, "Folder's filename is: %s\n", tmpy2->rel_local);
   
   /* 'node' is the current node we're looking at from the post-recursion */
   if ( (tmpy1 != NULL) && (tmpy1->directory != NULL) && (folder_name != NULL) ) {
      if (strcmp (tmpy1->directory, folder_name) == 0) {
	 
	 /*      gtk_ctree_move (GTK_CTREE (the_tree), node, tmp1, NULL);*/
	 node_label2[0] = tmpy1->filename;
	 gtk_ctree_remove_node (GTK_CTREE (the_tree), node);
	 info_to_add = malloc (sizeof (struct ctree_attachment));
	 info_to_add->file_or_site = IS_A_FILE;
	 info_to_add->sorted_yet = ORGANIZED;
	 info_to_add->info_struct = (void *) tmpy1;
	 /* I want to set a different pixmap depending on file status, 
	  * so I do a quick comparison. */

	 if (tmpy1->diff != file_unchanged) {
	   if (tmpy1->diff == file_changed) {
	    just_moved = gtk_ctree_insert_node (GTK_CTREE (the_tree), 
						GTK_CTREE_NODE (file_item), NULL, node_label2, 3,
						orange_file, orange_file_map, 
						orange_file, orange_file_map, 
						FALSE, FALSE);
	   } else {
	     just_moved = gtk_ctree_insert_node (GTK_CTREE (the_tree), 
						 GTK_CTREE_NODE (file_item), NULL, node_label2, 3,
						 red_file, red_file_map, 
						 red_file, red_file_map, 
						 FALSE, FALSE);
	   }
	 } else { 
	   just_moved = gtk_ctree_insert_node (GTK_CTREE (the_tree), 
					       GTK_CTREE_NODE (file_item), NULL, node_label2, 3,
					       green_file, green_file_map, 
					       green_file, green_file_map, 
					       FALSE, FALSE);
	 }
	 gtk_ctree_node_set_row_data (GTK_CTREE (the_tree), GTK_CTREE_NODE (just_moved),
				      (gpointer) info_to_add);
      }
   }
    folder_name--;
    free (folder_name);
   return 2;
}

void check_site_and_record_errors(struct site_t *current) {
  char *errstr;
  int ret = rc_verifysite( current );
  if (!ret)
	 return;

  errstr = (char *) malloc (BUFSIZ);
  switch( ret ) {
	 /* Everything was fine */
  case 0:
	 return;
  case SITE_NOSERVER:
	 sprintf(errstr, _("Server not specified in site `%s'.\n"), 
				current->name );
	 break;
  case SITE_NOUSERNAME:
	 sprintf(errstr, _("Username not specified in site `%s'.\n"), 
				current->name );
	 break;
  case SITE_NOPASSWORD:
	 sprintf(errstr, _("Password not specified in site `%s'.\n"), 
				current->name );
	 break;
  case SITE_NOREMOTEDIR:
	 sprintf(errstr, _("Remote directory not specified in site `%s'.\n"), 
				current->name );
	 break;
  case SITE_NOLOCALDIR:
	 sprintf(errstr, _("Local directory not specified in site `%s'.\n"), 
				current->name );
	 break;
  case SITE_ACCESSLOCALDIR:
	 sprintf( errstr, _("Could not read directory for `%s':\n\t%s\n"), 
				 current->name, current->local_root );
	 break;
  case SITE_INVALIDPORT:
	 sprintf(errstr, _("Invalid port used in site `%s'.\n"),
				current->name );
	 break;
  case SITE_NOMAINTAIN:
	 sprintf(errstr, _("%s cannot maintain symbolic links (site `%s').\n"),
				current->driver->protocol_name, current->name );
	 break;
  case SITE_NOREMOTEREL:
	 sprintf(errstr, _("Cannot use a relative remote directory in %s (site `%s').\n"), current->driver->protocol_name, current->name );
	 break;
  case SITE_NOPERMS:
	 sprintf(errstr, _("The protocol you are attempting to use does\nnot currently support maintaining permissions."));
	 break;
  case SITE_NOLOCALREL:
	 sprintf(errstr, _("Could not find 'relative' local directory"));
  }
  errstr = realloc(errstr, strlen(errstr) + 1);
  errors = g_list_append(errors, errstr);
}

void fill_tree_from_all_sites(GtkWidget *a_ctree) {
   struct site_t *current;
   struct ctree_attachment *info_to_add;
   gchar tmp[100];
   gchar *node_label[1];
   int ret;

   for (current=all_sites; current != NULL; current = current->next) {

      /* This allocates some memory for each site, and stores the fact that
       * it is a _site_ plus a void pointer to the relavent data.
       * For use in the ctree. Time complexity improvements and all that.
       */
      info_to_add = malloc (sizeof (struct ctree_attachment));
      info_to_add->file_or_site = IS_A_SITE;
      info_to_add->info_struct = (void *) current;

      /* Make what's displayed next to the site name an option.
       * E.g. ftp server, or local dir. Remote dir even maybe? */
      
      sprintf (tmp, "%s  (%s)", current->name, current->local_root_user);
      node_label[0] = tmp;
      site_item = gtk_ctree_insert_node (GTK_CTREE (the_tree), NULL, NULL, node_label,
				     0, NULL, NULL, NULL, NULL, false, false);
      gtk_ctree_node_set_row_data (GTK_CTREE (the_tree), site_item,
				   (gpointer) info_to_add);
      
		/* Add any errors with the site to the errors list, so that we can
			present the user with all the errors, rather than popping lots of
			dialogs on screen at once.
		*/
		check_site_and_record_errors(current);
      /* Read site info */
      site_readfiles (current);
      /* Output file info onto the tree */
      populate_site_node (site_item, current);
      /* Colour the site node as required */
      color_site_node (GTK_CTREE_NODE (site_item), current);
      /* Sort stuff, just for fun */
      gtk_ctree_sort_node (GTK_CTREE (the_tree), GTK_CTREE_NODE (site_item));
   }
}

GtkWidget *ctree_create_sites (void) {
   the_tree = gtk_ctree_new (1, 0); 
   gtk_ctree_set_indent (GTK_CTREE (the_tree), 14);
   gtk_ctree_set_spacing (GTK_CTREE (the_tree), 4);
   gtk_ctree_set_line_style (GTK_CTREE (the_tree), GTK_CTREE_LINES_DOTTED);
   
   gtk_signal_connect (GTK_OBJECT (the_tree), "tree-select-row",
		       GTK_SIGNAL_FUNC (select_ctree_cb), NULL);
   fill_tree_from_all_sites(the_tree);
   gtk_widget_set_usize (the_tree, 150, -1);
   gtk_widget_show (the_tree);
   gtk_clist_set_column_auto_resize (GTK_CLIST (the_tree), 0, TRUE);
   return the_tree;
}

/* This whole refresh thing works as follows:
 * 
 * Clicking on refresh from the toolbar will call 'status_refresh' which
 * should set the pixmap of each node of the selected site correctly
 * according to changed status & file/dir status.
 * 
 * This should not be confused with the rescan functions which (will) reread
 * the local directory structure and then refresh the ctree accordingly.
 */

/* This all works apart from one itty bitty bug. It will be commented out as
 * soon as i find what's causing the bug, or someone sends me a patch.
 */

void refresh_node_pixmap (GtkCTree *tree, GtkCTreeNode *node) {
  struct ctree_attachment *attached;
  struct site_file_t *file_data;

  guint8 spaces;
  gchar *node_text;
  gboolean is_a_leaf, open;

/*  node_text = (gchar *) malloc (100);*/

  gtk_ctree_get_node_info (GTK_CTREE (tree),
			   GTK_CTREE_NODE (node),
			   &node_text, &spaces,
			   NULL, NULL, NULL, NULL,
			   &is_a_leaf, &open);
  DEBUG(DEBUG_GNOME, "node: %s - ", node_text);
  node_text = g_strdup(node_text);
  attached = malloc (sizeof (struct ctree_attachment));
  attached = (struct ctree_attachment *) gtk_ctree_node_get_row_data (GTK_CTREE (tree),
					  GTK_CTREE_NODE (node));
  if (attached->file_or_site != IS_A_FILE) {
    if (attached->file_or_site != IS_A_SITE)
      return;
    DEBUG(DEBUG_GNOME, "Node is not a file. Uh-oh.\n");
    return;
  }
  
  file_data = (struct site_file_t *) attached->info_struct;

  if (file_data->dir) {
    return;
  } else {
    if (file_data->diff != file_unchanged) {
      if (file_data->diff == file_changed) {
	gtk_ctree_set_node_info (GTK_CTREE (tree), 
				 GTK_CTREE_NODE (node),
				 node_text,
				 spaces, orange_file, orange_file_map,
				 orange_file, orange_file_map,
				 is_a_leaf, open);
	DEBUG(DEBUG_GNOME, "changed.\n");
      } else {
	gtk_ctree_set_node_info (GTK_CTREE (tree), 
				 GTK_CTREE_NODE (node),
				 node_text,
				 spaces, red_file, red_file_map,
				 red_file, red_file_map,
				 is_a_leaf, open);
	DEBUG(DEBUG_GNOME, "added, deleted or moved.\n");
      }
    } else {
	gtk_ctree_set_node_info (GTK_CTREE (tree), 
				 GTK_CTREE_NODE (node),
				 node_text,
				 spaces, green_file, green_file_map,
				 green_file, green_file_map,
				 is_a_leaf, open);
	DEBUG(DEBUG_GNOME, "unchanged.\n");
    }
  }
  g_free(node_text);
}

void refresh_selected (void) {
   pixmap_refresh (current_site_node);
}

void pixmap_refresh (GtkCTreeNode *a_site_node) {
   gtk_ctree_post_recursive (GTK_CTREE (the_tree), 
			     GTK_CTREE_NODE (a_site_node),
			     GTK_CTREE_FUNC (refresh_node_pixmap),
			     NULL);
}

/* GUI making functions.
 * Most of these were/will be made using Glade.
 */


void make_error_window (void)
{
  GtkWidget *dialog_vbox2;
  GtkWidget *label9;
  GtkWidget *sc_win;
  GtkWidget *label7;
  GtkWidget *label8;
  GtkWidget *dialog_action_area2;
  GtkWidget *cancel;

  error_log_window = gnome_dialog_new ("Errors during the recent update", NULL);
  gtk_object_set_data (GTK_OBJECT (error_log_window), "error_log_window", error_log_window);
  gtk_widget_set_usize (error_log_window, 567, 248);
  gtk_window_set_policy (GTK_WINDOW (error_log_window), TRUE, TRUE, FALSE);

  dialog_vbox2 = GNOME_DIALOG (error_log_window)->vbox;
  gtk_object_set_data (GTK_OBJECT (error_log_window), "dialog_vbox2", dialog_vbox2);
  gtk_widget_show (dialog_vbox2);

  label9 = gtk_label_new ("There were errors with the following files and/or directories:");
  gtk_widget_ref (label9);
  gtk_object_set_data_full (GTK_OBJECT (error_log_window), "label9", label9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), label9, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label9), 7.45058e-09, 0.5);

  sc_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (sc_win);
  gtk_object_set_data_full (GTK_OBJECT (error_log_window), "sc_win", sc_win,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sc_win);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), sc_win, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sc_win), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  error_log_list = gtk_clist_new (2);
  gtk_widget_ref (error_log_list);
  gtk_object_set_data_full (GTK_OBJECT (error_log_window), "error_log_list", error_log_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (error_log_list);
  gtk_container_add (GTK_CONTAINER (sc_win), error_log_list);
  gtk_clist_set_column_width (GTK_CLIST (error_log_list), 0, 265);
  gtk_clist_set_column_width (GTK_CLIST (error_log_list), 1, 80);
  gtk_clist_column_titles_show (GTK_CLIST (error_log_list));

  label7 = gtk_label_new ("File/Directory Name");
  gtk_widget_ref (label7);
  gtk_object_set_data_full (GTK_OBJECT (error_log_window), "label7", label7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label7);
  gtk_clist_set_column_widget (GTK_CLIST (error_log_list), 0, label7);

  label8 = gtk_label_new ("Error code/message");
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (error_log_window), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_clist_set_column_widget (GTK_CLIST (error_log_list), 1, label8);

  dialog_action_area2 = GNOME_DIALOG (error_log_window)->action_area;
  gtk_object_set_data (GTK_OBJECT (error_log_window), "dialog_action_area2", dialog_action_area2);
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area2), 8);

  gnome_dialog_append_button (GNOME_DIALOG (error_log_window), GNOME_STOCK_BUTTON_CLOSE);
  cancel = g_list_last (GNOME_DIALOG (error_log_window)->buttons)->data;
  gtk_widget_ref (cancel);
  gtk_object_set_data_full (GTK_OBJECT (error_log_window), "cancel", cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cancel);
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);

  gtk_signal_connect_object (GTK_OBJECT (error_log_window), "delete_event",
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (error_log_window));
  gtk_signal_connect_object (GTK_OBJECT (cancel), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (error_log_window));
}
   
GtkWidget*
create_site_errors_dialog ()
{
  GtkWidget *site_errors_dialog;
  GtkWidget *dialog_vbox2;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *hseparator1;
  GtkWidget *error_output;
  GtkWidget *sw;
  GtkWidget *dialog_action_area2;
  GtkWidget *button2;
  GList *current;

  site_errors_dialog = gnome_dialog_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (site_errors_dialog), "site_errors_dialog", site_errors_dialog);
  GTK_WINDOW (site_errors_dialog)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_position (GTK_WINDOW (site_errors_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (site_errors_dialog), FALSE, FALSE, FALSE);
  gnome_dialog_set_close (GNOME_DIALOG (site_errors_dialog), TRUE);

  dialog_vbox2 = GNOME_DIALOG (site_errors_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (site_errors_dialog), "dialog_vbox2", dialog_vbox2);
  gtk_widget_show (dialog_vbox2);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (site_errors_dialog), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox1, TRUE, TRUE, 0);

  label1 = gtk_label_new ("WARNING!\n\nThe following errors were encountered while examining\nyour site definitions. Unless corrected, Xsitecopy may fail\nto function properly.");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (site_errors_dialog), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator1);
  gtk_object_set_data_full (GTK_OBJECT (site_errors_dialog), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, TRUE, TRUE, 8);

  sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
											GTK_POLICY_NEVER,
											GTK_POLICY_AUTOMATIC);
  gtk_widget_show(sw);
  error_output = gtk_text_new (NULL, NULL);
  gtk_widget_ref (error_output);
  gtk_object_set_data_full (GTK_OBJECT (site_errors_dialog), "error_output", error_output,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (error_output);
  gtk_container_add(GTK_CONTAINER(sw), error_output);
  gtk_box_pack_start (GTK_BOX (vbox1), sw, TRUE, TRUE, 0);

  dialog_action_area2 = GNOME_DIALOG (site_errors_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (site_errors_dialog), "dialog_action_area2", dialog_action_area2);
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area2), 8);

  gnome_dialog_append_button (GNOME_DIALOG (site_errors_dialog), GNOME_STOCK_BUTTON_OK);
  button2 = g_list_last (GNOME_DIALOG (site_errors_dialog)->buttons)->data;
  gtk_widget_ref (button2);
  gtk_object_set_data_full (GTK_OBJECT (site_errors_dialog), "button2", button2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button2);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);

  for (current = errors; current; current=current->next) {
	 gtk_text_insert(GTK_TEXT (error_output), 
						  NULL, NULL, NULL,
						  (const char *) current->data, -1);
	 g_free (current->data);
  }
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (site_errors_dialog));
  errors = NULL;
  gtk_widget_grab_default (button2);
  return site_errors_dialog;
}


