/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */
#include <unistd.h>
#include <sys/stat.h>
#include "init.h"
#include "config.h"
#include "misc.h"
#include "operations.h"
#include "resynch.h"
#include "new_site.h"
#include "rcfile.h"

GtkWidget *site_tree, *app_bar;
GtkWidget *main_area_box, *area_data, *the_tree;
GtkWidget *popup_win, *popup_label, *popup_frame;
bool site_keepgoing = FALSE;
extern GtkWidget *sitecopy;
extern struct site_t *all_sites;

int create_about (void) {
   GtkWidget *about_window;
   gchar *people[] = { "Lee Mallabone <lee0@callnetuk.com>", "Joe Orton <joe@orton.demon.co.uk>", NULL };
   about_window = gnome_about_new ("XSitecopy", VERSION, "Copyright (C) 1999 Lee Mallabone", people,
				   "XSitecopy is the official GNOME front end to sitecopy.\nSitecopy is for copying locally stored websites to remote web servers.", NULL);
   gtk_widget_show (about_window);
   return 1;
}

int create_main_window(void) {
   GtkWidget *ctree_scroller, *app_contents, *panes;
   
   /* MENUS */
   static GnomeUIInfo file_menu[] = {
	{ GNOME_APP_UI_ITEM, N_("_New site..."), N_("Create a new site definition"), start_new_site_wizard, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 'n', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_ITEM, N_("_Open..."), N_("Open a new rc file. (EXPERIMENTAL)."), open_new_request, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 'o', GDK_CONTROL_MASK, NULL 
	},
	{ GNOME_APP_UI_ITEM, N_("_Save Sites"), N_("Save the current site definitions"), save_default, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 's', GDK_CONTROL_MASK, NULL 
	},
	{ GNOME_APP_UI_ITEM, N_("Sav_e Sites As..."), N_("Save the current site definitions to a file."), saveas_request, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 'e', GDK_CONTROL_MASK, NULL 
	},
	{ GNOME_APP_UI_ITEM, N_("_Delete this site"), N_("Delete the selected site entry"), delete_a_site, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 'w', GDK_CONTROL_MASK, NULL 
	},
      
      GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("E_xit"), N_("Exit the program"), quit_please, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 'q', GDK_CONTROL_MASK, NULL 
	},
      
      GNOMEUIINFO_END
   };

      static GnomeUIInfo ops_menu[] = {
	{ GNOME_APP_UI_ITEM, N_("_Initialise site"), N_("All files will be uploaded if a site is initialised"), fe_init_site, NULL, NULL,
	   GNOME_APP_PIXMAP_NONE, NULL, 'i', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_ITEM, N_("'_Catchup' site"), N_("Records the site as already updated."), fe_catchup_site, NULL, NULL,
	   GNOME_APP_PIXMAP_NONE, NULL, 'c', GDK_CONTROL_MASK, NULL 
	},
	{ GNOME_APP_UI_ITEM, N_("_Fetch site listing"), N_("Figures out which files are new/changed from the actual remote site."), fetch_site_list_please, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REVERT, 'f', GDK_CONTROL_MASK, NULL 
	},
      GNOMEUIINFO_SEPARATOR,
      	{ GNOME_APP_UI_ITEM, N_("_Resynchronize site"), N_("Copies newer files from the remote site to the local drive."), NULL, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH, 'y', GDK_CONTROL_MASK, NULL 
	},
        { GNOME_APP_UI_ITEM, N_("_Update site..."), N_("Apply the local site's changes to the remote site."), NULL, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REDO, 'u', GDK_CONTROL_MASK, NULL 
	},
	{ GNOME_APP_UI_ITEM, N_("Update _ALL sites"), N_("Performs the required operations on all site definitions. (TODO)."), NULL, NULL, NULL,
	   GNOME_APP_PIXMAP_NONE, NULL, 'e', GDK_CONTROL_MASK, NULL 
	},
      
      GNOMEUIINFO_END
   };

   static GnomeUIInfo report_menu[] = {
      	{ GNOME_APP_UI_ITEM, N_("_Required updates"), N_("Displays a brief report of any required updates."), site_report, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 'r', GDK_CONTROL_MASK, NULL 
	},
      	{ GNOME_APP_UI_ITEM, N_("Site web-r_eport"), N_("Generates a web page detailing the changes required on the selected site."), site_web_report, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 'e', GDK_CONTROL_MASK, NULL 
	},
      	{ GNOME_APP_UI_ITEM, N_("Prin_t site info..."), N_("Print information about the selected site"), NULL, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT, 't', GDK_CONTROL_MASK, NULL 
	},
      GNOMEUIINFO_END
   };
   static GnomeUIInfo backup_menu[] = {
      	{ GNOME_APP_UI_ITEM, N_("_Backup files status"), N_("Save the 'state' of your local files, in case of accident."), backup_infofile, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 'b', GDK_CONTROL_MASK, NULL 
	},
      	{ GNOME_APP_UI_ITEM, N_("Restore files status..."), N_("If a backup has previously been made, it will be restored."), restore_infofile, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 'r', GDK_CONTROL_MASK, NULL 
	},
	GNOMEUIINFO_SEPARATOR,
      	{ GNOME_APP_UI_ITEM, N_("_Backup site definitions"), N_("Backup your site definitions, in case you delete your sites."), backup_rcfile, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 't', GDK_CONTROL_MASK, NULL 
	},
      	{ GNOME_APP_UI_ITEM, N_("Restore site definitions..."), N_("If a backup has previously been made, it will be restored."), restore_rcfile, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 'r', GDK_CONTROL_MASK, NULL 
	},
      GNOMEUIINFO_END
   };
	    
   static GnomeUIInfo prefs_menu[] = {
	{ GNOME_APP_UI_ITEM, N_("Preferences..."), N_("Performs the required operations on all site definitions. (TODO)."), NULL, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF, 'p', GDK_CONTROL_MASK, NULL 
	},
      
      GNOMEUIINFO_END
   };

   static GnomeUIInfo help_menu[] = {
	{ GNOME_APP_UI_ITEM, N_("_About XSitecopy"), N_("Information about XSitecopy"),
	   create_about, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL 
	},
      
      GNOMEUIINFO_SEPARATOR,
      GNOMEUIINFO_HELP ("xsitecopy"),
      GNOMEUIINFO_END
   };
   
   static GnomeUIInfo main_menu[] = {   
      GNOMEUIINFO_SUBTREE (N_("_File"), file_menu),
      GNOMEUIINFO_SUBTREE (N_("_Operations"), ops_menu),
      GNOMEUIINFO_SUBTREE (N_("_Reports"), report_menu),
      GNOMEUIINFO_SUBTREE (N_("_Settings"), prefs_menu),
      GNOMEUIINFO_SUBTREE (N_("_Backup"), backup_menu),
      GNOMEUIINFO_SUBTREE (N_("_Help"), help_menu),
      GNOMEUIINFO_END
   };

   /* TOOLBAR */

      static GnomeUIInfo main_toolbar[] = {
	{ GNOME_APP_UI_ITEM, N_("New site"), N_("Create a new site definition"), start_new_site_wizard, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_NEW, 'n', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_ITEM, N_("Open"), N_("Open a new site definitions file."), open_new_request, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_OPEN, 'o', GDK_CONTROL_MASK, NULL 
	},
	{ GNOME_APP_UI_ITEM, N_("Save Sites"), N_("Save the current site definitions"), save_default, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE, 's', GDK_CONTROL_MASK, NULL 
	},
	{ GNOME_APP_UI_ITEM, N_("Delete site"), N_("Delete the selected site"), delete_a_site, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CUT, 'w', GDK_CONTROL_MASK, NULL 
	},

	 GNOMEUIINFO_SEPARATOR,
      	{ GNOME_APP_UI_ITEM, N_("Initialise site"), N_("Initialise the site (mark all files as needing to be updated)."), fe_init_site, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_ABOUT, 'i', GDK_CONTROL_MASK, NULL 
	},
      	{ GNOME_APP_UI_ITEM, N_("'Catchup' site"), N_("Mark all of the selected site's files as updated."), fe_catchup_site, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_ABOUT, 'c', GDK_CONTROL_MASK, NULL 
	},
      
      GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("Download site"), N_("Download newer files from the remote site. (Use with care)"), GTK_SIGNAL_FUNC (main_update_please), NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_UNDO, 'u', GDK_CONTROL_MASK, NULL 
	},
	 
        { GNOME_APP_UI_ITEM, N_("Update site"), N_("Updates the selected site"), GTK_SIGNAL_FUNC (main_update_please), NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_REDO, 'u', GDK_CONTROL_MASK, NULL 
	},

	{ GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit the program"), quit_please, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_EXIT, 'q', GDK_CONTROL_MASK, NULL 
	},
      
      GNOMEUIINFO_END
	};
 	extern GList *errors;
	GtkWidget *errs;
  
   /* MENUS */
   gnome_app_create_menus (GNOME_APP (sitecopy), main_menu);
   /* TOOLBARS */
   gnome_app_create_toolbar (GNOME_APP (sitecopy), 
			     main_toolbar);
   
   /* PANES */
   site_tree = ctree_create_sites();
   panes = gtk_hpaned_new ();
   gtk_paned_set_gutter_size (GTK_PANED (panes), 6);
   gtk_widget_show (panes);
   
   /* Arbitrary widget that holds all the site/file detailed info. */
   main_area_box = gtk_hbox_new (FALSE, 2);
   
   /* Widget is practically arbitrary */
   area_data = create_initial_main_area();
   /* FIXME: Add some default data to area_data */
   gtk_container_add (GTK_CONTAINER (main_area_box), area_data);
   gtk_widget_show (main_area_box);

   app_contents = gtk_vbox_new (FALSE, 0);
   ctree_scroller = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ctree_scroller),
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);
   gtk_widget_show (ctree_scroller);
   gtk_container_add (GTK_CONTAINER (ctree_scroller), site_tree);
   
   gtk_paned_pack1 (GTK_PANED (panes), ctree_scroller, false, false);
   gtk_paned_pack2 (GTK_PANED (panes), main_area_box, false, false);
   /*gtk_container_set_border_width (GTK_CONTAINER (GTK_PANED(panes)->child2), 5);*/

   /* APP BAR */
   app_bar = gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_USER);
   gtk_widget_show (app_bar);

   /* Add some hints and stuff */
   gnome_app_install_appbar_menu_hints (GNOME_APPBAR (app_bar),
					main_menu);

   /* Pack it all in */
   gtk_box_pack_start (GTK_BOX (app_contents), panes, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (app_contents), app_bar, FALSE, FALSE, 0);
   
   gnome_app_set_contents (GNOME_APP (sitecopy), app_contents);

   /* FIXME: remove all this once it gets implemented */
   gtk_widget_set_sensitive (ops_menu[2].widget, FALSE);  /* fetch */
   gtk_widget_set_sensitive (ops_menu[4].widget, FALSE); /* resynch */
   gtk_widget_set_sensitive (ops_menu[6].widget, FALSE); /* Update all */
   gtk_widget_set_sensitive (report_menu[1].widget, FALSE); /* web report */
   gtk_widget_set_sensitive (report_menu[2].widget, FALSE); /* print */
   gtk_widget_set_sensitive (prefs_menu[0].widget, FALSE); /* prefs */
   gtk_widget_set_sensitive (main_toolbar[8].widget, FALSE); /* resynch */

   /* SHOW IT ALL */
   gtk_widget_show (sitecopy);
	if (errors) {
	  errs = create_site_errors_dialog();
	  gtk_widget_show (errs);
	}
   return 1;
}

/* This gets the rcfile name, and calls the function
 * to load the sites list.
 * It will shortly: determine whether or not a "infofile" or sitecopy dir
 * exists, and if not do all the correct setup.
 */

int fe_gnome_init (void) {
  extern GList *errors;
   /* TODO: 
    * 
    * Use the gnome_config functions to
    * setup preferences for different aspects of the UI/default file
    * names. Put all the gnome_config calls in this function and rename.
    */
   extern gchar *rcfile, *copypath;
   struct stat *rc_stat, *info_dir_stat;
   char home_dir[BUFSIZ], rcfilename[BUFSIZ], infodirname[BUFSIZ];
   FILE *rc;
   
   strcpy (home_dir, getenv("HOME"));
   strcpy (rcfilename, home_dir);
   strcpy (infodirname, home_dir);

   strcat (rcfilename, "/.sitecopyrc");
   strcat (infodirname, "/.sitecopy/");
   
   rc_stat = malloc (sizeof (struct stat));
   info_dir_stat = malloc (sizeof (struct stat));

   if (stat ((const char *) rcfilename, rc_stat) != 0) {
      printf ("creating rc..\n");
      rc = fopen (rcfilename, "w");
      fclose (rc);
      chmod (rcfilename, 00600);
   }
   
   if (stat ((const char *) infodirname, info_dir_stat) != 0) {
      if (mkdir (infodirname, 00700) != 0) {
	 printf ("could not create required config directory.\n");
      }
      chmod (infodirname, 00700);
   }
   
   /* FIXME: Handle the return value of rcfile_read and show correct error message */
//   mkdir (infodirname, 00600);
   init_env();
   
   init_paths();

	/* FIXME: show these errors properly */
   if (init_netrc() != 0) {
      printf ("There was a problem parsing your .netrc file.\n");
      exit(-1);
   }
   if( rcfile_read (&all_sites) ) {
      printf( "Error: Could not read rcfile: %s.\n",
	     rcfile );
      exit(-1);
   }
   return 1;
}
