/*  Screem:  bluefishfn.c,
 *  Creates nodes for the tag tree by parsing the function files supplied
 *  with the Bluefish html editor
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <gnome.h>

#include <gnome-xml/debugXML.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

#include "tag_tree.h"


#define BUFFER_SIZE 2048

static GList *g_name = NULL;  /* group name */
static GList *g_node = NULL;  /* group node */

static GtkCTreeNode* get_node( GtkCTree *tree, GtkCTreeNode *parent, 
			       gchar *line );

void add_bluefish_fn( GtkCTree *tree )
{
	const gchar *home;
	
	/* 
	 * the first element in a pair is the file name, the second is
	 * the group name for the tag tree
	 */
	gchar *fn_files[] = {
		"php3_functions", "PHP3",
		"rxml_functions", "RXML",
		"ssi_functions", "SSI",
		NULL
	};

	gchar *fn_path;
	gchar *fn_file;
	gint i;

	FILE *file;
	gchar buffer[ BUFFER_SIZE + 1 ];
	gchar *data;
	gint size;

	gchar *search;
	gchar *line;

	gchar *text[ 2 ] = { NULL, NULL };
	GtkCTreeNode *node;
	GtkCTreeNode *nnode;

	GList *list;

	home = g_get_home_dir();

	fn_path = g_strjoin( G_DIR_SEPARATOR_S, home, ".bluefish", NULL );

	for( i = 0; fn_files[ i ]; i += 2 ) {
		fn_file = g_strjoin( G_DIR_SEPARATOR_S, fn_path, fn_files[ i ],
				     NULL );
		if( ( file = fopen( fn_file, "r" ) ) ) {
			data = "";
			while(( size = fread(buffer, 1, BUFFER_SIZE, file) )) {
				buffer[ size ] = 0;
				data = g_strconcat( data, buffer, NULL );
			}
			/* file now read, start processing */
			search = data;
			text[ 0 ] = fn_files[ i + 1 ];
			node = gtk_ctree_insert_node( tree, NULL, NULL, 
						      text, 3, 
						      NULL, NULL, NULL, NULL, 
						      FALSE, FALSE );
			while( ( line = strtok( search, "\n" ) ) ) {
				nnode = get_node( tree, node, line );
				search = NULL;
			}
			fclose( file );
			g_free( data );
		}
	}

	for( list = g_name; list; list = list->next )
		g_free( list->data );
	g_list_free( g_name );
	g_list_free( g_node );
       
	g_free( fn_path );
}

static GtkCTreeNode* get_node( GtkCTree *tree, GtkCTreeNode *parent, 
			       gchar *line )
{
	gchar *group;
	gchar *function;
	
	GList *list;
	gint num = 0;
	gboolean found = FALSE;

	GtkCTreeNode *pnode;
	GtkCTreeNode *node;
	gchar *text[ 2 ] = { NULL, NULL };

	Tag_data *td;

	group = line;
	function = strchr( group, ':' );
	*function = 0;
	function ++;
	function = g_strdup( function );

	/* find group in g_name */
	for( list = g_name; list && ! found ; list = list->next ) {
		num ++;
		found = ! strcmp( group, (gchar*)list->data );
	}

	if( found ) {
		list = g_list_nth( g_node, --num );
		pnode = list->data;
	} else {
		text[ 0 ] = group;
		pnode = gtk_ctree_insert_node( tree, parent, NULL, 
					       text, 3, NULL, NULL, NULL, 
					       NULL, FALSE, FALSE );
		g_name = g_list_append( g_name, g_strdup( group ) );
		g_node = g_list_append( g_node, pnode );
	}

	/* add the function as a child of pnode */
	text [ 0 ] = function;
	node = gtk_ctree_insert_node( tree, pnode, NULL, 
				      text, 3, NULL, NULL, NULL, 
				      NULL, TRUE, FALSE );

	td = g_new( Tag_data, 1 );
	td->open = function;
	td->close = NULL;
	gtk_ctree_node_set_row_data( GTK_CTREE( tree ), node, td );


	return node;
}
