#ifndef PLUGIN_H
#define PLUGIN_H

void scan_plugins( GtkWidget *output );
GtkWidget* screem_build_scripts_menu( void );


/* Script plugins:
 *
 * stdout requests:
 *   plugins can make requests on stdout, the following are supported:
 * CURSOR_POS [ pos ]  - if a pos is given the plugin is setting the cursor
 *                       position, otherwise requesting it
 * INSERT text pos  - insert text at position pos, if pos == -1 then 
 *                    insert at the current cursor position
 * DELETE num [ pos ] - delete num chars at pos or cursor position
 *
 * BUFFER - buffer the current pages text
 *
 * CURRENT - requests the current pages text be sent
 *
 * 
 *
 */

/* a value based on these is to be outputed by every script plugin when
   given the init argument */
typedef enum _ScriptFeatures {
	INIT = 0,  /* 0 as its assumed to be always present, included for 
		      completness */
	MODAL = 1 << 0,  /* the plugin wants to run modally */
} ScriptFeatures;

typedef struct _Script {
	gchar *exec;     /* the name of the program to execute */
	gboolean modal;  /* if the plugin in is to be executed modally */
	gint features;   /* a bitmap of arguments this plugin supports */
	gchar *path;     /* the menu path */
} Script;

#endif
