################################################################
# $Id: DateSelect.pm,v 1.7 1999/05/30 06:55:45 kenji Exp $

package HNS::DateSelect;

use strict;
use ObjectTemplate;
@HNS::DateSelect::ISA = qw(ObjectTemplate);
@HNS::DateSelect::EXPORT = qw(attributes);

use HNS;
use HNS::Template;
use HNS::System;
use DateTime::Date;

attributes qw(month_all start_year);
################################################################
# configuration static variabes
#
use vars qw($YearTemplate $MonthTemplate $DayTemplate
	    $AllLabel);

$YearTemplate = "%year";
$MonthTemplate = "%month";
$DayTemplate = "%start_day  %end_day";
$AllLabel = "ALL";

################################################################
sub AsHTML ($;$$$)
{
    my ($self,  $year, $month, $day, $SubmitLabel) = @_;
    my $templ = new HNS::Template;
    my $html;

    # year
    $html .= qq(\n<select name="YEAR">\n);
    for (reverse ($HNS::System::StartYear..$HNS::Status->start_time->year)){
	my $selected = (defined $year && $year == $_)? 'selected' : '';
	$html .= qq(<option value="$_" $selected>);
	$html .= $templ->Expand($YearTemplate, {year=>$_});
	$html .= qq(</option>\n);
    }
    $html .= qq(</select>\n);
    # month
    $html .= qq(<select name="MONTH">\n);
    for (1..12){
	$_ = sprintf("%02d", $_);
	my $selected = (defined $month && $month == $_)? 'selected' : '';
	$html .= qq(<option value="$_" $selected>);
	$html .= $templ->Expand($MonthTemplate, {month=>$_});
	$html .= qq(</option>\n);
    }
    $html .= qq(<option value="ALL">$AllLabel</option>\n)
	if $self->month_all;
    $html .= qq(</select>\n);
    # day
    $html .= qq(<select name="DAY">\n);
    for (0..3){
	my $start = $_*10 || 1;
	my $end = ($_<3) ? $_*10+9 : '';
	my $selected = (defined $day && $day =~ /^$_/)? 'selected' : '';
        $selected = "" if $self->month_all;
	$html .= qq(<option value="$_" $selected>);
	$html .= $templ->Expand($DayTemplate,
				{start_day=>$start,
				 end_day=>$end});
	$html .= qq(</option>\n);
    }
    my $selected = "selected" if $self->month_all;
    $html .= qq(<option value="ALL" $selected>$AllLabel</option>\n);
    $html .= qq(</select>\n);
    # submit
    $html .= qq(<input type="submit" value="$SubmitLabel">\n);
#    $html .= qq(</form><hr>);
    return $html;
}    

1;

