#ifndef ___ARENA_DISPLAY_TYPES_H___
#  define ___ARENA_DISPLAY_TYPES_H___


#include <X11/Xlib.h>

#include "forms_types.h"
#include "neweditor_types.h"


/* Straight forward analog of the XRectnagle, but the type of `y',
 * we need it `long', rather than `int'.
 */
typedef struct
{
 int          x;	/* view window indent from left side of the document */
 long         y;	/* view window offset from the top of the document */
 unsigned int width;	/* view window  width */
 unsigned int height;	/* view window height */
} ViewRectangle;


typedef struct { Window win ; ViewRectangle rect ; } ViewWindow;

typedef struct
{
 ViewWindow VieW;	/* document viewing window */
 struct Doc* doc;	/* document currently displayed in the window */

 Bool already_displayed;

 Bool show_raw;		/* for html docs, show raw data? */
 long parsed_length;
 char* paint_stream;
 long  paint_length;
 unsigned int  width;
 unsigned int height;

 Field* edited_field;
 EditorBuffer* field_editor;

} DocView;


#endif /* ifndef ___ARENA_DISPLAY_TYPES_H___ */
