/***************************************************************************
 *
 * $Header: /home/werner/ytree/RCS/profile.c,v 1.4 1998/05/10 20:02:24 werner Rel $
 *
 * Profile support
 *
 ***************************************************************************/


#include "ytree.h"



#define NO_SECTION	0
#define GLOBAL_SECTION	1
#define VIEWER_SECTION	2


typedef struct
{
  char *name;
  char *def;
  char *envvar;
  char *value;
} Profile;


typedef struct _viewer {
  char *ext;
  char *cmd;
  struct _viewer *next;
} Viewer;


static Viewer viewer;


/* MUSS sortiert sein! */
static Profile profile[] = { 
  { "ARCEXPAND",  DEFAULT_ARCEXPAND,  NULL,     NULL },
  { "ARCLIST",    DEFAULT_ARCLIST,    NULL,     NULL },
  { "BUNZIP",     DEFAULT_BUNZIP,     NULL,     NULL },
  { "CAT",        DEFAULT_CAT,        NULL,     NULL },
  { "EDITOR",     DEFAULT_EDITOR,     "EDITOR", NULL },
  { "GNUUNZIP",   DEFAULT_GNUUNZIP,   NULL,     NULL },
  { "HEXDUMP",    DEFAULT_HEXDUMP,    NULL,     NULL },
  { "LHAEXPAND",  DEFAULT_LHAEXPAND,  NULL,     NULL },
  { "LHALIST",    DEFAULT_LHALIST,    NULL,     NULL },
  { "MANROFF",    DEFAULT_MANROFF,    NULL,     NULL },
  { "MELT",       DEFAULT_MELT,       NULL,     NULL },
  { "PAGER",      DEFAULT_PAGER,      "PAGER",  NULL },
  { "RPMEXPAND",  DEFAULT_RPMEXPAND,  NULL,     NULL },
  { "RPMLIST",    DEFAULT_RPMLIST,    NULL,     NULL },
  { "TAPEDEV",    DEFAULT_TAPEDEV,    "TAPE",   NULL },
  { "TAREXPAND",  DEFAULT_TAREXPAND,  NULL,     NULL },
  { "TARLIST",    DEFAULT_TARLIST,    NULL,     NULL },
  { "TREEDEPTH",  DEFAULT_TREEDEPTH,  NULL,     NULL },
  { "UNCOMPRESS", DEFAULT_UNCOMPRESS, NULL,     NULL },
  { "ZIPEXPAND",  DEFAULT_ZIPEXPAND,  NULL,     NULL },
  { "ZIPLIST",    DEFAULT_ZIPLIST,    NULL,     NULL },
  { "ZOOEXPAND",  DEFAULT_ZOOEXPAND,  NULL,     NULL },
  { "ZOOLIST",    DEFAULT_ZOOLIST,    NULL,     NULL }
};

#define PROFILE_ENTRIES (sizeof(profile) / sizeof(profile[0]))


static int Compare(const void *s1, const void *s2);



int ReadProfile( char *filename )
{
  int  l, result = -1;
  char buffer[1024], *n, *old;
  unsigned char *name, *value, *cptr;
  int section;
  Profile *p, key;
  Viewer *v, *new_v;
  FILE *f;

  section = NO_SECTION;
  v = &viewer;

  if( ( f = fopen( filename, "r" ) ) == NULL ) {
    ESCAPE;
  }

  while( fgets( buffer, sizeof( buffer ), f ) ) {
    if(*buffer == '#')
      continue;
    l = strlen( buffer );
    if( l > 2 ) {
      buffer[l-1] = '\0';
      /* trim whitspace */
      for( name = buffer; isspace(*name); name++ )
        ;
      for(cptr=name; !isspace(*cptr) && *cptr != '='; cptr++ )
        ;
      if(*cptr != '=')
        *cptr = '\0';
      if(*name == '[') {
        /* section */
	if( !strcmp(name, "[GLOBAL]") ) 
	  section = GLOBAL_SECTION;
	else if( !strcmp(name, "[VIEWER]") ) 
	  section = VIEWER_SECTION;
	else
	  section = NO_SECTION;
	
	continue;
      }
	  

      if( section == GLOBAL_SECTION ) {
        value = strchr( buffer, '=' );
        if( *name && value ) {
          *value++ = '\0';
          key.name = name;
          if(( p = bsearch(&key, profile, PROFILE_ENTRIES, sizeof(*p), Compare))) {
	    p->value = Strdup( value );
          }
        }
      } else if( section == VIEWER_SECTION ) {
        value = strchr( buffer, '=' );

        if( *name && value ) {
          
	  *value++ = '\0';
	  n = Strtok_r(name, ",", &old);
	  /* maybe comma-separated list, eg.: .jpeg,.gif=xv */
	  while(n) {
	    if(( new_v = malloc( sizeof(*new_v) ) ) ) {
	      new_v->ext = Strdup( n );
	      new_v->cmd = Strdup( value );
	      new_v->next = NULL;
	      if(new_v->ext == NULL || new_v->cmd == NULL) {
	        /* ignore entry */
	        if(new_v->ext)
	          free(new_v->ext);
	        if(new_v->cmd)
	          free(new_v->cmd);
	        free(new_v);
	      } else {
	        v->next = new_v;
	        v = new_v;
	      }
	    }
	    n = Strtok_r(NULL, ",", &old);
	  }
        }
      }
    }
  }
  result = 0;

FNC_XIT:

  if( f )
    fclose( f );
  
  return( result );
}



char *GetProfileValue( char *name )
{
  Profile *p, key;
  char    *cptr;

  key.name = name;

  p = bsearch(&key, profile, PROFILE_ENTRIES, sizeof(*p), Compare);

  if(!p)
    return( "" );

  if( p->value )
    return( p->value );

  if( p->envvar && (cptr = getenv( p->envvar ) ) )
    return( cptr );

  return( p->def );
}


    
static int Compare(const void *s1, const void *s2)
{
  return( strcmp( ((Profile *)s1)->name, ((Profile *)s2)->name ) );
}



char *GetExtViewer(char *filename)
{
  Viewer *v;
  int l, x;

  l = strlen(filename);

  for(v=viewer.next; v; v=v->next) {
    x = strlen(v->ext);

    if(l > x) {
      if(!strcmp(&filename[l - x], v->ext)) {
        return(v->cmd);
      }
    }
  }
  return(NULL);
}


  
