/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */
      
#include "vfu.h"
#include "vfudir.h"
#include "vfuopt.h"
#include "vfuuti.h"
#include "vfusys.h"
#include "vfufiles.h"
#include "vfuview.h"
#include "vfumenu.h"

#define DIR_ITEM_SIZE_LEN        16

/*
#ifdef _TARGET_GO32_
  #define DSchar '/' 
  #define DSstring "/" 
#endif 

#ifdef _TARGET_UNIX_
  #define DSchar '/' 
  #define DSstring "/" 
#endif 

#ifdef _TARGET_OS2_
  #define DSchar '\\' 
  #define DSstring "\\" 
#endif 
*/

PSZCluster DirTree;
// char       Last1stChar = -1;

int DirTreeChanged = 0;

///////////////////////////////////////////////////////////////////////////
//
//
//

PSZCluster DirList;

  void GlobGDN( const char* dirname, const char* fnpattern, PSZCluster *sc = &DirList ) // glob getdirname
  {
    char tmp[MAX_PATH];
    strcpy( tmp, fnpattern );
    strcat( tmp, "*" );

    DIR *dir;
    dirent *de; 
    if (dirname[0] == 0) 
      dir = opendir(".");
    else 
      dir = opendir(dirname);
    if (dir) 
      { 
      while ( (de = readdir(dir)) )
        { 
        if ( strcmp( de->d_name, "." ) == 0 || strcmp( de->d_name, ".." ) == 0 ) continue;
        if (fnpattern[0] == 0 || FNMATCH( tmp, de->d_name)==0)
          { 
          struct stat st;
          sprintf(sss, "%s%s", dirname, de->d_name);
          stat( sss, &st );
          strcat(sss, "/");
          if ( S_ISDIR(st.st_mode) ) sc->add(sss);
          } 
        } 
      closedir(dir); 
      } 
  }

int __ExpandGetDirName = 1;
char* GetDirName(const char *prompt, const char *defaultdir, int ShouldExist )
{ 
#ifdef _TARGET_UNIX_
leaveok(stdscr, FALSE);
#endif

DirList.create( 32, 32 );
 
say1(prompt); 
say2(" "); 
String Target;
int pos = 0; 
int ch = 0; 

int insert = 1;
int firsthit = 1;

if (strlen(defaultdir) != 0)
  {
  Target = defaultdir;
  pos = Target.len();
  }

ConCShow();
say2(Target, firsthit ? cINPUT2 : cINPUT );
while(1) 
  { 
  if (ch == 0) ch = ConGetch();
  if (ch == '\\') ch = '/'; // dos? :))
  if ( ch == '/' && StrFind( Target, '/' ) < 0 && Target[0] == '~' )
    {
    strcpy( sss, Target );
    TildExpand( sss );
    Target = sss;
    pos = strlen(sss);
    ch = 0;
    }

/*
  if (ch == '~')
    {
    if (firsthit)
      {
      Target = "";
      pos = strlen(Target);
      }
    if (pos == 0)
      {
      StrInsert( Target, pos, HOME );
      pos += strlen(HOME);
      }
    else
      {
      StrInsertCh( Target, pos, ch );
      pos++;
      }
    ch = 0;
    }
  else
*/
  if ((ch == 8 || ch == KEY_BACKSPACE) && pos > 0) 
    { 
    pos--; 
    StrDelete( Target, pos, 1 );
    } 
  else
  if (ch == KEY_CTRL_A && Target.len() > 0)
    {
    int z = Target.len()-1;
    if ( StrGetCh(Target, z) == '/' ) z--;
    while ( z > 0 && StrGetCh(Target,z) != '/' ) z--;
    z++;
    StrSLeft(Target,z);
    pos = z;
    }
  else
  if ( (ch == 9 || ch == KEY_CTRL_S) && Target.len() > 0)
    { 
    int z; 
    DirList.freeall();
    char dmain[1024]; 
    char dtail[1024]; 
/*
    if (Target.GetCh(pos-1) == '/')
      { 
      ch = 0; 
      continue; 
      }
*/
    strcpy(sss, Target); 
    char *lastslash = strrchr(sss, '/');
    if (!lastslash) 
      { 
      dmain[0] = 0;
      strcpy( dtail, sss );
      }
    else
      {
      strcpy(dtail, lastslash+1);
      lastslash[1] = 0;
      strcpy(dmain, sss);
      }

    GlobGDN( dmain, dtail );

    z = DirList.count()-1;
    if (DirList.count()) 
      {
      if (opt.BashComplete || ch == KEY_CTRL_S)
        {
        if ( DirList.count() > 1)
          {
          if (ch != KEY_CTRL_S)
            {
            int mc = 0; // match count
            int mi = 0; // match letter index
            int li;
            do
              {
              mi++;
              mc = 0;
              for ( li = 0; li < DirList.count(); li++ )
                if ( StrGetCh( DirList[0], mi ) == StrGetCh( DirList[li], mi ) )
                  mc++;
              }
            while( mc == DirList.count() );
            Target.setn( DirList[0], mi );
            pos = Target.len();
            say2( Target, cINPUT );
            ConXY( pos+1, MAXY );
            
            ConBeep();
            ch = ConGetch();
            if ( ch != 9 ) { DirList.freeall(); continue; }
            }
          ConCHide();
          z = MenuBox( 10, 5, "Complete...", &DirList );
          ConCShow();
          ch = 0;
          }
        else
          ch = 0;
        }
      else
        {
        do 
          { 
          z++; 
          if (z == DirList.count()) z = 0;
          say2(DirList[z], cINPUT);
          ch = ConGetch(); 
          } 
        while(ch == 9);
        }
      if ( z != -1 )
        Target = DirList[z];
      pos = Target.len();
      DirList.freeall();
//      ConXY( pos+1, MAXY ); // this one is a hack :(
      if (ch != 0) continue;
      }
    else
      ConBeep();
    } 
  else 
  if (ch == 13) 
    { 
    break; 
    } 
  else 
  if (ch == 27) 
    { 
    Target = "";
    break; 
    } 
  if (ch == KEY_CTRL_U)
    { 
    Target = "";
    pos = 0;
    }
  else
  if (ch == KEY_CTRL_X)
    {
      ExpandPath( Target, sss );
      FixPath(sss);
      Target = sss;
      pos = Target.len();
    }
  else 
  if (ch > 31 && ch < 129 && pos < 70) 
    { 
    if (firsthit) 
      {
      Target = "";
      pos = 0;
      }
//    if (ch == '\\') ch = '/'; // dos? :))
    if (!insert) StrDelete( Target, pos, 1 );
    StrInsertCh( Target, pos, ch );
    pos++;
    } else
  if( ch == KEY_LEFT  ) // <- 
    {
    if (pos > 0)
      pos--;
    } else
  if( ch == KEY_RIGHT ) // -> 
    {
    if (pos < Target.len())
      pos++;
    } else
  if ( ch == KEY_IC ) insert = !insert; else
  if ( ch == KEY_HOME ) pos = 0; else
  if ( ch == KEY_END  ) pos = Target.len(); else
  if ( ch == KEY_DC  && pos < Target.len() ) 
     StrDelete( Target, pos, 1 ); else
  if ( ch == KEY_NPAGE || ch == KEY_PPAGE )
    {
    ConCHide();
    int zz = HistMenu( 5, 5, "ChDir History", ( ch == KEY_PPAGE ) ? HID_GETDIR : HID_CHDIR );
    ConCShow();
    if (zz != -1)
      {
      HistGet( ( ch == KEY_PPAGE ) ? HID_GETDIR : HID_CHDIR, zz, sss );
      if (sss[0])
        {
        Target = sss;
        pos = Target.len();
        }
      }
    }
  ch = 0; 
  firsthit = 0;
  say2( Target, cINPUT );
  ConXY( pos+1, MAXY );
  }
ConCHide();
StrCutSpc( Target );
if ( Target[0] == '~' )
  {
  strcpy( sss, Target );
  TildExpand( sss );
  Target = sss;
  }
if (Target.len() > 0)
  { 
  // well this tmp is kind of s... ama k'vo da pravi chovek :)
  // FIXME: dos version?
  if ( __ExpandGetDirName && Target[0] != '/' )
    Target = CPath + Target;
  FixPath( Target ); // add trailing slash if not exist
/*
  int es = Target.len(); 
  #ifdef _TARGET_GO32_
  if (StrGetCh(Target,es-1) != '/' && StrGetCh(Target,es-1) != ':' )
  #else
  if (StrGetCh(Target,es-1) != '/')
  #endif
    { 
    StrSLeft( Target, es );
    Target += "/";
    //Target[es] = '/';
    //Target[es+1] = 0;
    }
*/
  } 
#ifdef _TARGET_UNIX_
leaveok(stdscr, TRUE);
#endif

if (Target.len() > 0 && ShouldExist && !DirExist( Target ))
  {
  Beep();
  int ch = tolower(Ask( "Dir NOT exist! Create? ( ENTER=Yes, ESC=cancel, C=continue-anyway )", "\033\rcC" ));
  if ( ch == 27 ) Target = ""; else
  if ( ch == 13 )
     if (MakePath( Target ))
       {
       if(tolower(Ask( "Cannot create path! ( ESC=cancel, C=continue-anyway )", "\033Cc" )) == 27)
         Target = "";
       }
  }

say1(" "); 
say2(" "); 
if (Target.len() > 0)
  HistAdd( HID_GETDIR, Target );

StrCutSpc(Target);
strcpy( TargetDir, Target );

DirList.done();

return TargetDir;
} 

///////////////////////////////////////////// 
// 
// chdir and misc 
// 
/*
void AddToChDirHistory( char* pS )
{
int z = 0;
int from = 0;
for(from = 0; from < 10; from++)
  if(PathCmp(pS, opt.LastChDirs[from]) == 0)break;
for (z = from; z > 0; z--)
  strcpy(opt.LastChDirs[z], opt.LastChDirs[z-1]);
strcpy(opt.LastChDirs[0], pS);  
}
*/
///////////////////////////////////////////////////////////////////////////
//
//
//
void ChDir( const char *NewDir )
{
if (NewDir)
  {
  strcpy( TargetDir, NewDir );
  if ( TargetDir[strlen(TargetDir)-1] != '/' ) strcat( TargetDir, "/" );
  }
else
  {
  __ExpandGetDirName = 0;
  char last_dir[MAX_PATH];
  HistGet( HID_CHDIR, 0, last_dir );
  GetDirName( "ChDir to? (TAB, PageUp, PageDown, ^X, ^S, ^A)", last_dir, 0 );
  __ExpandGetDirName = 1;
  }
if (TargetDir[0] != 0) 
  {
  if ( CPath[0] != TargetDir[0] && DirTreeChanged && opt.AutoTree ) SaveTree();
  // strcpy( opt.LastDir, CPath );
  // AddToChDirHistory( opt.LastDir );
  // AddHist10( opt.LastDir, opt.LastChDirs, !FNCASE);
  HistAdd( HID_CHDIR, CPath );
  char ch = CPath[0];
  if (opt.CDTree)
    if (!DirExist( TargetDir ))
      {
      int z = 0;
      if ( DirTree.count() == 0 ) LoadTree();
      mb.freeall();
      z = DirTreeFind( TargetDir, &mb );
      if (z > 1)
        {
        SetMenuColors();
        z = PSZView( 5, 5, mb.maxlen() > 70 ? 70 : mb.maxlen(), 16, "ChDir to...", &mb, 0 );
        ReDraw();
        if (z > -1)
          strcpy(TargetDir, mb.get(z));
        else
          return;
        }
      else
      if (z == 1)
        strcpy(TargetDir, mb.get(0));
      }
  String str = TargetDir; StrCutSpc(str);
  #ifdef _TARGET_GO32_
  if ( str[0] == '/' )
    {
    StrInsertCh( str, 0, ':' );
    StrInsertCh( str, 0, CPath[0] );
    } else
  if ( str[1] == ':' && str[2] == 0 ) // c: d: e:
    {
    ExpandPath( str, sss );
    FixPath( sss );
    str = sss;
    }
  if ( str[1] == ':' && str[2] == '/' )
  #else
  if (str[0] == '/')
  #endif
    {
    strcpy( TargetDir, str );
    }
  else
    {
//    str = CPath + str;
    SimplifyPath( CPath+str, TargetDir );
    }
  if (chdir( TargetDir ) != 0)
    {
    sprintf( sss, "chdir: %s", TargetDir );
    say1( sss );
    DescribeErrno();
    return;
    }
  else
    {
    strcpy( CPath, TargetDir );
    if ( WorkMode == wmInArchive ) WorkMode = wmNormal;
    }
//  GetCPath();
  if ( ch != CPath[0] ) DropTree(); // drop tree -- it is for another drive
  if (DirTree.count() == 0 && opt.DirTreeSizes)
    {
    if ( opt.AutoTree ) LoadTree();
    if ( DirTree.count() == 0 ) RebuildTree();
    }
  ReadFiles();
  FGO(0);
  draw = 1;
  } 
} 

///////////////////////////////////////////////////////////////////////////
//
//
//
void ChDirHistory()
{
  int z = HistMenu( 5, 5, "ChDir History", HID_CHDIR );
  if (z == -1) return;
  draw = 1; 
  //strcpy(opt.LastDir, CPath);
  ChDir( HistGet( HID_CHDIR, z ) );
}

///////////////////////////////////////////////////////////////////////////
//
// return `dirname' dir size or -1 if aborted
//
long __fcount = 0;
long __dcount = 0;
long __lcount = 0;
int __rebuildtree = 0;
int __aborttree = 0;
fsize_t  __recursetree( const char *dirname )
{
  if (__aborttree) return -1;
  say1( dirname, cWHITE );
  char tmp[MAX_PATH+64];

  fsize_t size = 0;
  DIR *dir;
  struct dirent *de;

  dir = opendir( dirname );
  if (!dir) return 0;
  while( (de = readdir(dir)) )
    {
    char newdname[MAX_PATH];
    struct stat st;
    sprintf(newdname, "%s/%s", dirname, de->d_name);
    lstat(newdname, &st);
    int is_link = int(S_ISLNK(st.st_mode));
    __lcount += is_link;
    #ifdef _TARGET_GO32_
    dosstat(dir, &st);
    #else
    stat(newdname, &st);
    #endif
    if S_ISDIR(st.st_mode)
      {
      if (strcmp(de->d_name, ".") && strcmp(de->d_name, ".."))
        {
        __dcount++;
        if (!is_link)
          {
          sprintf(newdname, "%s%s/", dirname, de->d_name);
          if (__rebuildtree)
            { // rebuilding tree...
            int add = 1;
            if (TrimTree[0][0] != 0) // TrimTree is defined
              {
                for( int zz = 0; zz < MAX_TRIMS; zz++ )
                  {
                  if (TrimTree[zz][0] == 0) continue;
                  if ( PathNCmp( newdname, TrimTree[zz], strlen(TrimTree[zz]) ) == 0)
                    {
                    add = 0;
                    break;
                    }
                  }
              }
            int pos = DirTree.count();
            fsize_t temp_size = -1;
            if (add) temp_size = __recursetree( newdname );
            String str;
            str.setfi( temp_size );
            size += temp_size + (temp_size == -1);
            StrComma(str);
            sprintf( tmp, "%14s  %s", (const char*)str, newdname );
            DirTree.ins( pos, tmp );
            }
          else
            { // just calculate dir size
            size += __recursetree( newdname );
            }
          }
        }
      }
    else
      {
      __fcount++;
      size += st.st_size;
      }
  
    if (BreakOp())
      {
      __aborttree = 1;
      break;
      }

    }
  closedir(dir);
  return __aborttree ? -1 : size;
}

///////////////////////////////////////////////////////////////////////////
//
//
//
void LoadTree()
{
  int res = LoadFromFile( TREEFILE, &DirTree, int(1.5*MAX_PATH) );
  if (res)
    say1( "DirTree load error." );
  else
//    {
    say1( "DirTree loaded ok." );
//    Last1stChar = CPath[0];
//    }
};

///////////////////////////////////////////////////////////////////////////
//
//
//
void SaveTree()
{
  int res = SaveToFile( TREEFILE, &DirTree );
  if (res)
    say1( "DirTree save error." );
  else
    {
    say1( "DirTree saved ok." );
    DirTreeChanged = No;
    }
};

///////////////////////////////////////////////////////////////////////////
//
//
//
void DropTree()
{
  DirTree.freeall();
}

///////////////////////////////////////////////////////////////////////////
//
//
//
void FixTree()
{
  int z;
  for( z = DirTree.count() - 1; z >= 0; z-- )
    {
    String s1 = DirTree[z];
    String s2;
    if (z < DirTree.count() - 1)
      s2 = DirTree[z+1];
    else
      s2 = "";
    int i = -1;
    int n = StrCount( s1, "/" );
    int p = 0;
    while(n > 2)
      {
      i = StrFind( s1, '/', i+1 );
      if ( s1[i] != s2[i] || (/*s1.GetCh(i) == s2.GetCh(i) &&*/ StrCount(s2,"/",i+1) < 2))
        {
          p = 1;
          StrSetCh(s1, i, '\\');
        }
      n--;
      }
    if ( p )
      DirTree.put( z, s1 );
    }
}

///////////////////////////////////////////////////////////////////////////
//
//
//
void RebuildTree()
{
  time_t t = time(NULL);

#ifdef _TARGET_GO32_
// we do need only files sizes -- so the other stuff under dos is unneeded :)
_djstat_flags = _STAT_INODE | _STAT_EXEC_EXT | _STAT_EXEC_MAGIC |
                _STAT_EXEC_MAGIC | _STAT_DIRSIZE | _STAT_ROOT_TIME |
                _STAT_WRITEBIT;
// _djstat_flags = 0;
#endif
  DirTree.freeall();
  say1( "Rebuilding tree..." );
  __aborttree = 0;
  __rebuildtree = 1;
  __recursetree( "/" );
  __rebuildtree = 0;
  __aborttree = 0;
//  Last1stChar = CPath[0];
  DirTreeChanged = Yes;
  FixTree();
#ifdef _TARGET_GO32_
 _djstat_flags = 0;
#endif

  t = time(NULL) - t;
  sprintf( sss, "Elapsed seconds: %d", t );
  say1( sss );

  if (opt.AutoTree) SaveTree();
};

///////////////////////////////////////////////////////////////////////////
//
//
//
void DrawTreeItem( int page, int index, int hilite = 0 )
{
  if ( page + index >= DirTree.count() ) return;
  String s1 = DirTree[page+index];
  StrTrimR(s1,1);
  String s2 = s1;
  int j = StrRFind( s1,'/');
  StrTrimR(s1,s2.len()-j-1);
  StrTrimL(s2,j+1);
  for(j = DIR_ITEM_SIZE_LEN; j < s1.len(); j++)
    {
    if (s1[j] == '/')
      StrSetCh(s1,j, '|');
    else
    if (s1[j] == '\\')
      StrSetCh(s1,j, '\\');
    else
      StrSetCh(s1,j, '+');
    }
  if (opt.CompactTree)
    {
    StrReplace(s1,"+", "");
    StrReplace(s1,"|", "|  ");
    StrReplace(s1,"\\","   ");
    StrTrimR(s1,2);
    s1 += "--";
    }
  else
    {
    StrReplace(s1,"+", " ");
    StrReplace(s1,"\\", " ");
    s1 += "-";
    }

  #ifdef _TARGET_GO32_
  if (opt.VFFilenames) StrUpCase(s2);
  #endif

  ConXY(1,3+1+index);
  if (hilite)
    {
    ConPuts( s1, cINPUT );
    ConPuts( s2, cINPUT );
    ConCE( cINPUT );
    }
  else
    {
    ConPuts( s1, cCYAN );
    ConPuts( s2, chCYAN );
    ConCE( cCYAN );
    }
}

///////////////////////////////////////////////////////////////////////////
//
//
//
void TreeDrawPage( TScrollPos &scroll )
{
  String str = " ";
  StrMul( str, MAXX );
  str = "        SiZE  DiRECTORY" + str;
  StrSLeft( str, MAXX-13 ); // -13 to avoid overlapping `xxx of yyy' indicator
  ConOut(1,3, str, cHEADER );
  str = " "; StrMul(str, MAXX);
  int z = 0;
  for(z = 0; z < scroll.pagesize; z++)
    {
    if (scroll.page + z <= scroll.max)
      {
      DrawTreeItem( scroll.page, z );
      }
    else
      ConOut(1, 3+1+z, str, cCYAN );
    }
}

///////////////////////////////////////////////////////////////////////////
//
//
//
void TreeDrawPos( TScrollPos &scroll, int opos )
{
  if (opt.VFStyle)
    {
    int z = scroll.pos - scroll.page;
    if ( opos != -1 ) DrawTreeItem( scroll.page, opos );
    DrawTreeItem( scroll.page, z, 1 );
    }
  else
    {
    if(opos != -1)ConOut( 13, 3+1+opos, "  ", cWHITE);
    ConOut( 13, 3+1+scroll.pos - scroll.page, ">>", chWHITE);
    }
  String str = DirTree[scroll.pos];
  if (str.len() > 65 )
    {
    StrDelete( str,20, str.len() - 65 );
    StrInsert( str,20, "..." );
    }
  StrTR( str,"\\", "/" );
  ConOut( 1, STATLINE1, str, cINFO ); ConCE( cINFO );
  ConOut( 1, STATLINE2, "Ctrl+R Rebuild, Ctrl+L Load, Ctrl+W Write/Save, Ctrl+S Inc. search, Ctrl+Z Size" , cINFO ); ConCE( cINFO );
  ShowPos( scroll.pos+1, scroll.max+1 );
}

///////////////////////////////////////////////////////////////////////////
//
//
//
void ViewTree()
{
  String str;
/*
  if (Last1stChar != CPath[0])
    {
    DirTree.freeall();
    Last1stChar = CPath[0];
    }
*/
  if (DirTree.count() == 0)
    {
    if (opt.AutoTree) LoadTree();
    if (DirTree.count() == 0) RebuildTree();
    }
  say1( " " );
  // find current dir if exists
  int newpos = 0;
  int z;
  for( z = 0; z < DirTree.count(); z++ )
    {
    str = "";
    #ifdef _TARGET_GO32_
    StrAddCh( str, CPath[0] );
    StrAddCh( str, CPath[1] );
    #endif
    str += DirTree[z] + DIR_ITEM_SIZE_LEN;
    StrTR(str, "\\", "/");
    if (stricmp(CPath, str) == 0)
      newpos = z;
    }
  // end-find
  CharSet cset; // used for searching
  cset.setr( 'a', 'z' );
  cset.setr( 'A', 'Z' );
  cset.setr( '0', '9' );
  cset.set ( "._-~" );
  cset.set ( "?*>" );

  TScrollPos scroll;
  scroll.create( 0, DirTree.count()-1, 0, 0, PS, 1 );
  scroll.gotopos( newpos );
  if (opt.DynamicScroll) scroll.settype(1);
  int key = 0;
  int opos = -1;
  int opage = -1;
  while( key != 27 && key != 13 && key != '-' )
    {
    if ( cset.in( key ) )
      {
      int z = scroll.pos;
      int direction = 0;
      if (key >= 'A' && key <= 'Z')
        direction = -1;
      else
        direction = 1;
      while(1)
        {
        z += direction;
        if ( z > scroll.max ) z = scroll.min;
        if ( z < scroll.min ) z = scroll.max;
        if ( z == scroll.pos ) break;
        str = DirTree[z];
        StrTrimR(str,1);
        int j = StrRFind(str,'/');
        if (j == 0 || j == str.len()-1) continue;
        char ch = str[j+1];
        if (tolower(ch) == tolower(key)) break;
        }
      if (z != scroll.pos) scroll.gotopos(z);
      }
    else
    if ( key == KEY_CTRL_S )
      {
        str = "";
        say1( "Enter search string: ( use TAB to advance )" );
        key = ConGetch();
        while( cset.in( key ) || key == 8 || key == 9 )
          {
          if ( key == 8 || key == KEY_BACKSPACE )
            StrTrimR( str, 1 );
          else
          if ( key != 9 )
            StrAddCh( str, key );
          say2( str );
          int z;
          if ( key == 9 )
            {
            z = scroll.pos + 1;
            if (z > scroll.max ) z = scroll.min;
            }
          else
            z = scroll.pos;
          int direction = 1;
          int found = 0;
          while(1)
            {
            if ( scroll.pos > 0 && z == scroll.pos-1 ) break;
            if ( scroll.pos == 0 && z == scroll.max ) break;
            String str1 = DirTree[z];
            StrTrimR(str1,1);
            int j = StrRFind(str1,'/');
            if (j == 0 || j == str1.len()-1) continue;
            StrTrimL( str1, j+1 );
            int rr;
            if (StrGetCh(str,0) == '>')
              rr = FNMATCH( str.asis()+1, str1 );
            else
              rr = PathNCmp( str, str1, str.len() );
            found = ( rr == 0 );
            if (found) break;
            z += direction;
            if ( z > scroll.max ) z = scroll.min;
            if ( z < scroll.min ) z = scroll.max;
            }
          if (found)
            {
            scroll.gotopos(z);
            TreeDrawPage( scroll );
            TreeDrawPos( scroll, opos );
            }
          key = ConGetch();
          }
        say1( "" );
        say2( "" );
      }
    else
    switch( key )
      {
      case KEY_UP     : scroll.up(); break;
      case KEY_DOWN   : scroll.down(); break;
      case KEY_PPAGE  : scroll.pageup(); break;
      case KEY_NPAGE  : scroll.pagedown(); break;
      case KEY_HOME   : scroll.home(); break;
      case KEY_END    : scroll.end(); break;
      case KEY_CTRL_R : RebuildTree();
                        scroll.pos = 0;
                        scroll.page = 0;
                        scroll.max = DirTree.count()-1;
                        say1( "Rebuild done." );
                        break;
      case KEY_CTRL_W : SaveTree(); break;
      case KEY_CTRL_L : LoadTree(); break;
      case KEY_CTRL_Z :
                        str = DirTree[scroll.pos] + DIR_ITEM_SIZE_LEN;
                        DirTreeSetSize( str, DirSize( str ) );
                        TreeDrawPage( scroll );
                        TreeDrawPos( scroll, opos );
                        say1( "Done." );
                        break;
      }
    if (opage != scroll.page) TreeDrawPage( scroll );
    if (opos != scroll.pos - scroll.page || opage != scroll.page) TreeDrawPos( scroll, opos );
    opos = scroll.pos - scroll.page;
    opage = scroll.page;
    key = ConGetch();
    }
  if ( key == 13 )
    {
    str = DirTree[scroll.pos] + DIR_ITEM_SIZE_LEN;
    StrTR( str, "\\", "/" );
    ChDir( str );
    }
  draw = 1;
};

///////////////////////////////////////////////////////////////////////////
//
// return index in the DirTree of directory named `s' or -1 if not found
//
int  DirTreeIndex( const char *s )
{
  int z = 0;
  int i = 0;
  int sl1;
  int sl2;

  const char *s1 = s
  #ifdef _TARGET_GO32_
  + 2; // to cut `d:' chars len
  #endif
  ;
  sl1 = strlen( s1 );

  for( z = 0; z < DirTree.count(); z++ )
    {
    char *s2 = DirTree[z] + DIR_ITEM_SIZE_LEN;
    sl2 = strlen( s2 );

    if ( sl1 == sl2 )
      {
      i = sl1; // or sl2 ...
      while ( i >= 0 && (s1[i] == s2[i] || (s1[i] == '/' && s2[i] == '\\')) ) i--;
      if ( i < 0 ) return z;
      }
    }
  return -1;
}

///////////////////////////////////////////////////////////////////////////
//
// get dir's size from the tree, return -1 if not found
//
fsize_t DirTreeGetSize( const char *s )
{
  int pos = DirTreeIndex( s );
  if ( pos == -1 ) return -1;
  String str = DirTree[pos];
  StrSLeft( str, DIR_ITEM_SIZE_LEN );
  StrReplace( str, ",", "" );
  return atol(str);
};

///////////////////////////////////////////////////////////////////////////
//
//
//
void DirTreeSetSize( const char *s, fsize_t size )
{
  int pos = DirTreeIndex( s );
  if ( pos == -1 ) return;

  String str = DirTree[pos];
  String tmp;
  tmp.setfi( size ); StrComma(tmp); StrPad( tmp, DIR_ITEM_SIZE_LEN - 2 );
  StrTrimL( str, DIR_ITEM_SIZE_LEN );
  str = tmp + "  " + str;
  DirTree.put( pos, str );
  DirTreeChanged = Yes;
};

///////////////////////////////////////////////////////////////////////////
//
//
//
long DirSizeFCount = 0; // dir count
long DirSizeDCount = 0; // files count
fsize_t DirSize( const char *s )
{
  strcpy( sss, s );
  if ( sss[strlen(sss) - 1] != '/' ) strcat( sss, "/" );
  __aborttree = 0;
  __fcount = 0;
  __dcount = 0;
  __lcount = 0;
  fsize_t res = __recursetree( sss );
  __aborttree = 0;
  DirSizeFCount = __fcount;
  DirSizeDCount = __dcount;
  if (opt.AutoUpdateDSize)
    {
    ExpandPath( s, sss );
    if ( sss[strlen(sss) - 1] != '/' ) strcat( sss, "/" );
    DirTreeSetSize( sss, res );
    }
  return res;
}
 
///////////////////////////////////////////////////////////////////////////
//
//
//
const char* DirTreeFind( const char *s ) // return full path by dirname
{
  String str;
  int z = 0;
  int sl = strlen( s );
  for ( z = 0; z < DirTree.count(); z++ )
    {
    str = DirTree[z];
    if ( str.len() - sl < DIR_ITEM_SIZE_LEN ) continue;
    StrSRight( str, sl );
    if (PathCmp( (const char*)str, s ) == 0)
      {
      return DirTree[z] + DIR_ITEM_SIZE_LEN;
      }
    }
  return NULL;  
}

///////////////////////////////////////////////////////////////////////////
//
//
//
int DirTreeFind( const char *s, PSZCluster *sc ) // return count of found dirnames and stores them to sc
{
  String str;
  int z = 0;
  int sl = strlen( s );
  for ( z = 0; z < DirTree.count(); z++ )
    {
    str = DirTree[z];
    if ( str.len() - sl < DIR_ITEM_SIZE_LEN ) continue;
    StrSRight( str, sl );
    if (PathCmp( (const char*)str, s ) == 0)
      {
      strcpy( sss, DirTree[z] + DIR_ITEM_SIZE_LEN );
      StrTR( sss, "\\", "/" );
      sc->add(sss);
      }
    }
  return sc->count();
}

///////////////////////////////////////////////////////////////////////////
