/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 * SEED means `SEE editor', just followup to the SEE viewer
 *
 * DISCLAIMER: SEED is only supposed to be small (I mean small)
 * text editor mainly used as internal editor for the VFU File Manager
 * However it can be used as standalone editor if required, under
 * standalone license.
 *
 */

 // TODO: Seed is still not optimized in any way -- first one should
 //       be the TAB expand maps and handling...

  #include <vslib.h>
  #include <ctype.h>

  #include <vslib.h>

  #define MAXX ConMaxX()
  #define MAXY ConMaxY()
  #define ROWS  (MAXY-1)

  #ifndef MAX_PATH
  #define MAX_PATH 512
  #endif

  #define BSIZE       512 // 4096
  #define TABSIZE     8
  #define MAXLINE     4096

  int SeedSLColor  = 112; // status line color
  int SeedWRNColor =  79; // warning color

  #ifndef MSF
  #define MSF 10 // max seed files
  #endif

  struct TSeedFile
    {
    char fn[MAX_PATH];
//    TScrollPos sh; // horizontal scroll
    int col;
    int colpage;
    TScrollPos sv; // vertical scroll
    PSZCluster sc; // string cluster
    int mod; // modified
    };
    
  TSeedFile SDFiles[MSF];
  static int dFI = 0; // file index
  static int dFC = 0; // files count

  static int INS = 1;

  #define FN    SDFiles[dFI].fn
  #define SC    SDFiles[dFI].sc
  #define SV    SDFiles[dFI].sv
//  #define SH    SDFiles[dFI].sh
  #define COL   SDFiles[dFI].col
  #define COLPG SDFiles[dFI].colpage
  #define ROW   SDFiles[dFI].sv.pos
  #define ROWPG SDFiles[dFI].sv.page
  #define LASTL (SDFiles[dFI].sc.count()-1)
  #define MOD   SDFiles[dFI].mod

  #define SCOL  (COL    - COLPG   + 1) // screen column
  #define SROW  (SV.pos - SV.page + 1) // screen row

  struct TSeedOptions
  {
    char LastPipeCmd[256];
    char LastFindStr[128];
    int autoindent;
  };
  TSeedOptions seedopt;

////////////////////////////////////////////////////////////////////////////
//
//
//
  static String SeedETM;
  int SeedExpandTabs( String &str ) // returns inserted spaces count
    {
    int res;
    int i;
    SeedETM = "";
    StrPad( SeedETM, StrLen(str) );
    while( ( i = StrFind( str, '\t' ) ) > -1 )
      {
      int j;
      j = ( i / TABSIZE + 1 ) * TABSIZE;
      j = j - i;
      res += (j - 1);
      StrDelete( str, i, 1 );
      while( j-- )
        {
        StrInsertCh( str, i, ' ' );
        StrInsertCh( SeedETM, i, '+' );
        }
      StrDelete( SeedETM, i, 1 );
      StrInsertCh( SeedETM, i, '*' );
      };
    return res;
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  int SeedRealCol( int row = -1 )
    {
    int _COL = COL;
    if (row == -1) row = ROW;
    String str = SC[row];
    if (SeedExpandTabs(str))
      {
      StrSLeft( SeedETM, COL );
      _COL -= StrCount( SeedETM, "+" );
      }
    return _COL;
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedInit()
    {
    dFC = 0;
    dFI = 0;
    int z;
    for ( z = 0; z < MSF; z++ )
      {
      SDFiles[z].fn[0] = 0;
      SDFiles[z].mod = 0;
      };
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedInsertFile( const char *fname )
    {
    if (SC.count() != 0) MOD = 1;
    LoadFromFile( fname, &(SC), MAXLINE );
    if (SC.count() == 0) SC.add( "" );
    for ( int z = 0; z < SC.count(); z++ )
      {
      String str = SC[z];
      StrCutR( str, " \t\n\r" );
      SC.put( z, str );
      }
    if ( SC.count() - 1 > SV.max ) SV.max = SC.count() - 1;
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedMsg( const char* s, int slcolor = SeedSLColor )
  {
    ConOut( 1, MAXY, s, slcolor ); ConCE( slcolor );
    ConXY( SCOL, SROW );
  };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedDrawLine( int n )
    {
    int ox = ConX();
    int oy = ConY();
    if ( n >= SC.count() )
      {
      ConOut( 1, (n-SV.page)+1, "~", cNORMAL );
      ConCE( cNORMAL );
      }
    else
      {
      String str = SC[n];
      /////////////////////
      SeedExpandTabs( str );
      
      StrTrimL( str, COLPG );
      StrSLeft( str, MAXX );
      ConOut( 1, (n-SV.page)+1, str, cNORMAL );
      ConCE( cNORMAL );
      }
    ConXY( ox, oy );
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedDraw( int from = 0 )
    {
    int z;
    String str;
    ConCHide();
    if (from != -1)
      for( z = from; z < ROWS; z++ )
        SeedDrawLine( SV.page + z );
    char sline[256];
    sprintf( sline, "| SEED v2.0 | Slot:%2d/%2d%c|%3d%% | Line:%5d of%5d |%4d+ %s |`F1%s' help", dFI+1, dFC, MOD?'*':' ', (100*ROW)/(LASTL?LASTL:1), ROW+1, LASTL+1, COL+1, INS?"INS":"ovr", ( COL == 0 && ROW == 0 ) ? " or ^H" : "" );
    ConOut( 1, MAXY, sline, SeedSLColor );
    ConCE( SeedSLColor );
    ConCShow();
    ConXY( SCOL, SROW );
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedPosCheck()
  {
  if (SCOL > MAXX || SCOL < 1)
    COLPG = COL - MAXX/2;
  SeedDraw();
  };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedSetFile( int n )
    {
    char sss[255];
    if ( n >= MSF ) return;
    int oFI = dFI;
    dFI = n;
    if ( SC.count() == 0 )
      {
      if ( FN[0] == 0 )
        {
        sprintf( sss, " Slot %d: <<empty>>", n+1 );
        SeedMsg( sss );
        dFI = oFI;
        }
      else
        {
        SeedInsertFile( FN );
        SeedDraw();
        sprintf( sss, " Slot %d: %s", n+1, FN );
        SeedMsg( sss );
        };
      }
    else
      {
      SeedDraw();
      sprintf( sss, " Slot %d: %s", n+1, FN );
      SeedMsg( sss );
      };
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  int SeedAddFile( const char* fname )
    {
    if ( dFC == MSF ) return 1;

    SV.pagesize = ROWS;

    COL = 0;
    COLPG = 0;
    SV.gotopos( 0 );

    SC.create( 16, 16 );

    strcpy( FN, fname );

    SV.max = SC.count() - 1;

    dFI++;
    dFC++;
    return 0;
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  int SeedSave()
    {
    char sss[128];
    int z;
    for ( z = 0; z < SC.count(); z++ )
      {
      String str = SC[z];
      StrCutR( str, " \t" );
      SC.put( z, str );
      };
    if (SaveToFile( FN, &SC ) == 0)
      {
      sprintf( sss, "File `%s' is saved ok.", FN );
      SeedMsg( sss );
      MOD = 0;
      return 0;
      }
    else
      {
      sprintf( sss, "File `%s' save failed!", FN );
      SeedMsg( sss );
      return 1;
      }
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  int SeedRequestQuit() // if returs 0 then quit
  {
    PSZCluster mb;
    mb.create( 4, 4 );
    mb.add( "X Exit (Save)    " );
    mb.add( "Q Quit (NO Save) " );
    for ( int z = 0; z < MSF; z++ )
      {
      dFI = z;
      if ( FN[0] == 0 ) continue;
      SeedDraw();
      if (MOD)
        {
        ConCHide();
        ConBeep();
        int res = ConMenuBox( 50, 5, "File Modified?", &mb, 0 );
        ConCShow();
        SeedDraw();
        if (res == -1) return 1;
        if (res == 0)
          SeedSave();
        }
      }
    return 0;
  };

  void SeedCloseAll()
    {
    for ( int z = 0; z < MSF; z++ )
      {
      dFI = z;
      if ( FN[0] == 0 ) continue;
      SC.freeall();
      }
    SeedInit();
    };

////////////////////////////////////////////////////////////////////////////
//
//
//
  void SeedDown()
  {
    SV.down();
  };

////////////////////////////////////////////////////////////////////////////
//
//
//
  void SeedUp()
  {
    SV.up();
  };

////////////////////////////////////////////////////////////////////////////
//
//
//
  void SeedLeft()
  {
    if (COL <= 0) return;
    String str = SC[ROW];
    if (SeedExpandTabs( str ))
      {
      COL--;
      while (SeedETM[COL] == '+')
        COL--;
      }
    else
      COL--;
    if (SCOL < 1)
      COLPG--;
  };

////////////////////////////////////////////////////////////////////////////
//
//
//
  void SeedRight()
  {
    String str = SC[ROW];
    if (SeedExpandTabs( str ))
      {
      COL++;
      while (SeedETM[COL] == '+')
        COL++;
      }
    else
      COL++;
    if (SCOL > MAXX)
      COLPG++;
  };

////////////////////////////////////////////////////////////////////////////
//
//
//
  void SeedPPage()
    {
    SV.pageup();
    };

  void SeedNPage()
    {
    SV.pagedown();
    };

  void SeedBegFile()
    {
    SV.home();
    };
    
  void SeedEndFile()
    {
    SV.end();
    };
    
////////////////////////////////////////////////////////////////////////////
//
//
//
  void SeedHome()
    {
    COL = 0;
    COLPG = 0;
    };

////////////////////////////////////////////////////////////////////////////
//
//
//
  void SeedEnd()
    {
    String str = SC[ROW];
    StrCutR( str, " \t" );
    if ( StrLen( str ) != StrLen( SC[ROW] ) )
      SC.put( ROW, str );

    SeedExpandTabs( str );
    COL = StrLen( str );
    
    if (SCOL > MAXX)
      {
      COLPG = COL - MAXX/2;
      SeedDrawLine( ROW );
      }
    else
      SeedDraw();
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedKDEL()
  {
  String str = SC[ROW];
  int _COL = SeedRealCol();
  if (_COL >= StrLen( str ))
    {
    if ( ROW == LASTL ) return;
    MOD = 1;
    String lstr = SC[ROW+1]; // lower string
    if (_COL > StrLen( str )) StrPad( str, -_COL, ' ' ); // the line is short -- pad with spaces
    str += lstr;
    SC.put( ROW, str );
    SC.free(ROW+1);
    SV.max = SC.count()-1;
    SeedDraw( /*ROW*/ ); // from ROW to the end of the page
    }
  else
    {
    MOD = 1;
    StrDelete( str, _COL, 1 );
    SC.put( ROW, str );
    SeedDrawLine( ROW );
    };
  };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedKBS()
  {
    String str = SC[ROW];
    int _COL = SeedRealCol();
    if (_COL > StrLen( str ))
      {
      SeedLeft();
      return;
      } else
    if (_COL == 0)
      {
      if (ROW == 0) return;
      SeedUp();
      SeedEnd();
      SeedKDEL();
      }
    else
      {
      SeedLeft();
      SeedKDEL();
      };
  };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedKEnter( int draw = 1 )
    {
    MOD = 1;
    int _COL = SeedRealCol();
    String str = SC[ROW];
    String nstr = str;
    StrSLeft( str, _COL );
    StrTrimL( nstr, _COL );
    SC.put( ROW, str );
    SC.ins( ROW+1, nstr );
    SV.max = SC.count()-1;
    SV.down();
    COL = 0; // !!! here should go the auto indenting...
    if (seedopt.autoindent && ROW > 1)
      {
      str = SC[ROW-1];
      int z = 0;
      int nc = 0;
      while( z < StrLen(str) && (str[z] == ' ' || str[z] == '\t') )
        {
        if ( str[z] == '\t' ) nc += TABSIZE; else nc++;
        z++;
        }
      str = SC[ROW];
      COL = nc;
      while( nc-- ) StrInsertCh( str, 0, ' ' );
      SC.put( ROW, str );
      };
    if (SCOL > MAXX || SCOL < 1)
      {
      COLPG = COL - MAXX/2;
      if (draw) SeedDraw();
      }
    else
      if (draw) SeedDraw(); // from ROW to the end of the page
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedKInsert( int ch, int draw = 1 )
    {
    if ( ch < 0 || ch > 255 ) return;
    if ( ch == 13 || ch == 10 )
      {
      SeedKEnter( draw );
      return;
      };
    MOD = 1;
    String str = SC[ROW];

    int _COL = SeedRealCol();

    if (!INS)
      StrDelete( str, _COL, 1 );
    if ( StrLen(str) < _COL ) StrPad( str, -_COL, ' ' );
    StrInsertCh( str, _COL, ch );
    SC.put( ROW, str );


    SeedRight();
    if (SCOL > MAXX || SCOL < 1)
      {
      COLPG = COL - MAXX/2;
      if (draw) SeedDraw();
      }
    else
      if (draw) SeedDrawLine( ROW );
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedKillLine( int n = -1 )
    {
    if (n == -1) n = ROW;
    SC.free( ROW );
    SV.max = SC.count()-1;
    if ( ROW >= LASTL ) SeedUp();
    SeedDraw();
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedPipeIns()
  {
    SeedMsg( " PipeInsert: " );
    if (!TextInput( 13, MAXY, "", 65, 65, seedopt.LastPipeCmd))
      {
      SeedDraw();
      return;
      }
    FILE* f = popen( seedopt.LastPipeCmd, "rb" );
    char ch;
    while( (ch = fgetc( f ) ) != EOF )
      SeedKInsert( ch, 0 );
    pclose( f );
    SeedDraw();
  };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedFindNext()
    {
    int OROW = ROW; // save current row
    int found = -1;

    SeedDown();
    while( ROW < LASTL )
      {
      if ( ( found = StrFind( SC[ROW], seedopt.LastFindStr ) ) != -1)
        break;
      SeedDown();
      }
    found = StrFind( SC[ROW], seedopt.LastFindStr );
    if (found == -1)
      {
      SV.gotopos( OROW );
      char tmp[128];
      sprintf( tmp, "String `%s' not found", seedopt.LastFindStr );
      SeedMsg( tmp );
      ConBeep();
      }
    else
      {
      COL = found;
      SeedDraw();
      };
    if (SCOL < 1 || SCOL > MAXX ) COLPG = COL - MAXX/2;
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedFind()
    {
    SeedMsg( " Find (nocase): " );
    if (!TextInput( 16, MAXY, "", 60, 60, seedopt.LastFindStr))
      {
      SeedDraw();
      return;
      }
    SeedFindNext();
    };

////////////////////////////////////////////////////////////////////////////
//
//
//

  void SeedHelp()
  {
    ConOut( 1, 1,
    "+-----------------------------------------------------------------------------+\n"
    "| Seed v2.0 Help Screen (c) Vladi Belperchinov-Shabanski <cade@biscom.net>    |\n"
    "|                                                                             |\n"
    "|                                                                             |\n"
    "| Up_Arrow    or ^P -- one line up           ESC  -- request exit             |\n"
    "| Down_Arrow  or ^N -- one line down                 (will prompt for save)   |\n"
    "| Left_Arrow  or ^B -- one char left         ^W   -- pipe cmd input as text   |\n"
    "| Right_Arrow or ^F -- one char right          @F -- find string              |\n"
    "| Page_Up     or ^U -- one page up             @G -- find next                |\n"
    "| Page_Down   or ^V -- one page down           F3 -- find next                |\n"
    "| Home        or ^A -- goto beg. of line       ^L -- find next                |\n"
    "| End         or ^E -- goto end  of line                                      |\n"
    "| Del         or ^D -- delete char under cursor                               |\n"
    "| Backspace   or ^H -- delete char to the left                                |\n"
    "| ^K^U              -- goto beg. of file                                      |\n"
    "| ^K^V              -- goto end  of file                                      |\n"
    "| ^Y                -- kill current line     ^T   -- toggle auto indent       |\n"
    "| F1 or ^H on 1:1   -- this help screen      ^C   -- quit without save NOW!   |\n"
    "| F2 or ^K^D        -- save file             ^X   -- Save All and Quit Now    |\n"
    "|                                                                             |\n"
    "| No UNDO! If you make a mistake -- quit the file without saving it!          |\n"
    "| --------------------------------------------------------------------------- |\n"
    "| You can replace this editor with external one -- see VFU docs for details!  |\n"
    "+-----------------------------------------------------------------------------+"
     , cCYAN ); ConGetch(); SeedDraw();
  }

////////////////////////////////////////////////////////////////////////////
//
//
//

  void Seed()
    {


    //---------read seed.options---
    String SOFile = GetRcDir( "seed" );
    SOFile += "seed.options";

    TSeedOptions tmp_seedopt;
    memset( &seedopt, 0, sizeof(seedopt) );
    if ( fload_crc32( SOFile, &tmp_seedopt, sizeof(tmp_seedopt) ) == 0 )
      memcpy( &seedopt, &tmp_seedopt, sizeof( seedopt ));
    //----------------------------

    SeedSetFile( 0 );
    
    ConCShow();
    SeedDraw();
    ConXY( SCOL, SROW );

    SV.settype(1);
    INS = 1;

    int key;
    int pend = 0; // used mainly for the ^K^x commands
    while(4)
      {
      int ox  = SCOL;
      int oy  = SROW;
      int orp = ROWPG;
      int ocp = COLPG;
      int oi  = INS;

      pend = 0;
      key = ConGetch();
      if (key == KEY_CTRL_C)
        break;
      if (key == KEY_CTRL_X)
        {
          SeedSave();
          break;
        } else
      if (key == 27)
        if ( SeedRequestQuit() == 0 )
          break;
        else
          continue;
      if ( key == KEY_CTRL_K )
        {
        pend = key;
        ConOut( SCOL, SROW, "^K", SeedSLColor );
        ConXY( SCOL, SROW );
        key = ConGetch();
        SeedDrawLine( ROW );
        }

      switch( key )
        {
        case KEY_CTRL_N:
        case KEY_DOWN  : SeedDown(); break;
        case KEY_CTRL_P:
        case KEY_UP    : SeedUp(); break;
        case KEY_CTRL_B:
        case KEY_LEFT  : SeedLeft(); break;
        case KEY_CTRL_F:
        case KEY_RIGHT : SeedRight(); break;
        case KEY_CTRL_U: if ( pend == KEY_CTRL_K )
                           SeedBegFile();
                         else
                           SeedPPage();
                         break;
        case KEY_PPAGE : SeedPPage(); break;
        case KEY_CTRL_V: if ( pend == KEY_CTRL_K )
                           SeedEndFile();
                         else
                           SeedNPage();
                         break;
        case KEY_NPAGE : SeedNPage(); break;
        case KEY_CTRL_A:
        case KEY_HOME  : SeedHome(); break;
        case KEY_CTRL_E:
        case KEY_END   : SeedEnd();  break;
        case KEY_INSERT: INS = !INS; break;

        case KEY_CTRL_Y: SeedKillLine(); break;

        // SeedKxxx functions are for KEYxxx handles
        case KEY_F1        : SeedHelp(); break;

        case KEY_BACKSPACE :
        case KEY_CTRL_H    : if ( COL == 0 && ROW == 0 )
                               SeedHelp();
                             else
                               SeedKBS();
                             break;
                             
        case KEY_F2        : SeedSave(); break;
        case KEY_CTRL_D    : if ( pend == KEY_CTRL_K )
                               SeedSave();
                             else
                               SeedKDEL();
                             break;

        case KEY_ALT_F     : SeedFind(); break;

        case KEY_ALT_G     :
        case KEY_CTRL_L    :
        case KEY_F3        : SeedFindNext(); break;

        case KEY_DEL       : SeedKDEL(); break;

        case 10            :
        case 13            : SeedKEnter(); break;
        
        case KEY_CTRL_R    : ConCS(); SeedDraw(); break;
        case KEY_CTRL_W    : SeedPipeIns(); break;

        case KEY_CTRL_T    : seedopt.autoindent = !seedopt.autoindent;
                             SeedMsg( (seedopt.autoindent) ? "AutoIndent ON" : "AutoIndent OFF" );
                             break;

        case KEY_ALT_0  :
        case KEY_ALT_1  :
        case KEY_ALT_2  :
        case KEY_ALT_3  :
        case KEY_ALT_4  :
        case KEY_ALT_5  :
        case KEY_ALT_6  :
        case KEY_ALT_7  :
        case KEY_ALT_8  :
        case KEY_ALT_9  : if (key == KEY_ALT_0) key = KEY_ALT_9+1;
                          SeedSetFile( key - KEY_ALT_1 ); break;
        case 27         : break;
        default         : SeedKInsert( key ); break;

        };

        if ( ox != SCOL || oy != SROW )
          {
          SeedDraw( -1 ); // just update status line
          ConXY( SCOL, SROW );
          }
        if ( orp != ROWPG || ocp != COLPG || oi != INS )
          {
          SeedDraw();
          ConXY( SCOL, SROW );
          }

      };
    
    ConCHide();
    SeedCloseAll();
    ConCS();
    //-----------write opt file---
    fsave_crc32( SOFile, &seedopt, sizeof( seedopt ) );
    //----------------------------
    
    };
  

#ifdef _SEED_EXE_
//////////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
  if (argc < 2)
    {
    printf( "usage: %s filename filename...\n", argv[0] );
    return 100;
    };

  ConInit();
  ConCHide();

//  SeeSLColor = chYELLOW;

  SeedInit();
  int z = 0;
  for ( z = 1; z < argc; z++ )
    SeedAddFile( argv[z] );
  Seed();

  ConCShow();
  ConDone();
  return 0;
}
#endif
