/*
 * Hardware tuning for the Intel 82443EX/LX bridge
 */

#define PCI_DEVICE_ID_Intel_82443EX_LX 0x7180

static Tweaks_t Intel_82443EX_LX_Tweaks[] = {
	/* Tagname						Reg		Mask	Bit		Description	*/
	{ "WRITE_POST_IO_BRIDGE",		0x53,	1<<5,	1<<5,	"Write post during IO bridge access" },
	{ "CPU_TO_PCI_IDE_POSTING",		0x53,	1<<6,	1<<6,	"CPU to PCI IDE posting" },
	{ "FAST_MA_WAITSTATES",			0x58,	1<<0,	1<<0,	"Fast MA Waitstates" },
	{ "SDRAM_2CLK_RAS_PRECHARGE",	0x58,	1<<5,	1<<5,	"2 CLK SDRAM RAS PRECHARGE" },
	{ "SDRAM_2CLK_CAS_LATENCY",		0x58,	1<<6,	1<<6,	"2 CLK SDRAM CAS LATENCY" },
	{ "SDRAM_RAS_TO_CAS_DELAY",		0x58,	1<<7,	1<<7,	"2 CLK SDRAM RAS TO CAS DELAY" },
	{ 0, 0, 0, 0, 0 }
};
