/*
 Matrox video BIOS area decoding routines.
 
 (C) 2000 Dave Jones.

*/

/*******************************************
 Decode BIOS area
 *******************************************/
int decode_biosarea(char **TextPtr, char *memptr)
{
	unsigned char *offset;
	int hardwarerev;
	int pinsoffset;
	short subsys_vendor;
	char *LSIptr;
	static char LSIstring[]= "Copyright (C) LSI Logic Corporation 1990-1991\r\n\r\n\0";

/*	unsigned char checksum=0;
*/
	int i=0;

	offset = memptr + 0x78;
	*TextPtr+=sprintf(*TextPtr, "BIOS filename\t: %s\n", offset);

	/* Garg, another bug.
	   Seems that this field isn't always stored at 0x7ff0.
	   To get around this, we must use the official method of sizing VRAM,
	   which is to call Int 10h AX=4f14 BL=0, ES:DI=256 byte buffer.
	   Offset 2b-2c == Video ram in 64Kb units. I'll do this in the next version. */
	//offset = memptr + 0x7ff0;
	//printf("Video ram\t: %dMb.\n", *offset);

	offset = memptr + 0x7ff9;
	subsys_vendor = *offset<<8;
	offset--;
	subsys_vendor |= *offset;
	*TextPtr+=sprintf(*TextPtr, "SUBSYS_VID\t: ");
	switch (subsys_vendor) {
	    case 0x102b :	*TextPtr+=sprintf(*TextPtr, "Matrox Graphics Inc.\n");
						break;
	    case 0x1014 :	*TextPtr+=sprintf(*TextPtr, "IBM.\n");
						break;
	    case 0x110A :	*TextPtr+=sprintf(*TextPtr, "Siemens.\n");
						break;
	    default	:		*TextPtr+=sprintf(*TextPtr, "%x Unknown vendor! Inform author.\n", subsys_vendor);
						break;
	}

	offset = memptr + 0x7ffa;
	hardwarerev = *offset;
	*TextPtr+=sprintf(*TextPtr, "Hardware rev\t: %x\n", hardwarerev);

	offset = memptr + 0x7ffd;
	pinsoffset = *offset<<8;
	offset--;
	pinsoffset |= *offset;

/*	offset = memptr + 0x7fff;
	printf ("\tBIOS Checksum\t: %x (", *offset);

 TODO: Fix this calculation. Sum of all bytes in BIOS image modulo 256 must be 0
	for (i=0; i<0x7fff ; i++) {
	    checksum += *offset++;
	}
	TextPtr+=sprintf (TextPtr, "in");
	TextPtr+=sprintf (TextPtr, "valid)\n");
*/

	offset = memptr;
	LSIptr = LSIstring;
	for (i=0; i<0x7fff ; i++) {
	    if (strncmp (offset, LSIptr, strlen(LSIstring)) == 0) {
			offset += strlen(LSIstring);
			offset++;
			*TextPtr+=sprintf(*TextPtr, "Option byte\t: %x (Signon message %s)\n",
				*offset, ((*offset & 1) ? "enabled" : "disabled"));
			break;
	    }
	    offset++;
	}
	
//	TextPtr+=sprintf(TextPtr, "\n");
	return (pinsoffset);
}
