/*
 * JFBTERM -
 * Copyright (C) 1999  Noritoshi MASUICHI (nmasu@ma3.justnet.ne.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NORITOSHI MASUICHI ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL NORITOSHI MASUICHI BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/vt.h>
#include <sys/kd.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>


#include <pcf.h>
#include <font.h>
#include <fbcommon.h>
#include <term.h>
#include <vterm.h>
#include <message.h>
#include <mytypes.h>
#include <getcap.h>


#ifdef SYSCONFDIR
#define	FILE_JFBTERM_CONF	SYSCONFDIR"/jfbterm.conf"
#else
#define	FILE_JFBTERM_CONF	"/etc/jfbterm.conf"
#endif

TFrameBufferMemory gFramebuffer;

#if 0
static void tf_get_options(int argc, const char *argv[])
{
	int i;
	struct TF_FontList *flist = &tf_fontlist;

	memset((void*)flist, 0, sizeof(*flist));
	for (i = 1 ; i < argc ; i++) {
		if (strncmp("--font=", argv[i], 7) == 0) {
			char *fp;
			int len = strlen(argv[i]+7);
			if((fp = (char*)malloc(len+1)) == NULL)
				die("get_options: %s\n",strerror(errno));
			strncpy((void*)fp,argv[i]+7,len);
			*(fp+len) = '\0';
			flist->font = fp;
			if((flist->next = (struct TF_FontList*)
					malloc(sizeof(*flist))) == NULL)
				die("get_options: %s\n",strerror(errno));
			flist = flist->next;
			memset((void*)flist, 0, sizeof(*flist));
		}
		if (strncmp("--gamma=", argv[i], 8) == 0)
			fbgamma = (float)atof(argv[i] + 8);
	}
}
#endif

typedef struct Raw_TApplication {
	TBool gOrigVirtualConsoleQ;
	int gOrigVirtualConsole;
	TBool gCapsQ;
	TCaps gCaps;
} TApplication;

static TApplication gApp;

void tapp_change_to_original_console(TApplication* p)
{
        int cfd;
	int n = p->gOrigVirtualConsole;

/*
        signal(SIGUSR1, SIG_DFL);
        signal(SIGUSR2, SIG_DFL);
*/

        cfd = open("/dev/console", O_WRONLY);
        if (cfd < 0 && (cfd = open("/dev/console", O_RDONLY)) < 0) {
                print_strerror("/dev/console");
        }
        if (ioctl(cfd, VT_ACTIVATE, n) != 0) {
                fprintf(stderr, "can't activate VC(%d)", n);
        }
        close(cfd);
}

void tapp_final(TApplication* p)
{
	if (p->gCapsQ) {
		tcaps_final(&(p->gCaps));
	}
	if (p->gOrigVirtualConsoleQ) {
		tapp_change_to_original_console(p);
	}
}

void tapp_final_at_exit(void)
{
	tapp_final(&gApp);
}

void tapp_init(TApplication* p)
{
	p->gOrigVirtualConsoleQ	= FALSE;
	p->gOrigVirtualConsole	= -1;
	tcaps_init(&(p->gCaps));
	p->gCapsQ	= TRUE;

	atexit(tapp_final_at_exit);
}

void tapp_change_to_new_console(TApplication* p)
{
        struct vt_stat vts;
        int cfd;
        int vfd;
        int vtNum;
        int child;
        int parent;
        char vtty[128];
        int mode;

        cfd = open("/dev/console", O_WRONLY);
        if (cfd < 0 && (cfd = open("/dev/console", O_RDONLY)) < 0) {
                die("can't open /dev/console");
        }
#if 1
        ioctl(cfd, KDGETMODE, &mode);
        if (mode == KD_TEXT) {
                close(cfd);
                return;
        }
#endif
        ioctl(cfd, VT_GETSTATE, &vts);
	p->gOrigVirtualConsole	= vts.v_active;
	p->gOrigVirtualConsoleQ	= TRUE;

        ioctl(cfd, VT_OPENQRY, &vtNum);
        if (vtNum < 0) {
                die("can't get free VC");
        }
        parent = getpid();
        if ((child = fork()) == -1) {
                print_strerror_and_exit("fork");
        }
        if (child) {
                fprintf(stderr, "\r\nJFBTERM> switched to new VC\r\n");
		p->gOrigVirtualConsoleQ	= FALSE;
                exit(EXIT_SUCCESS);
        }
        setsid();
        sprintf(vtty, "/dev/tty%d", vtNum);
        if ((vfd = open(vtty, O_RDWR)) < 0) {
                die("can't open %s", vtty);
        }
        if (ioctl(cfd, VT_ACTIVATE, vtNum) != 0) {
                die("can't activate VC(%d)", vtNum);
        }
/*
        atexit(change_to_original_console);
*/
        close(cfd);
        dup2(vfd, 0);
        dup2(vfd, 1);
        dup2(vfd, 2);
}


int main(int argc, const char *argv[])
{
	TCapability* fcap;
	char* cp;
	const char* tn;
	const char* en;

	tapp_init(&gApp);

	fprintf(stderr,
		"%s - Kanji on framebuffer console Version %s\n"
		"	Copyright (C) 1999 Noritoshi Masuichi\n"
		"This program is based on KON2\n"
		"	Copyright (C) 1992-1996 Takashi MANABE\n\n",
		PACKAGE, VERSION);

	if (geteuid() != 0) {
		fprintf(stderr, "permission denied.\n");
		exit(EXIT_FAILURE);
	}

	tcaps_read(&(gApp.gCaps), FILE_JFBTERM_CONF);
	fcap = tcaps_find(&(gApp.gCaps), "fontset"); 
	if (!fcap || !(fcap->values)) {
		fprintf(stderr, "no font specified.\n");
		exit(EXIT_FAILURE);
	}

	if ((cp = tcaps_find_first(&(gApp.gCaps), "gamma")) != NULL) {
		fbgamma = (float)atof(cp);
	}

	tapp_change_to_new_console(&gApp);

	tfbm_init(&gFramebuffer);
	
	tfont_setup_fontlist(fcap->values);

	tfbm_open(&gFramebuffer);

	tn = tcaps_find_first(&(gApp.gCaps), "term");
	if (!tn) {
		tn = "kon";
	}
	en = tcaps_find_first(&(gApp.gCaps), "encoding");
	if (!en) {
		en = "G0,G1,ASCII,ISO8859-1,ASCII,ASCII";
	}
	tterm_start(&gTerm, tn, en);

	tfbm_close(&gFramebuffer);
	tfont_ary_final();

	exit(EXIT_SUCCESS);
}

	
