/******************************************************************************\
 gnofin/view.h   $Revision: 1.12 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef FIN_VIEW_H
#define FIN_VIEW_H

#include "account.h"
#include "record.h"
#include "history.h"
#include "import.h"
#include "export.h"

#define FIN_VIEW_NUMCOLS 6

typedef struct _FinView             FinView;
typedef struct _FinViewConfig	    FinViewConfig;

/* this data is stored in ~/.gnome/gnofin 
 * it represents configuration settings that
 * do not depend on a particular data set */
struct _FinViewConfig
{
  guint   width;	/* width of main view */
  guint   height; 	/* height of main view */

  guint   col_widths[FIN_VIEW_NUMCOLS];	/* column spacing */
};

struct _FinView
{
  GtkWidget	* window;
  GtkWidget     * notebook;
  GtkCList	* clist;	/* pointer to current clist */
  GtkWidget	* scroll;
  GtkWidget     * cleared_bal;
  GtkWidget	* filesel;	/* file open/save dialog */
  guint		  notebook_switch_page_id;

  GtkWidget	* account_dialog;  /* account info dialog */
  GtkWidget	* account_name;
  GtkWidget	* account_info;
  GtkWidget	* account_button_ok;
  guint		  account_button_signal_id;
  
  GtkWidget	* record_date;
  GtkWidget	* record_source;
  GtkWidget	* record_check_no;
  GtkWidget	* record_transfer_acct;
  GtkWidget	* record_info;
  GtkWidget	* record_amount;

  GtkWidget	* calendar_dialog;
  GtkWidget	* calendar_button;
  GtkWidget	* calendar;

  GtkWidget	* insert_button;
  GtkWidget	* update_button;

  GtkWidget	* statusbar;

  GtkWidget	* tool_file_save;
  GtkWidget	* tool_edit_undo;
  GtkWidget	* tool_edit_redo;
  GtkWidget	* tool_record_delete;
  GtkWidget	* tool_record_toggle_status;

  GtkWidget	* menu_file_save;
  GtkWidget	* menu_file_save_as;
  GtkWidget	* menu_edit_undo;
  GtkWidget	* menu_edit_redo;
  GtkWidget	* menu_edit_cut;
  GtkWidget	* menu_edit_copy;
  GtkWidget	* menu_edit_paste;
  GtkWidget	* menu_edit_select_all;
  GtkWidget	* menu_edit_find;
  GtkWidget	* menu_edit_find_again;
  GtkWidget	* menu_account_delete;
  GtkWidget	* menu_account_props;

  GtkStyle	* negative_balance_style;

  FinHistory	* history;

  FinAccountSet	* set;		/* current account set */
  FinAccount	* account;	/* current account */
  FinRecordType	  current_record_type;
  gchar        ** account_names;

  gchar		* filename;
  gint		  next_check_no;

  FinViewConfig	  config;

  GList         * imports;  /* list of FinImportFilter structs */
  GtkWidget	* menu_file_imports;

  GList         * exports;  /* list of FinExportFilter structs */
  GtkWidget	* menu_file_exports;

  gint		  selection;	/* current element selected in clist */
  gint		  page;		/* current page of notebook */

  gint		  dirty;	/* count of unsaved changes */
  gint		  can_update : 1;

  gint		  info_key_press_skip : 1;
  guint		  info_insert_text_id;
  guint		  info_key_press_id;

  guint		  entry_date_changed_id;
  guint		  calendar_month_changed_id;
  guint		  calendar_day_changed_id;
};

FinView * fin_view_new                (void);
gboolean  fin_view_load_file          (FinView * view, const gchar * filename);
void	  fin_view_load_config        (FinView * view);
void	  fin_view_save_config        (FinView * view);
void	  fin_view_load_import_filter (FinView * view, FinImportFilter * import);
void	  fin_view_load_export_filter (FinView * view, FinExportFilter * export);

#endif
