#!/bin/sh
make

if test q$TAPE = q ; then export TAPE=/dev/nst0 ; fi
case $TAPE in
/dev/nst0|/dev/st0) V=`scsi_vendor tape 1` ;;
/dev/nst1|/dev/st1) V=`scsi_vendor tape 2` ;;
esac

echo Tape vendor is $V
echo =======================

case $V in
HP) B=32 ;;
*) B=32 ;;
esac

echo $B

echo 'dds2tar-test >' make
make

echo ' '
echo 'dds2tar-test >' 'make of?'
if test ! -x ./dds2tar ; then exit 1 ; fi

echo ' '
echo 'dds2tar-test >' creating soft links
ln -sf ./dds2tar ./dds2index
ln -sf ./dds2tar ./mt-dds

echo ' '
echo 'dds2tar-test >' creating soft and hard links
ln -s dds2tar dds2tar-test-tape-link-soft
ln dds2tar dds2tar-test-tape-link-hard

echo ' '
echo 'dds2tar-test >' tar c .
tar c .

echo ' '
echo 'dds2tar-test >' tar -c --label dds2tar -b $B ... .
tar --label dds2tar --record-file index-of-tar -R -v -c -b $B .

I=`grep 'number of the file' index-of-tar | cut -c 38-43`
if test q"$I" = q ; then I=1 ; fi 
if test $I = 0 ; then exit 1 ; fi
I=`expr $I - 1`
echo file number of the archive written is $I
if test "$I" = "" ; then exit 1 ; fi

echo ' '
echo 'dds2tar-test >' tar -c . ...
tar --record-file index-of-tar-v -v -R -v -c -b $B .

echo ' '
echo 'dds2tar-test >' mt rewind \; mt fsf $I
mt rewind ; mt fsf $I

echo ' '
echo 'dds2tar-test >' mt-dds tell
./mt-dds tell

echo ' '
echo 'dds2tar-test >' mt-dds label
./mt-dds label

echo ' '
echo 'dds2tar-test >' mt-dds
./mt-dds

echo ' '
echo 'dds2tar-test >' dds2index
./dds2index -t index-of-dds2index

echo ' '
echo 'dds2tar-test >' find '*tape*' using index-of-tar
./dds2tar -t index-of-tar '*tape*' | tar fvt -

echo ' '
echo 'dds2tar-test >' find '*tape*' using index-of-tar-v
./dds2tar -t index-of-tar-v '*tape*' | tar fvt -

echo ' '
echo 'dds2tar-test >' find '*tape*' using index-of-dds2index
./dds2tar -t index-of-dds2index '*tape*' | tar vft -

echo ' '
echo 'dds2tar-test >' dds2tar -t index-of-tar --body Changes '|wc -c'
./dds2tar -t index-of-tar --body Changes | wc -c
ls -l Changes

if test $I -eq 0 ; then
	echo 'dds2tar-test >' mt rewind
	mt rewind
else
	echo 'dds2tar-test >' mt rewind \; mt fsf $I
	mt rewind ; mt fsf $I
fi

echo ' '
echo mt-dds
mt-dds

echo ' '
echo 'dds2tar-test > mt-dds tell >'index-of-tar-t
mt-dds tell >index-of-tar-t
echo 'dds2tar-test > tar tR >>' index-of-tar-t
tar tR >> index-of-tar-t
echo 'dds2tar-test >' grep -v "'loc        '" '< index-of-tar-t > index-of-tar-t2'
grep -v 'loc        ' < index-of-tar-t > index-of-tar-t2
echo 'dds2tar-test >' find '*tape*' using index-of-tar-t2 and mt-dds
echo 'dda2tar-test >' ./dds2tar '`mt-dds`' -t index-of-tar-t2 '*tape*' | tar bvft 1 -
./dds2tar `mt-dds` -t index-of-tar-t2 '*tape*' | tar bvft 1 -

if test $I -eq 0 ; then
	echo 'dds2tar-test >' mt rewind
	mt rewind
else
	echo 'dds2tar-test >' mt rewind \; mt fsf $I
	mt rewind ; mt fsf $I
fi
echo 'dds2tar-test >' removing links
/bin/rm dds2tar-test-tape-link-soft
/bin/rm dds2tar-test-tape-link-hard

