#!/usr/local/bin/perl
#
# nkf test program for nkf 1.7
#    Shinji KONO <kono@ie.u-ryukyu.ac.jp>
# Sun Aug 18 12:25:40 JST 1996
# Sun Nov  8 00:16:06 JST 1998
#
# This is useful when you add new patch on nkf.
# Since this test is too strict, faileurs may not mean
# wrong conversion. 
#
# nkf 1.5 differs on MIME decoding
# nkf 1.4 passes Basic Conversion tests
# nkf PDS version passes Basic Conversion tests  using "nkf -iB -oB "
#

$nkf = "./nkf";
# $nkf = "doscmd nkf.exe";

# If you want to see the testing process, set next flag.

$detail_all = 0;
$error_count=1;

# &library_test0();
sub test {
    &command_test(@_);
}

sub command_test {
    local ($nkf,$in,$ans,$detail) = @_;
    local ($result);

    $result = '';
    open(OUT,"> nkf.in");
    print OUT $in;
    close(OUT);
    system("$nkf <nkf.in >nkf.out");   # easy
    open(IN,"< nkf.out");
    print STDERR "\nINPUT:\n",$in  if ($detail || $detail_all);
    print STDERR "\nEXPECT:\n", $ans if ($detail || $detail_all);
    while(<IN>) {
	$result .= $_;
    }
    print STDERR "\nGOT:\n",$result if ($detail || $detail_all);
    if( $nkf =~ /-m/) {
	$result =~ s/ //g;
	$ans =~ s/ //g;
    }
    if ($result ne $ans) {
	print "Fail\n";
	system "mv nkf.in nkf.in.$error_count.bad";
	system "mv nkf.out nkf.out.$error_count.bad";
	open(OUT,"> nkf.expect.$error_count.bad");
	print OUT $ans;
	close(OUT);
	$error_count++;
    } else {
	print "Ok\n";
    }
    return $result;
}

do "nkf_test.pl";

