/*
 * Copyright (c) 1997, 1998, 1999  Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/*
 * This program requires the following Autoconf macros:
 *   AC_C_CONST
 *   AC_TYPE_SIZE_T
 *   AC_CHECK_TYPE(ssize_t, int)
 *   AC_CHECK_HEADERS(unistd.h, fcntl.h)
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <errno.h>
#include <syslog.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#else
#include <sys/file.h>
#endif

#ifdef __STDC__
#define VOID void
#else
#define VOID char
#endif


/*
 * Read data from a file.
 * It repeats to call read() until all data will have been read.
 */
ssize_t
read_all(file, buffer, nbytes)
    int file;
    VOID *buffer;
    size_t nbytes;
{
    char *bufp = buffer;
    ssize_t rest = nbytes;
    ssize_t n;

    while (0 < rest) {
	errno = 0;
	n = read(file, bufp, rest);
	if (n < 0) {
	    if (errno == EINTR)
		continue;
	    syslog(LOG_ERR, "read() failed, %m");
	    return n;
	} else if (n == 0) {
	    syslog(LOG_ERR, "read() EOF received");
	    return nbytes - rest;
	} else {
	    rest -= n;
	    bufp += n;
	}
    }

    return nbytes;
}


/*
 * Write data to a file.
 * It repeats to call write() until all data will have written.
 */
ssize_t
write_all(file, buffer, nbytes)
    int file;
    const VOID *buffer;
    size_t nbytes;
{
    const char *bufp = buffer;
    ssize_t rest = nbytes;
    ssize_t n;

    while (0 < rest) {
	errno = 0;
	n = write(file, bufp, rest);
	if (n < 0) {
	    if (errno == EINTR)
		continue;
	    syslog(LOG_ERR, "write() failed, %m");
	    return n;
	} else if (n == 0) {
	    syslog(LOG_ERR, "write() EOF received");
	    return n;
	} else {
	    rest -= n;
	    bufp += n;
	}
    }

    return nbytes;
}


