/*
 * GdiffOverview widget header
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_OVERVIEW_H__
#define __GDIFF_OVERVIEW_H__

#include <gdk/gdk.h>
#include <gtk/gtkadjustment.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtksignal.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_OVERVIEW			(gdiff_overview_get_type())
#define GDIFF_OVERVIEW(obj)			GTK_CHECK_CAST(obj, gdiff_overview_get_type(), GdiffOverview)
#define GDIFF_OVERVIEW_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, gdiff_overview_get_type(), GdiffOverviewClass)
#define GDIFF_IS_OVERVIEW(obj)		GTK_CHECK_TYPE(obj, gdiff_overview_get_type())
	
	
typedef struct _GdiffOverview       GdiffOverview;
typedef struct _GdiffOverviewClass  GdiffOverviewClass;

struct _GdiffOverview {
	GtkWidget widget;

	gint slider_y;
	gint slider_length;
	GtkAdjustment *adjustment;
	gfloat old_value;
	gfloat old_lower;
	gfloat old_upper;
	gfloat old_page_size;
	GdkGC *xor_gc;	/* for slider */
	/* for ranges */
	GdkGC *range_gc;
	GdkColor *range_fg;
	GdkColor *range_bg;
	
	/* range display */
	GSList *range_list;/* Singly linked list of PaintRange */
};

struct _GdiffOverviewClass {
  GtkWidgetClass parent_class;
};


GtkType gdiff_overview_get_type(void);
GtkWidget* gdiff_overview_new(GtkAdjustment *adjustment);
void gdiff_overview_size(GdiffOverview *overview, gint width, gint height);
void gdiff_overview_set_adjustment(GdiffOverview *overview, GtkAdjustment *adjustment);
/* insert a paint area, specified by begin and end (0.0 - 1.0) */
void gdiff_overview_insert_paintrange(GdiffOverview *overview, gdouble begin, gdouble end);
/* sets the color, the color must already be allocated */
void gdiff_overview_set_foreground(GdiffOverview *overview, GdkColor *color);
void gdiff_overview_set_background(GdiffOverview *overview, GdkColor *color);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GDIFF_OVERVIEW_H__ */
