#ifndef __str_repl_hh__
#define __str_repl_hh__

#include "repl.hh"

namespace afilter {

  class str_repl {
  public:
    virtual str_repl * clone() const = 0;
    virtual bool convert_needed() const {return true;}
    virtual string convert(const char *) const = 0;
    string convert(const string & str) {return convert(str.c_str());}
  };

  class str_repl_straight_through : public str_repl {
  public:
    str_repl_straight_through * clone() const
    {return new str_repl_straight_through(*this);}
    bool convert_needed() const {return false;}
    string convert(const char * str) const {return str;}
  };

  class str_itr {
    const char * cur;
  public:
    str_itr(const char * i) : cur(i) {}
    char value() const {return *cur;}
    char next() {++cur; return *cur;}
    void operator++() {++cur;}
  };

  struct str_repl_types {
    typedef str_itr         Itr;
    typedef str_itr         ItrRoot;
    typedef char            InValue;
    typedef char            Value;
    typedef string          Buffer;
    typedef CharReplBase<str_repl_types> Base;
  };

  template <class CharRepl> 
  class str_repl_templ {
  private:
    CharRepl cr;
  public:
    str_repl_templ * clone() {return new str_repl_templ(*this);}
    string convert(const char * i) const {
      str_itr in(i);
      string  out;
      while (in.value() != '\0') {
	cr.fill(in.value(), &in, &out);
	++in;
      }
      return out;
    }
  };

}

#endif
