#!/bin/sh

DATE=`date "+19%y/%m/%d"`

FILES="tipa8 tipa9 tipa10 tipa12 tipa17 tipasl8 tipasl9 tipasl10 tipasl12 \
	tipabx8 tipabx9 tipabx10 tipabx12 tipass8 tipass9 tipass10 tipass12 \
	tipass17 tipab10"

for FNAME in $FILES
do
  case "$FNAME" in
    tipa8)    NUM=3; FID="TIPA";  FSIZE="8"; FDESC="Roman 8" ;;
    tipa9)    NUM=4; FID="TIPA";  FSIZE="9"; FDESC="Roman 9" ;;
    tipa10)   NUM=5; FID="TIPA";  FSIZE="10";FDESC="Roman 10" ;;
    tipa12)   NUM=6; FID="TIPA";  FSIZE="12";FDESC="Roman 12" ;;
    tipa17)   NUM=7; FID="TIPA";  FSIZE="17.28";FDESC="Roman 17.28" ;;
    tipasl8)  NUM=8; FID="TIPASL";FSIZE="8"; FDESC="Slanted Roman 8" ;;
    tipasl9)  NUM=9; FID="TIPASL";FSIZE="9"; FDESC="Slanted Roman 9" ;;
    tipasl10) NUM=10;FID="TIPASL";FSIZE="10";FDESC="Slanted Roman 10" ;;
    tipasl12) NUM=11;FID="TIPASL";FSIZE="12";FDESC="Slanted Roman 12" ;;
    tipabx8)  NUM=12;FID="TIPABX";FSIZE="8"; FDESC="Bold Extended Roman 8" ;;
    tipabx9)  NUM=13;FID="TIPABX";FSIZE="9"; FDESC="Bold Extended Roman 9" ;;
    tipabx10) NUM=14;FID="TIPABX";FSIZE="10";FDESC="Bold Extended Roman 10" ;;
    tipabx12) NUM=15;FID="TIPABX";FSIZE="12";FDESC="Bold Extended Roman 12" ;;
    tipass8)  NUM=16;FID="TIPASS";FSIZE="8"; FDESC="Sans Serif 8" ;;
    tipass9)  NUM=17;FID="TIPASS";FSIZE="9"; FDESC="Sans Serif 9" ;;
    tipass10) NUM=18;FID="TIPASS";FSIZE="10";FDESC="Sans Serif 10" ;;
    tipass12) NUM=19;FID="TIPASS";FSIZE="12";FDESC="Sans Serif 12" ;;
    tipass17) NUM=20;FID="TIPASS";FSIZE="17.28";FDESC="Sans Serif 17.28" ;;
    tipab10)  NUM=21;FID="TIPAB"; FSIZE="10";FDESC="Bold Roman 10" ;;
  esac

  echo "% $FNAME.mf: TIPA $FDESC point parameter file" > $FNAME.mf
  echo "%   Version 1.0 $DATE FUKUI Rei" >> $FNAME.mf
  echo '% This file is based on:' >> $FNAME.mf
  echo '%   Computer Modern font series by D. E. Knuth and' >> $FNAME.mf
  echo '%   TSIPA by KOBAYASHI Hajime, FUKUI Rei and SHIRAKAWA Shun.' >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo 'if unknown cmbase: input cmbase fi' >> $FNAME.mf
  echo 'if unknown tipabase: input tipabase fi' >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo "font_identifier:=\"$FID\"; font_size ${FSIZE}pt#;" >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo 'Times_Compat:=false;' >> $FNAME.mf
  echo 'if Times_Compat: input tipatr fi' >> $FNAME.mf
  echo '' >> $FNAME.mf
  awk "{if (\$1 == \"p\") {
     if (\$$NUM == \"0\") print \$2 \"#:=\" \$$NUM \"pt#;\";\
     else print \$2 \"#:=\" \$$NUM \"/36pt#;\";\
   }\
   else if (\$1 == \"P\") print \$2 \"#:=\" \$$NUM \"pt#;\";\
   else if (\$1 == \"n\") print \$2 \":=\"  \$$NUM \";\";}" param1.def |\
  sed 's/SQ/sqrt/' >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo 'generate tipa    % switch to the driver file' >> $FNAME.mf
done

exit 0
