/*
 * VFlib font (family of vector fonts)
 */
#include	"defs.h"
#include	"global.h"
#include	"bifont.h"

/* ratio of depth of char (1 = 1<<20) */
#define	DEPTHRATIO	165565

char *vfontcap = NULL;
BOOLEAN vfl_init = FALSE;

void getvfcap();
struct confop vfccop = {
    "vfontcap",
    getvfcap
};

void
getvfcap()
{
    char field_file[PATHLEN];
    char vfcap[PATHLEN];

    getfield(field_file);
    skipline();
    defexpand(vfcap, field_file);
    vfontcap = strsave(vfcap);
}

int depthratio = DEPTHRATIO;

void getvflbase();
struct confop vfbcop = {
    "vflbaseline",
    getvflbase
};

void
getvflbase()
{
    char field_number[PATHLEN];
    char ratio[PATHLEN];

    getfield(field_number);
    skipline();
    defexpand(ratio, field_number);
    depthratio = atoi(ratio);
}

#ifdef VFLIB

void
init_vfl_fontinfo(fe)
struct font_entry *fe;
{
    int	jmm_markchar();
    void read_vfl_fontinfo();

    biinifinfo(fe) = alloc_jbiinif(biaccinfo(fe)->bf);
    fe->fnt_markchar = jmm_markchar;
    fe->fnt_readfontinfo = read_vfl_fontinfo;
}

vfl_initialize()
{
    if (!vfl_init) {
#ifdef DEBUG
	if (Debuguser)
	    fprintf(stderr, "VFlib initializing with %s\n", vfontcap);
#endif
	if (VF_Init(vfontcap) < 0)
	    Fatal("VFlib cannot be initialized");
	vfl_init = TRUE;
    }
}

struct vflfntinfo *
read_vfl_finfo(fe, bii, tfmw, settfmw)
struct font_entry *fe;
struct biinitfontinfo *bii;
int tfmw;
BOOLEAN settfmw;
{
    struct vflfntinfo *vflfi;
    char *vfln;
    int raster, fid;
    int width, depth, height, nbpl, xoff, nwidth, ndepth, nheight;
    char *pixel, *npixel;
    long *outline;
    int i, c;
    extern int hconv, vconv;
    long *VF_GetOutline();

    vflfi = (struct vflfntinfo *)
	alloc_check(malloc((unsigned)sizeof(struct vflfntinfo)+
			   bii->maxc*sizeof(struct vflchar_entry)),
		    "vflfont info");
    vflfi->vfl_bf = bii->bf;

    for (i = 0; i <= bii->maxc; i++)
	vflfi->ch[i].dev_font = DEV_NULLFONT;
    vfln = dev_vflname(vflfi->vfl_bf);
    raster = dev_mf_kind(vflfi->vfl_bf) == MF_KIND_VFLIB;
#ifdef DEBUG
    if (Debuguser)
	fprintf(stderr, "VFlib openfont %s (for %s, %s)\n", vfln, fe->n,
		raster ? "raster" : "outline");
#endif
    if ((fid = VF_OpenFont(vfln)) < 0) {
	Warning("VFlib font %s cannot be opened", vfln);
	return vflfi;
    }

    width = pixround(tfmw, hconv);
    depth = pixround(scale(tfmw,depthratio), vconv);
    height = pixround(tfmw, vconv);
    nbpl = (width+7)>>3;
    if (raster) {
	if ((pixel = calloc((unsigned)height, (unsigned)nbpl)) == NULL)
	    Fatal("Unable to allocate memory for VFlib char\n");
	for (i = 0; i <= bii->maxc; i++) {
	    if (!(bii->mark[i]))
		continue;
	    if (settfmw)
		(vflfi->ch+i)->tfmw = tfmw;
	    bzero(pixel, height*nbpl);
	    c = idx94_to_jis(i);
	    VF_GetBitmap(c, fid, width, height, nbpl, 0, pixel);
	    trim_bitmap(width, nbpl, height, depth, pixel,
			&xoff, &nwidth, &nheight, &ndepth, &npixel);
	    dev_vfl_initfontdict(fe, vflfi, i, c, tfmw, 
				 xoff, nwidth, nheight, ndepth, npixel);
	}
	free(pixel);
    } else {
	for (i = 0; i <= bii->maxc; i++) {
	    if (!(bii->mark[i]))
		continue;
	    if (settfmw)
		(vflfi->ch+i)->tfmw = tfmw;
	    c = idx94_to_jis(i);
	    outline = VF_GetOutline(c, fid);
	    dev_vfl_initfontdict_ol(fe, vflfi, i, c, tfmw,
				    width, height, depth, outline);
	    VF_FreeOutline(outline, fid);
	}
    }

    VF_CloseFont(fid);
    return vflfi;
}

trim_bitmap(wid, bpl, hgt, dep, pixel, xo, nwid, nhgt, ndep, npixel)
int wid, bpl, hgt, dep;
char *pixel;
int *xo, *nwid, *nhgt, *ndep;
char **npixel;
{
    int ht, dt, lwt, rwt, i, j, nbpl;
    char *pixelend, *npix, *p0, *p1, *q;

    for (ht = 0; ht < hgt; ht++)
	for (i = ht*bpl; i < (ht+1)*bpl; i++)
	    if (*(pixel+i))
		goto htend;
 htend:
    hgt -= ht;
    npix = pixel+ht*bpl;

    for (dt = 0, pixelend = npix+hgt*bpl-1; dt < hgt ; dt++)
	for (i = dt*bpl; i < (dt+1)*bpl; i++)
	    if (*(pixelend-i))
		goto dtend;
 dtend:
    dep -= dt;
    hgt -= dt;

    for (lwt = 0; lwt < bpl; lwt++)
	for (i = lwt; i < hgt*bpl; i += bpl)
	    if (*(npix+i))
		goto lwtend;
 lwtend:
    for (rwt = 0; rwt < bpl; rwt++)
	for (i = bpl-1-rwt; i < hgt*bpl; i += bpl)
	    if (*(npix+i))
		goto rwtend;
 rwtend:
    npix += lwt;
    nbpl = bpl-(lwt+rwt);
    if (lwt+rwt > 0)
	for (p0 = npix+nbpl, p1 = npix+bpl, i = 1; i < hgt; p1 += bpl, i++)
	    for (q = p1, j = 0; j < nbpl; j++)
		*p0++ = *q++;

    *npixel = npix;
    *nhgt = hgt;
    *ndep = dep;
    *xo = -(lwt<<3);
    *nwid = wid-((lwt+rwt)<<3);
}

void
read_vfl_fontinfo(fe)
struct font_entry *fe;
{
    struct biinitfontinfo *bii;
    struct jfmfntinfo *jfmfi;
    void read_jfm_finfo();

    vfl_initialize();

    bii = biinifinfo(fe);
    jfmfi = NEW(struct jfmfntinfo, "jfmfont info");
    jfmfi->jfm_bf = bii->bf;
    jfmfinfo(fe) = jfmfi;	/* set only to use in read_jfm_finfo */
    read_jfm_finfo(fe);

    dev_vfl_initfe(fe);
    vflfinfo(fe) = read_vfl_finfo(fe, bii, jfmfi->ch[0].tfmw, TRUE);

    free((char *)bii);
    free((char *)jfmfi->ctype);
    free((char *)jfmfi->ch);
    free((char *)jfmfi);
}

DEV_FONT
vfl_fontdict(fe, c)
struct font_entry *fe;
int c;
{
    return vflfinfo(fe)->ch[jis_to_idx94(c)].dev_font;
}


/* jstfm
 */
void
init_jsvfl_fontinfo(fe)
register struct font_entry *fe;
{
    struct jsubshare *jss;
    int	jsmm_markchar();
    void read_jsvfl_fontinfo();

    jss = jstfmfinfo(fe)->js_share;
    if (jss->jss_stat < JSS_INIT) {
	jss->jss_info = (struct jssinfo *)alloc_jbiinif(jss->jss_bf);
	jss->jss_stat = JSS_INIT;
    }
    jstfmfinfo(fe)->js_info = jss->jss_info;
    fe->fnt_markchar = jsmm_markchar;
    fe->fnt_readfontinfo = read_jsvfl_fontinfo;
}

void
read_jsvfl_fontinfo(fe)
struct font_entry *fe;
{
    struct biinitfontinfo *bii;
    struct jsubshare *jss;
    struct jstfmfntinfo *jstfmfi;
    void read_jstfm_finfo();

    vfl_initialize();

    read_jstfm_finfo(fe);

    dev_jsvfl_initfe(fe);
    jss = jstfmfinfo(fe)->js_share;
    if (jss->jss_stat < JSS_READ) {
	bii = (struct biinitfontinfo *)jss->jss_info;
	jstfmfi = jstfmfinfo(fe);
	jss->jss_info = (struct jssinfo *)
	    read_vfl_finfo(fe, bii, jstfmfi->ch[jstfmfi->lastfntchar].tfmw, FALSE);
	jss->jss_stat = JSS_READ;
	free((char *)bii);
    }
    jstfmfinfo(fe)->js_info = jss->jss_info;
}

DEV_FONT
jsvfl_fontdict(fe, c)
struct font_entry *fe;
int c;
{
    struct jstfmfntinfo *jsfi = jstfmfinfo(fe);

    return jsvflfinfo(jsfi)->ch[jsub_to_idx94(jsfi->jsubfont,c)].dev_font;
}

#else

void
init_vfl_fontinfo(fe)
struct font_entry *fe;
{
    int null_markchar();
    void read_null_fontinfo();

    Warning("This %s is not compiled with VFlib option.\nFont %s is ignored",
	    G_progname, fe->n);
    fe->fnt_markchar = null_markchar;
    fe->fnt_readfontinfo = read_null_fontinfo;
}

void
init_jsvfl_fontinfo(fe)
struct font_entry *fe;
{
    init_vfl_fontinfo(fe);
}
#endif
