dnl aclocal.m4 generated automatically by aclocal 1.3

dnl Copyright (C) 1994, 1995, 1996, 1997, 1998 Free Software Foundation, Inc.
dnl This Makefile.in is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl -------------------------------------------------------------------------
dnl Try to find a file (or one of more files in a list of dirs).
dnl -------------------------------------------------------------------------

AC_DEFUN(AC_FIND_FILE,
    [
	$3=NO
	for i in $2;
	do
	  for j in $1;
	  do
	    if test -r "$i/$j"; then
		  $3=$i
		  break 2
		fi
	  done
	done
    ]
)

dnl -------------------------------------------------------------------------
dnl Check whether compiler has a working ``bool'' type.
dnl -------------------------------------------------------------------------

AC_DEFUN(AC_CHECK_BOOL,
[
    AC_MSG_CHECKING([for bool])
	AC_CACHE_VAL(ac_cv_have_bool,
	[
	    AC_TRY_COMPILE(
		    [],
		    [bool aBool = true;],
			[ac_cv_have_bool=yes],
			[ac_cv_have_bool=no]
		)
	 ])
	 AC_MSG_RESULT($ac_cv_have_bool)
	 if test "$ac_cv_have_bool" = yes; then
	     AC_DEFINE(HAVE_BOOL)
	 fi 
])

dnl -------------------------------------------------------------------------
dnl Check whether C++ library has member ios::bin instead of ios::binary.
dnl Will set $(HAVE_IOS_BIN) to "yes" if ios::binary is not available.
dnl -------------------------------------------------------------------------

AC_DEFUN(AC_CHECK_IOS_BIN,
[
    AC_MSG_CHECKING(whether standard member ios::binary is available)
	AC_CACHE_VAL(ac_cv_have_ios_binary,
	[	AC_TRY_COMPILE(
	        [#include <fstream.h>],
			[ifstream myTest(ios::in|ios::binary)],
			[ac_cv_have_ios_binary=yes],
			[ac_cv_have_ios_binary=no]
		)
	])
	AC_MSG_RESULT($ac_cv_have_ios_binary)
	if test "$ac_cv_have_ios_binary" = no; then
	    AC_DEFINE(HAVE_IOS_BIN)
	fi
])

dnl -------------------------------------------------------------------------
dnl Try to find SIDPLAY includes and library.
dnl $(sidplay_library) will be path to libsidplay.*
dnl $(sidplay_includes) will be path to sidplay/*.h
dnl -------------------------------------------------------------------------

AC_DEFUN(AC_PATH_LIBSIDPLAY,
[
AC_MSG_CHECKING([for SIDPLAY includes and library])
ac_sidplay_includes=NO
ac_sidplay_library=NO
sidplay_includes=""
sidplay_library=""

AC_ARG_WITH(sidplay-includes,
  [  --with-sidplay-includes=DIR
                          where the sidplay includes are located],
  [ac_sidplay_includes="$withval"
  ])

AC_ARG_WITH(sidplay-library,
  [  --with-sidplay-library=DIR
                          where the sidplay library is installed],
  [ac_sidplay_library="$withval"
  ])

if test "$ac_sidplay_includes" = NO || test "$ac_sidplay_library" = NO; then
#search common locations

AC_CACHE_VAL(ac_cv_have_sidplay,
[
sidplay_incdirs="$ac_sidplay_includes /usr/include /usr/local/include /usr/lib/sidplay/include /usr/local/lib/sidplay/include"
AC_FIND_FILE(sidplay/sidtune.h,$sidplay_incdirs,sidplay_foundincdir)
ac_sidplay_includes=$sidplay_foundincdir

sidplay_libdirs="$ac_sidplay_library /usr/lib /usr/local/lib /usr/lib/sidplay /usr/local/lib/sidplay"
AC_FIND_FILE(libsidplay.a libsidplay.so libsidplay.so.1 libsidplay.so.1.36 libsidplay.so.1.37,$sidplay_libdirs,sidplay_foundlibdir)
ac_sidplay_library=$sidplay_foundlibdir

if test "$ac_sidplay_includes" = NO || test "$ac_sidplay_library" = NO; then
  ac_cv_have_sidplay="have_sidplay=no"
  ac_sidplay_notfound=""
  if test "$ac_sidplay_includes" = NO; then
    if test "$ac_sidplay_library" = NO; then
      ac_sidplay_notfound="(headers and library)";
    else
      ac_sidplay_notfound="(headers)";
    fi
  else
    ac_sidplay_notfound="(library)";
  fi
  eval "$ac_cv_have_sidplay"
  AC_MSG_RESULT([$have_sidplay])
  AC_MSG_ERROR([SIDPLAY $ac_sidplay_notfound not found. Please check your installation!]);
else
  have_sidplay=yes
fi

])  dnl AC_CACHE_VAL(ac_cv_have_sidplay,
else
  have_sidplay=yes
fi  dnl if (have_to_search)

eval "$ac_cv_have_sidplay"

if test "$have_sidplay" != yes; then
  AC_MSG_RESULT([$have_sidplay]);
else
  ac_cv_have_sidplay="have_sidplay=yes \
    ac_sidplay_includes=$ac_sidplay_includes ac_sidplay_library=$ac_sidplay_library"
  AC_MSG_RESULT([library $ac_sidplay_library, headers $ac_sidplay_includes])
  
  sidplay_library=$ac_sidplay_library
  sidplay_includes=$ac_sidplay_includes
  
  SIDPLAY_LDFLAGS="-L$sidplay_library"
  all_libraries="$SIDPLAY_LDFLAGS $all_libraries"
  SIDPLAY_INCLUDES="-I$sidplay_includes"
  all_includes="$SIDPLAY_INCLUDES $all_includes"
fi

dnl Test compilation.

AC_MSG_CHECKING([whether -lsidplay works])
ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS

CXXFLAGS="$CXXFLAGS -I$sidplay_includes"
LDFLAGS="$LDFLAGS -L$sidplay_library"
LIBS="-lsidplay"

AC_CACHE_VAL(ac_cv_sidplay_works,
[
    AC_TRY_LINK(
	    [#include <sidplay/sidtune.h>],
		[sidTune* myTest;],
		[ac_cv_sidplay_works=yes],
		[ac_cv_sidplay_works=no]
   )
])

CXXFLAGS="$ac_cxxflags_safe"
LDFLAGS="$ac_ldflags_safe"
LIBS="$ac_libs_safe"

AC_MSG_RESULT([$ac_cv_sidplay_works])
if test "$ac_cv_sidplay_works" != yes; then
  AC_MSG_ERROR([libsidplay link error. Please check your installation!]);
fi

dnl

AC_SUBST(SIDPLAY_INCLUDES)
AC_SUBST(SIDPLAY_LDFLAGS)

AC_SUBST(sidplay_library)
AC_SUBST(sidplay_includes)

])

dnl -------------------------------------------------------------------------
dnl Try to find the X includes and libraries.
dnl -------------------------------------------------------------------------

AC_DEFUN(MY_PATH_X,
[
AC_MSG_CHECKING(for X)
AC_CACHE_VAL(ac_cv_have_x,
[# One or both of the vars are not set, and there is no cached value.
ac_x_includes=NO ac_x_libraries=NO
AC_PATH_X_DIRECT
AC_PATH_X_XMKMF
if test "$ac_x_includes" = NO || test "$ac_x_libraries" = NO; then
  AC_MSG_ERROR([Can't find X includes. Please check your installation and add the correct paths!])
else
  # Record where we found X for the cache.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$ac_x_includes ac_x_libraries=$ac_x_libraries"
fi])dnl
eval "$ac_cv_have_x"
 
if test "$have_x" != yes; then
  AC_MSG_RESULT($have_x)
  no_x=yes
else
  # If each of the values was on the command line, it overrides each guess.
  test "x$x_includes" = xNONE && x_includes=$ac_x_includes
  test "x$x_libraries" = xNONE && x_libraries=$ac_x_libraries
  # Update the cache value to reflect the command line values.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$x_includes ac_x_libraries=$x_libraries"
  AC_MSG_RESULT([libraries $x_libraries, headers $x_includes])
fi

if test -z "$x_includes" || test "x$x_includes" = xNONE; then
  X_INCLUDES=""
  x_includes="."; dnl better than nothing :-
 else
  X_INCLUDES="-I$x_includes"
fi

if test -z "$x_libraries" || test "$x_libraries" = xNONE; then
  X_LDFLAGS=""
  x_libraries="/usr/lib"; dnl better than nothing :-
  all_libraries=""
 else
  X_LDFLAGS="-L$x_libraries"
  all_libraries=$X_LDFLAGS
fi

AC_SUBST(X_INCLUDES)
AC_SUBST(X_LDFLAGS)
all_includes=$X_INCLUDES
])

dnl ------------------------------------------------------------------------
dnl Try to find the Qt headers and libraries.
dnl $(QT_LDFLAGS) will be -Lqtliblocation (if needed)
dnl and $(QT_INCLUDES) will be -Iqthdrlocation (if needed)
dnl ------------------------------------------------------------------------

AC_DEFUN(AC_PATH_QT,
[
AC_REQUIRE([MY_PATH_X])

AC_MSG_CHECKING([for Qt])
ac_qt_includes=NO
ac_qt_libraries=NO
qt_includes=""
qt_libraries=""
AC_ARG_WITH(qt-dir,
    [  --with-qt-dir           where the root of qt is installed],
    [  ac_qt_includes="$withval"/include
       ac_qt_libraries="$withval"/lib
    ])

AC_ARG_WITH(qt-includes,
    [  --with-qt-includes      where the qt includes are],
    [  
       ac_qt_includes="$withval"
    ])
    
AC_ARG_WITH(qt-libraries,
    [  --with-qt-libraries     where the qt library is installed],
    [  ac_qt_libraries="$withval"
    ])

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_qt,
[#try to guess qt locations

qt_incdirs="$ac_qt_includes /usr/lib/qt/include /usr/local/qt/include /usr/include/qt /usr/include /usr/X11R6/include/X11/qt $x_includes $QTINC"
test -n "$QTDIR" && qt_incdirs="$QTDIR/include $QTDIR $qt_incdirs"
AC_FIND_FILE(qmovie.h, $qt_incdirs, qt_incdir)
ac_qt_includes=$qt_incdir

qt_libdirs="$ac_qt_libraries /usr/lib/qt/lib /usr/local/qt/lib /usr/lib/qt /usr/lib $x_libraries $QTLIB"
test -n "$QTDIR" && qt_libdirs="$QTDIR/lib $QTDIR $qt_libdirs"
AC_FIND_FILE(libqt.so libqt.so.1.40 libqt.so.1.41 libqt.so.1 libqt.a libqt.sl, $qt_libdirs, qt_libdir)
ac_qt_libraries=$qt_libdir

dnl No compile test.

dnl ac_cxxflags_safe=$CXXFLAGS
dnl ac_ldflags_safe=$LDFLAGS
dnl ac_libs_safe=$LIBS

dnl CXXFLAGS="$CXXFLAGS -I$qt_incdir"
dnl LDFLAGS="-L$qt_libdir $X_LDFLAGS"
dnl LIBS="$LIBS -lqt -lXext -lX11 $LIBSOCKET"

dnl

dnl if AC_TRY_EVAL(ac_link) && test -s conftest; then
dnl rm -f conftest*
dnl else
dnl   echo "configure: failed program was:" >&AC_FD_CC
dnl   cat conftest.$ac_ext >&AC_FD_CC
dnl   ac_qt_libraries=NO
dnl fi
dnl rm -f conftest*
dnl CXXFLAGS=$ac_cxxflags_safe
dnl LDFLAGS=$ac_ldflags_safe
dnl LIBS=$ac_libs_safe

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then
  ac_cv_have_qt="have_qt=no"
  ac_qt_notfound=""
  if test "$ac_qt_includes" = NO; then
    if test "$ac_qt_libraries" = NO; then
      ac_qt_notfound="(headers and libraries)";
    else
      ac_qt_notfound="(headers)";
    fi
  else
    ac_qt_notfound="(libraries)";
  fi

  AC_MSG_ERROR([Qt $ac_qt_notfound not found. Please check your installation!]);
else
  have_qt=yes
fi
])
else
  have_qt=yes
fi

eval "$ac_cv_have_qt"

if test "$have_qt" != yes; then
  AC_MSG_RESULT([$have_qt]);
else
  ac_cv_have_qt="have_qt=yes \
    ac_qt_includes=$ac_qt_includes ac_qt_libraries=$ac_qt_libraries"
  AC_MSG_RESULT([libraries $ac_qt_libraries, headers $ac_qt_includes])
  
  qt_libraries=$ac_qt_libraries
  qt_includes=$ac_qt_includes
fi

AC_SUBST(qt_libraries)
AC_SUBST(qt_includes)

if test "$qt_includes" = "$x_includes" || test -z "$qt_includes"; then
 QT_INCLUDES="";
else
 QT_INCLUDES="-I$qt_includes"
 all_includes="$QT_INCLUDES $all_includes"
fi

if test "$qt_libraries" = "$x_libraries" || test -z "$qt_libraries"; then
 QT_LDFLAGS=""
else
 QT_LDFLAGS="-L$qt_libraries"
 all_libraries="$QT_LDFLAGS $all_libraries"
fi

AC_SUBST(QT_INCLUDES)
AC_SUBST(QT_LDFLAGS)
])

dnl -------------------------------------------------------------------------
dnl Find the Qt meta object compiler.
dnl -------------------------------------------------------------------------

AC_DEFUN(AC_PATH_QT_MOC,
[
AC_PATH_PROG(MOC,moc,/usr/bin/moc,
             $PATH:/usr/bin:/usr/X11R6/bin:$QTDIR/bin:/usr/lib/qt/bin:/usr/local/qt/bin)
])


