
/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "xmms.h"

void monostereo_draw(Widget * w)
{
	MonoStereo *ms = (MonoStereo *) w;
	GdkPixmap *src;
	GdkPixmap *obj;

	src = get_skin_pixmap(ms->ms_skin_index);
	obj = ms->ms_widget.parent;

	switch (ms->ms_num_channels)
	{
		case 0:
			gdk_draw_pixmap(obj, ms->ms_widget.gc, src, 29, 12, ms->ms_widget.x, ms->ms_widget.y, 27, 12);
			gdk_draw_pixmap(obj, ms->ms_widget.gc, src, 0, 12, ms->ms_widget.x + 27, ms->ms_widget.y, 29, 12);
			break;
		case 1:
			gdk_draw_pixmap(obj, ms->ms_widget.gc, src, 29, 0, ms->ms_widget.x, ms->ms_widget.y, 27, 12);
			gdk_draw_pixmap(obj, ms->ms_widget.gc, src, 0, 12, ms->ms_widget.x + 27, ms->ms_widget.y, 29, 12);
			break;
		case 2:
			gdk_draw_pixmap(obj, ms->ms_widget.gc, src, 29, 12, ms->ms_widget.x, ms->ms_widget.y, 27, 12);
			gdk_draw_pixmap(obj, ms->ms_widget.gc, src, 0, 0, ms->ms_widget.x + 27, ms->ms_widget.y, 29, 12);
			break;
	}
}

void monostereo_set_num_channels(MonoStereo * ms, gint nch)
{
	ms->ms_num_channels = nch;
	draw_widget(ms);
}

MonoStereo *create_monostereo(GList ** wlist, GdkPixmap * parent, GdkGC * gc, gint x, gint y, SkinIndex si)
{
	MonoStereo *ms;

	ms = (MonoStereo *) g_malloc0(sizeof (MonoStereo));
	ms->ms_widget.parent = parent;
	ms->ms_widget.gc = gc;
	ms->ms_widget.x = x;
	ms->ms_widget.y = y;
	ms->ms_widget.width = 56;
	ms->ms_widget.height = 12;
	ms->ms_widget.visible = 1;
	ms->ms_widget.draw = monostereo_draw;
	ms->ms_skin_index = si;

	add_widget(wlist, ms);
	return ms;
}
