#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <X11/Xatom.h>
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>
#include "xmms.h"

#define XA_WIN_LAYER				"_WIN_LAYER"
#define XA_WIN_SUPPORTING_WM_CHECK 	"_WIN_SUPPORTING_WM_CHECK"

/* flags for the window layer */
typedef enum
{
	WIN_LAYER_DESKTOP = 0,
	WIN_LAYER_BELOW = 2,
	WIN_LAYER_NORMAL = 4,
	WIN_LAYER_ONTOP = 6,
	WIN_LAYER_DOCK = 8,
	WIN_LAYER_ABOVE_DOCK = 10
}
WinLayer;

Atom _XA_WIN_SUPPORTING_WM_CHECK;
Atom _XA_WIN_LAYER;

#define WIN_HINTS_SKIP_FOCUS             (1<<0)		/* "alt-tab" skips this win */
#define WIN_HINTS_SKIP_WINLIST           (1<<1)		/* not in win list */
#define WIN_HINTS_SKIP_TASKBAR           (1<<2)		/* not on taskbar */
#define WIN_HINTS_GROUP_TRANSIENT        (1<<3)		/* ??????? */
#define WIN_HINTS_FOCUS_ON_CLICK         (1<<4)		/* app only accepts focus when clicked */
#define WIN_HINTS_DO_NOT_COVER           (1<<5)		/* attempt to not cover this window */
#define XA_WIN_HINTS                     "_WIN_HINTS"
/* WIN_HINTS = CARD32 */

Atom _XA_WIN_HINTS;

#define WIN_STATE_STICKY          (1<<0)	/* everyone knows sticky */
#define WIN_STATE_RESERVED_BIT1   (1<<1)	/* removed minimize here */
#define WIN_STATE_MAXIMIZED_VERT  (1<<2)	/* window in maximized V state */
#define WIN_STATE_MAXIMIZED_HORIZ (1<<3)	/* window in maximized H state */
#define WIN_STATE_HIDDEN          (1<<4)	/* not on taskbar but window visible */
#define WIN_STATE_SHADED          (1<<5)	/* shaded (NeXT style) */
#define WIN_STATE_HID_WORKSPACE   (1<<6)	/* not on current desktop */
#define WIN_STATE_HID_TRANSIENT   (1<<7)	/* owner of transient is hidden */
#define WIN_STATE_FIXED_POSITION  (1<<8)	/* window is fixed in position even */
#define WIN_STATE_ARRANGE_IGNORE  (1<<9)	/* ignore for auto arranging */
					 /* when scrolling about large */
					 /* virtual desktops ala fvwm */
#define XA_WIN_STATE              "_WIN_STATE"

Atom _XA_WIN_STATE;

/* The type of hints detected */
int wm_hints = WM_HINTS_NONE;

static gboolean gnome_wm_found(void);
static void gnome_wm_set_window_always(GtkWidget * window, gboolean always);
static void gnome_wm_set_always(gboolean always);
static void gnome_wm_set_window_sticky(GtkWidget * window, gboolean always);
static void gnome_wm_set_sticky(gboolean always);
static void gnome_wm_set_skip_winlist(GtkWidget *widget);

void hint_set_skip_winlist(GtkWidget *window)
{
	switch (wm_hints)
	{
	case WM_HINTS_GNOME:
		gnome_wm_set_skip_winlist(window);
		break;
	case WM_HINTS_NONE:
	default:
		break;
	}
}

void hint_set_always(gboolean always)
{
	switch (wm_hints)
	{
	case WM_HINTS_GNOME:
		gnome_wm_set_always(always);
		break;
	case WM_HINTS_NONE:
	default:
		break;
	}
}

void hint_set_sticky(gboolean sticky)
{
	switch(wm_hints)
	{
	case WM_HINTS_GNOME:
		gnome_wm_set_sticky(sticky);
	case WM_HINTS_NONE:
	default:
		break;
	}
}

static void gnome_wm_set_skip_winlist(GtkWidget *widget)
{
	long data[1];

	data[0] = WIN_HINTS_SKIP_WINLIST | WIN_HINTS_SKIP_TASKBAR;
	XChangeProperty(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(widget->window), _XA_WIN_HINTS,
			XA_CARDINAL, 32, PropModeReplace, (unsigned char *) data,
			1);
}

static void gnome_wm_set_always(gboolean always)
{
	gnome_wm_set_window_always(mainwin, always);
	gnome_wm_set_window_always(equalizerwin, always);
	gnome_wm_set_window_always(playlistwin, always);
}

static void gnome_wm_set_window_always(GtkWidget * window, gboolean always)
{
	XEvent xev;
	GdkWindowPrivate *priv;
	gint prev_error;
	int layer = WIN_LAYER_ONTOP;

	if (always == FALSE)
		layer = WIN_LAYER_NORMAL;

	prev_error = gdk_error_warnings;
	gdk_error_warnings = 0;
	priv = (GdkWindowPrivate *) (GTK_WIDGET(window)->window);

	if (GTK_WIDGET_MAPPED(window))
	{
		xev.type = ClientMessage;
		xev.xclient.type = ClientMessage;
		xev.xclient.window = priv->xwindow;
		xev.xclient.message_type = _XA_WIN_LAYER;
		xev.xclient.format = 32;
		xev.xclient.data.l[0] = (CARD32) layer;
		xev.xclient.data.l[1] = gdk_time_get();

		XSendEvent(GDK_DISPLAY(), GDK_ROOT_WINDOW(), False,
			   SubstructureNotifyMask, (XEvent *) & xev);
	}
	else
	{
		long data[1];

		data[0] = layer;
		XChangeProperty(GDK_DISPLAY(), priv->xwindow, _XA_WIN_LAYER,
		   XA_CARDINAL, 32, PropModeReplace, (unsigned char *) data,
				1);
	}
	gdk_error_warnings = prev_error;

}

static void gnome_wm_set_sticky(gboolean sticky)
{
	gnome_wm_set_window_sticky(mainwin, sticky);
	gnome_wm_set_window_sticky(equalizerwin, sticky);
	gnome_wm_set_window_sticky(playlistwin, sticky);
}

static void gnome_wm_set_window_sticky(GtkWidget * window, gboolean sticky)
{
	XEvent xev;
	gint prev_error;
	CARD32 state = 0;

	if (sticky)
		state = WIN_STATE_STICKY;

	prev_error = gdk_error_warnings;
	gdk_error_warnings = 0;

	if (GTK_WIDGET_MAPPED(window))
	{
		xev.type = ClientMessage;
		xev.xclient.type = ClientMessage;
		xev.xclient.window = GDK_WINDOW_XWINDOW(window->window);
		xev.xclient.message_type = _XA_WIN_STATE;
		xev.xclient.format = 32;
		xev.xclient.data.l[0] = WIN_STATE_STICKY;
		xev.xclient.data.l[1] = state;
		xev.xclient.data.l[2] = gdk_time_get();

		XSendEvent(GDK_DISPLAY(), GDK_ROOT_WINDOW(), False,
			   SubstructureNotifyMask, (XEvent *) & xev);
	}
	else
	{
		long data[2];

		data[0] = state;
		XChangeProperty(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(window->window), _XA_WIN_STATE,
		   XA_CARDINAL, 32, PropModeReplace, (unsigned char *) data,
				1);
	}
	gdk_error_warnings = prev_error;

}

static gboolean gnome_wm_found(void)
{
	Atom r_type;
	int r_format;
	unsigned long count;
	unsigned long bytes_remain;
	unsigned char *prop, *prop2;
	gint prev_error;

	prev_error = gdk_error_warnings;
	gdk_error_warnings = 0;

	_XA_WIN_SUPPORTING_WM_CHECK = XInternAtom(GDK_DISPLAY(), XA_WIN_SUPPORTING_WM_CHECK, False);
	_XA_WIN_LAYER = XInternAtom(GDK_DISPLAY(), XA_WIN_LAYER, False);
	_XA_WIN_HINTS = XInternAtom(GDK_DISPLAY(), XA_WIN_HINTS, False);
	_XA_WIN_STATE = XInternAtom(GDK_DISPLAY(), XA_WIN_STATE, False);
	
	if (XGetWindowProperty(GDK_DISPLAY(), GDK_ROOT_WINDOW(),
		      _XA_WIN_SUPPORTING_WM_CHECK, 0, 1, False, XA_CARDINAL,
			       &r_type, &r_format,
			   &count, &bytes_remain, &prop) == Success && prop)
	{
		if (r_type == XA_CARDINAL && r_format == 32 && count == 1)
		{
			Window n = *(long *) prop;

			if (XGetWindowProperty(GDK_DISPLAY(), n,
				   _XA_WIN_SUPPORTING_WM_CHECK, 0, 1, False,
					       XA_CARDINAL,
				  &r_type, &r_format, &count, &bytes_remain,
					       &prop2) == Success && prop)
			{
				if (r_type == XA_CARDINAL && r_format == 32 && count == 1)
				{
					XFree(prop);
					XFree(prop2);
					gdk_error_warnings = prev_error;
					return TRUE;
				}
				XFree(prop2);
			}
		}
		XFree(prop);
	}
	gdk_error_warnings = prev_error;
	return FALSE;
}

void check_wm_hints(void)
{
	/* Check for gnome wm first */
	if (gnome_wm_found())
		wm_hints = WM_HINTS_GNOME;

}









