#!/bin/sh
#\
exec wish "$0" "$@"

# Copyright (C) 1998, DGA - part of the Transcriber program
# distributed under the GNU General Public License (see COPYING file)

# For parsing simple XML files when tcLex is not installed.
# No DTD, no entities, no comments, ignore spaces around content data...

namespace eval xml {
    namespace eval dtd {
       proc active {args} { return 0 }
       proc read {name args} { name $name }
    }
}

namespace eval ::xml::parser {
   variable created

   # Parse tags and data recursively
   proc recursiveParse {textName {father {}}} {
      variable created
      upvar $textName text
      set Name {[a-zA-Z_:][a-zA-Z0-9._:-]*}
      set S "\[ \n\r\t\]"
      set Eq "$S*=$S*"
      set AttValue "(\"\[^%&\"]*\"|'\[^%&']*')"
      set Attribute "($Name)$Eq$AttValue"
      
      set listTags {}
      while {[regexp -indices "$S*<(/?)($Name)(($S+$Attribute)*)$S*(/?)>$S*" \
            $text match start type atts att1 nam1 val1 end]} {

	 set data  [string range $text 0 [expr [lindex $match 0]-1]]
	 set start [string range $text [lindex $start 0] [lindex $start 1]]
	 set type  [string range $text [lindex $type 0]  [lindex $type 1]]
	 set atts  [string range $text [lindex $atts 0]  [lindex $atts 1]]
	 set end   [string range $text [lindex $end 0]   [lindex $end 1]]
	 set tmatch [string range $text [lindex $match 0] [lindex $match 1]]
	 set text  [string range $text [expr [lindex $match 1]+1] end]

	 # Data content
	 if {$data != ""} {
	    if {[string first "<" $data] >= 0} {
	       error "Wrong tag syntax within: [string range $data 0 20]..."
	    }
	    if {$father == ""} {
	       error "Data at root level"
	    }
	    set dataId [::xml::data $data -in $father]
	    lappend created $dataId
	 }
	 # Type of tag
         if {$start == ""} {
	    set listAtts {}
	    while [regexp "$S+${Attribute}(.*)" $atts match name val atts] {
	       set val [string range $val 1 [expr [string length $val]-2]]
	       lappend listAtts $name $val
	    }
	    set elemId [::xml::element $type $listAtts -in $father]
	    lappend created $elemId
	    lappend listTags $elemId
	    # Start tag (not empty) ?
	    if {$end == ""} {
	       recursiveParse text $elemId
	    }
	 } else {
	    # End tag
	    if {$end != "" || $atts != ""} { error "bad tag $tmatch" }
	    if {$father == ""} {
	       error "Bad end tag $tmatch"
	    }
	    if {$type != [$father getType]} {
	       error "Bad end tag $tmatch: waiting for </[$father getType]>"
	    }
	    return $listTags
	 }  
      }
      if {$father != ""} {
	 error "No end tag: waiting for </[$father getType]>"
      }
      if {$text != ""} {
	 error "Non-parsed text: [string range $text 0 20]..."
      }
      return $listTags
   }

   # Parse text with house-keeping
   proc parse_doc {text args} {
      variable created {}
      if [catch {
	 set tag [recursiveParse text]
      } result] {
	 foreach item $created {
	    $item delete
	 }
	 error $result
      }
      return $tag
   }
}
