/* ************************************************************************* */
/* Platform dependent routines with define switches for differrent platforms */
/* (c) iem 1998, Winfried Ritsch                                             */
/* ************************************************************************* */
#ifndef MIDI_IO_H
#define MIDI_IO_H

#include "s_linux_mididefs.h"

typedef struct _MIDIPort {
  int devhandle;
  char *devname;
  int port_no;
  struct _MIDIPort *next;
} MIDIPort;


/* MIDI */
/* prototypes */
int midi_open(void);
void midi_close(void);

MIDIPort *midi_getfirstport(void);
MIDIPort *midi_getnextport(void);
MIDIPort *midi_getport(int pnr);

int midi_instat(MIDIPort *mp);
byte midi_in(MIDIPort *mp);

int midi_flush(MIDIPort *mp);

int midi_out(MIDIPort *mp,unsigned char b);

 /* unix dos, etc */

byte key_in( void);
int key_instat( void);
#define key_flush()    {while(key_instat()>0)key_in();}
#define screen_clear() {}

#endif /*MIDI_IO_H*/
