/*
 * draw.c source file for extace
 * 
 /GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1998 by Michael Fullbright
 * Re-hacked to look good by The Rasterman
 * 
 * Hacked some more by Dave J. Andruczyk <dave@techdev.buffalostate.edu>
 * to be fully scalable with lots of new options, for tilting the axis's
 * and various other cool stuff.
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You may use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <time.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>


// See globals.h for variable declarations and DEFINES

void draw(void)
{
    gint i,j,k;
    gint left_val;
    gint right_val;
    gint prev_left_val;
    gint prev_right_val;
    gint prev_old_left_val;
    gint prev_old_right_val;
    gint old_left_val;
    gint old_right_val;
    gfloat spikes_per_pip;
    gint start_x, end_x;
    gint x_travel;
    static gdouble plevels[MAXBANDS];
    static gint lin_x_axis[MAXBANDS];
    static gint log_x_axis[MAXBANDS];
    gdouble val;
    gint sum;
    gint count;
    GdkPoint pt[4];
    GdkColor cl;
    gint br,lvl;
    gint lwidth = width/bands;

    if (!GetFFT()) return;

    if (!win) return;

    // Next set of routines ONLY ONLY needs to be done for 3D Landform
    // and 2D EQ. Scope, spikes, and spectragram don't need these, so
    // why waste the cpu time..

    for (i=1; i<nsamp/2; i++)
    {				// sensitivity scaler (arbritrary)
	disp_val[i-1] = (norm_fft[i]/20)*(double)sensitivity;
    }
    disp_val[(nsamp/2)-1]=0;

    if ((mode == LAND_3D) || (mode == EQ_2D))
    {
	/* Gives a "log-like" x axis (for 2D (EQ like analyzer))
	 * hacking to make it work better with the various displays
	 * the bin[i] deteremines how much data is summed together for the 
	 * display since the display can't fit a 1024 point fft nicely.
	 */ 
	for(i=0;i<bands;i++)
	{
	    /* Linear x axis */
	    lin_x_axis[i]=(nsamp/2)/bands; 
	}
	if (scalefixed == 0)
	{
	    scalefactor = 10.0;

	    count = 0;
recalc:
	    count++;
	    scale = bands/scalefactor;
	    sum = 0;
	    for (i=0; i < bands ; i++)
	    {
		log_x_axis[i] = exp((i/scale));
		sum = sum + log_x_axis[i];
	    }
	    /* reduction algorithm, to get scalefactor so that ALL datapoints
	     *in the FFT get onto the display */
	    if (sum > nsamp/2)
	    {
		if (sum > (2.0*(nsamp/2)))
		    scalefactor = scalefactor - .80;
		if (sum > (1.25*(nsamp/2)))
		    scalefactor = scalefactor - .150;
		if (sum > (1.15*(nsamp/2)))
		    scalefactor = scalefactor - .025;
		if (sum > (1.05*(nsamp/2)))
		    scalefactor = scalefactor - .009;
		if (sum < (1.05*(nsamp/2)))
		    scalefactor = scalefactor - .001;
		goto recalc;
	    }
#ifdef SCALEDEBUG
	    g_print("It took %i iterations to get the scalefactor\n",count);
	    g_print("Number of points in display is %i\n",sum);
#endif
	}
	scalefixed = 1;



	/*
	 * this function groups together the data from the FFT so that it can
	 * fit into the smaller division displayed on screen, since a 1024 point
	 * fft doesn't fit wwell into 32 or 64 divisions.  the lin/log_x_axis
	 * arrays determine how the fft data is broken up for a linear or log 
	 * based frequency axis
	 */

	j=0;
	k=0;
	bands_per_block = floor((nsamp/2)/bands);
	for(i=0;i<bands;i++)
	{
	    val=0;
	    /* sum it then average it so the scaling doesn't go haywire */
	    switch (axis_type)
	    {
		case (LOG):
		    for(j=0;j<(log_x_axis[i]);j++)
			val+=disp_val[k++];
		    val/=(double)log_x_axis[i];
		    break;
		case (LINEAR):
		    for(j=0;j<bands_per_block;j++)
			val+=disp_val[k++];
		    val/=(double)bands_per_block;
		    break;
	    }

	    if (slide)
	    {
		if (val<=(levels[i]-4))
		{
		    levels[i]-=decay_val;
		    if (levels[i]<0)
			levels[i]=0;
		}
		else 
		    levels[i]=val;
	    }
	    else
		levels[i]=val;
	}

    }
    switch (mode)
    {
	case LAND_3D:
	    gdk_window_copy_area(win,gc,0,0,win,x3d_scroll,z3d_scroll,width-x3d_scroll,height-z3d_scroll);
	    gdk_draw_rectangle( win,
				disp->style->black_gc,
				TRUE, width-x3d_scroll,0,
				x3d_scroll,height);
	    gdk_draw_rectangle( win,
				disp->style->black_gc,
				TRUE, 0,height-z3d_scroll,
				width,z3d_scroll);
	    /*
	     * pixel shift for scalability

	     * need to recalculate these, for borders so we don't get "black
	     * spots" on the display from running offscreen
	     * x_draw_width = width - "some magic amount"

	     * Smoothing routine.  Adjusts border slightly to avoid 2 pixel
	     * breakups in the display... (woohoo, it actually works!!)

	     * pix_per_block = floating point!!!
	     */


	    x_draw_width = width - abs(x3d_scroll)-2*x_border;
	    y_draw_height = height - abs(z3d_scroll)-2*y_border;

	    x_shift = ((x_draw_width*(1-x3d_start))-(x_draw_width*(1-x3d_end)));
	    x_shift_per_block = x_shift/bands;

	    x_offset = (width-x_draw_width)/2;
	    y_offset = (height-y_draw_height)/2;
	    if(x3d_start < x3d_end)
		x_fudge = 1;
	    else x_fudge = -1;

	    y_shift_per_block = z3d_scroll/2;

	    for( i=0; i < bands; i++) 
	    {   
		pt[0].x=width-((i*x_draw_width)*(1-x3d_start))/(bands)-(((bands-i)*x_draw_width)*(1-x3d_end))/(bands)-(x3d_scroll/2)-x_offset+x_fudge-(x3d_scroll%2);
		pt[0].y=height-(((i)*y_draw_height*y3d_start)/(bands))-(((bands-i)*y_draw_height*y3d_end)/(bands))-(gint)plevels[i]-(2*y_shift_per_block)-y_offset-(z3d_scroll%2);
		pt[1].x=width-((i*x_draw_width)*(1-x3d_start))/(bands)-(((bands-i)*x_draw_width)*(1-x3d_end))/(bands)+(x3d_scroll/2)-x_offset+x_fudge;
		pt[1].y=height-(((i)*y_draw_height*y3d_start)/(bands))-(((bands-i)*y_draw_height*y3d_end)/(bands))-(gint)levels[i]-y_offset; 
		pt[2].x=width-((i*x_draw_width)*(1-x3d_start))/(bands)-(((bands-i)*x_draw_width)*(1-x3d_end))/(bands)-(x_shift_per_block)+(x3d_scroll/2)-x_offset;
		if(i == (bands-1))
		    pt[2].y=height-(((i+1)*y_draw_height*y3d_start)/(bands))-(((bands-i-1)*y_draw_height*y3d_end)/(bands))-y_offset;
		else
		    pt[2].y=height-(((i+1)*y_draw_height*y3d_start)/(bands))-(((bands-i-1)*y_draw_height*y3d_end)/(bands))-(gint)levels[i+1]-y_offset; 
		pt[3].x=width-((i*x_draw_width)*(1-x3d_start))/(bands)-(((bands-i)*x_draw_width)*(1-x3d_end))/(bands)-(x_shift_per_block)-(x3d_scroll/2)-x_offset-(x3d_scroll%2);
		if(i == (bands-1))
		    pt[3].y=height-(((i+1)*y_draw_height*y3d_start)/(bands))-(((bands-i-1)*y_draw_height*y3d_end)/(bands))-(2*y_shift_per_block)-y_offset-(z3d_scroll%2);
		else
		    pt[3].y=height-(((i+1)*y_draw_height*y3d_start)/(bands))-(((bands-i-1)*y_draw_height*y3d_end)/(bands))-(gint)plevels[i+1]-(2*y_shift_per_block)-y_offset-(z3d_scroll%2);

		lvl=(gint)levels[i]; 
		if (lvl > (MAXBANDS-1)) lvl=MAXBANDS-1;
		br=16+(gint)(levels[i]-plevels[i+1]);

		if (br<0) br=0;
		else if (br > (MAXBANDS-1)) br= (MAXBANDS-1);
		cl.pixel=colortab[br][lvl];
		gdk_gc_set_foreground(gc,&cl);

		switch (sub_mode)
		{
		    case FILL_3D:

			gdk_draw_polygon(win,gc,TRUE,pt,4);
			gdk_draw_line(win,disp->style->black_gc,
				      pt[0].x,pt[0].y,pt[1].x,pt[1].y);
			gdk_draw_line(win,disp->style->black_gc,
				      pt[0].x,pt[0].y,pt[3].x,pt[3].y);
			break;
		    case WIRE_3D:
			gdk_draw_polygon(win,disp->style->black_gc,TRUE,pt,4);
			gdk_draw_line(win,gc,
				      pt[0].x,pt[0].y,pt[1].x,pt[1].y);
			gdk_draw_line(win,gc,
				      pt[0].x,pt[0].y,pt[3].x,pt[3].y);
			break;
		}

		if(show_leader)
		{
		    pt[0].x=pt[1].x; 
		    pt[0].y=pt[1].y+(gint)levels[i];
		    pt[1].x=pt[0].x;
		    pt[1].y=pt[1].y;
		    pt[2].x=pt[2].x;
		    pt[2].y=pt[2].y;
		    pt[3].x=pt[2].x;
		    if(i == (bands - 1))
			pt[3].y=pt[2].y;
		    else
			pt[3].y=pt[2].y+levels[i+1];

		    switch (sub_mode)
		    {
			case FILL_3D:

			    gdk_draw_polygon(win,gc,TRUE,pt,4);
			    gdk_draw_line(win,disp->style->black_gc,
					  pt[2].x,pt[2].y,pt[1].x,pt[1].y);
			    break;
			case WIRE_3D:
			    gdk_draw_polygon(win,gc,TRUE,pt,4);
			    break;
		    }

		}
	    }
	    break;
	case EQ_2D:
	    maxlevel = prevlevel = 0;

	    for (i=0;i < bands; i++)
	    {
		if (plevels[i] > prevlevel)
		    prevlevel = (gint)plevels[i];
		if (levels[i] > maxlevel)
		    maxlevel = (gint)levels[i];
	    }
	    if (prevlevel > maxlevel)
		maxlevel = prevlevel;

	    maxlevel = ((maxlevel*height)/128);

	    gdk_draw_rectangle( pixmap,
				disp->style->black_gc,
				TRUE, 0,height-maxlevel,
				width,maxlevel);

	    for( i=0; i < bands; i++ ) 
	    {   
		lvl=(gint)levels[i]/2;
		if (lvl>63) 
		    lvl=63;

		cl.pixel=colortab[32][i];
		gdk_gc_set_foreground(gc,&cl);
		bar_start = height - (((gint)levels[i]*height)/128);
		gdk_draw_rectangle( pixmap,gc,
				    TRUE, 
				    (i*lwidth)+1,bar_start,
				    lwidth-2,(((gint)levels[i]*height)/128));
	    }
	    for(i=0;i<maxlevel;i+=seg_height)
	    {
		gdk_draw_rectangle( pixmap,disp->style->black_gc,
				    TRUE, 
				    0,height-i,
				    width,seg_space);
	    }

	    gdk_window_clear_area(win,0,height-maxlevel,width,maxlevel);
	    break;
	case SCOPE:
	    lo_width = (512 < width) ? 512 : width;
	    if (scope_sub_mode == GRAD_SCOPE)
	    {
		top = (height/3 - 128);
		if (top < 0)
		    top = 0;
		bottom = (height-(height/3))+127;
		if (bottom > height);
		bottom = height;

		gdk_draw_rectangle( pixmap,
				    disp->style->black_gc,
				    TRUE, 0,top,
				    lo_width,bottom);
	    }
	    prev_right_val = 0;
	    prev_old_right_val = 0;

	    prev_left_val = 0;
	    prev_old_left_val = 0;

	    for(i=0;i<lo_width*2;i+=2) 
	    {
		old_left_val=(gint)(audio_last_l[i]*left_amplitude);
		left_val=(gint)(audio_left[i]*left_amplitude);

		old_right_val=(gint)(audio_last_r[i]*right_amplitude);
		right_val=(gint)(audio_right[i]*right_amplitude);

		if (i >= 2)
		{
		    prev_old_left_val=(gint)(audio_last_l[i-2]*left_amplitude);
		    prev_left_val=(gint)(audio_left[i-2]*left_amplitude);

		    prev_old_right_val=(gint)(audio_last_r[i-2]*right_amplitude);
		    prev_right_val=(gint)(audio_right[i-2]*right_amplitude);
		}
		if (left_val < -127) 
		{
		    left_val = -127; 
		    old_left_val = -127;
		}
		if (prev_left_val < -127)
		{
		    prev_left_val = -127; 
		    prev_old_left_val = -127;
		}
		else if (left_val > 127)
		{
		    left_val = 127; 
		    old_left_val = 127;
		}
		else if (prev_left_val > 127) 
		{
		    prev_left_val = 127;
		    prev_old_left_val = 127;
		}

		if (right_val < -127)
		{
		    right_val = -127;
		    old_right_val = -127;
		}
		if (prev_right_val < -127)
		{
		    prev_right_val = -127;
		    prev_old_right_val = -127;
		}
		else if (right_val > 127)
		{
		    right_val = 127;
		    old_right_val = 127;
		}
		else if (prev_right_val > 127)
		{
		    prev_right_val = 127;
		    prev_old_right_val = 127;
		}

		if (left_val <= 0)
		{
		    switch (scope_sub_mode)
		    {
			case DOT_SCOPE:
			    gdk_draw_point(win,disp->style->black_gc,i/2,((height/3))+old_left_val);
			    gdk_draw_point(win,disp->style->white_gc,i/2,((height/3))+left_val);
			    break;

			case LINE_SCOPE:
			    gdk_draw_line(win,disp->style->black_gc,i/2-1,((height/3))+prev_old_left_val,i/2,((height/3))+old_left_val);
			    gdk_draw_line(win,disp->style->white_gc,i/2-1,((height/3))+prev_left_val,i/2,((height/3))+left_val);
			    break;
			case GRAD_SCOPE:
			    if (left_val == 0)
				left_val++;
			    gdk_draw_pixmap(pixmap,gc,grad[left_val+127],0,0,
					    i/2,((height/3))+left_val,1,-left_val);
			    break;
		    }
		}
		else if (left_val > 0)
		{
		    switch (scope_sub_mode)
		    {
			case DOT_SCOPE:
			    gdk_draw_point(win,disp->style->black_gc,i/2,(height/3)+old_left_val);
			    gdk_draw_point(win,disp->style->white_gc,i/2,(height/3)+left_val);
			    break;
			case LINE_SCOPE:
			    gdk_draw_line(win,disp->style->black_gc,i/2-1,((height/3))+prev_old_left_val,i/2,((height/3))+old_left_val);
			    gdk_draw_line(win,disp->style->white_gc,i/2-1,((height/3))+prev_left_val,i/2,((height/3))+left_val);
			    break;

			case GRAD_SCOPE:
			    gdk_draw_pixmap(pixmap,gc,grad[left_val+127],0,0,
					    i/2,height/3,1,left_val);
			    break;
		    }
		}
		if (right_val <= 0)
		{
		    switch (scope_sub_mode)
		    {
			case DOT_SCOPE:
			    gdk_draw_point(win,disp->style->black_gc,i/2,(height-(height/3))+old_right_val);
			    gdk_draw_point(win,disp->style->white_gc,i/2,(height-(height/3))+right_val);
			    break;

			case LINE_SCOPE:
			    gdk_draw_line(win,disp->style->black_gc,i/2-1,(height-(height/3))+prev_old_right_val,i/2,(height-(height/3))+old_right_val);
			    gdk_draw_line(win,disp->style->white_gc,i/2-1,(height-(height/3))+prev_right_val,i/2,(height-(height/3))+right_val);
			    break;
			case GRAD_SCOPE:
			    if (right_val == 0)
				right_val++;
			    gdk_draw_pixmap(pixmap,gc,grad[right_val+127],0,0,
					    i/2,(height-(height/3))+right_val,1,-right_val);
			    break;
		    }
		}
		else if (right_val > 0)
		{
		    switch (scope_sub_mode)
		    {
			case DOT_SCOPE:
			    gdk_draw_point(win,disp->style->black_gc,i/2,(height-(height/3))+old_right_val);
			    gdk_draw_point(win,disp->style->white_gc,i/2,(height-(height/3))+right_val);
			    break;
			case LINE_SCOPE:
			    gdk_draw_line(win,disp->style->black_gc,i/2-1,(height-(height/3))+prev_old_right_val,i/2,(height-(height/3))+old_right_val);
			    gdk_draw_line(win,disp->style->white_gc,i/2-1,(height-(height/3))+prev_right_val,i/2,(height-(height/3))+right_val);
			    break;

			case GRAD_SCOPE:
			    gdk_draw_pixmap(pixmap,gc,grad[right_val+127],0,0,
					    i/2,(height-(height/3)),1,right_val);
			    break;
		    }
		}


	    }
	    for (i=0;i<nsamp;i++)
	    {
		audio_last_l[i] =  audio_left[i];	// copy the arrays
		audio_last_r[i] =  audio_right[i];	// copy the arrays
	    }
	    if (scope_sub_mode == GRAD_SCOPE)
		gdk_window_clear_area(win,0,top,lo_width,bottom);
	    break;
	case SPIKE_3D:
	    /* "det" == detailed */
	    gdk_window_copy_area(win,gc,0,0,win,xdet_scroll,zdet_scroll,width-xdet_scroll,height-zdet_scroll);
	    gdk_draw_rectangle( win,
				disp->style->black_gc,
				TRUE, width-xdet_scroll,0,
				xdet_scroll,height);
	    gdk_draw_rectangle( win,
				disp->style->black_gc,
				TRUE, 0,height-zdet_scroll,
				width,zdet_scroll);

	    /* in pixels */
	    x_draw_width = width - abs(xdet_scroll)-2*x_border;
	    y_draw_height = height - abs(zdet_scroll)-2*y_border;

	    /* in pixels */
	    x_offset = (width-x_draw_width)/2;
	    y_offset = (height-y_draw_height)/2;

	    /* in pixels */
	    start_x = width-((((nsamp/2)*x_draw_width)*(1-xdet_end))/(nsamp/2))-x_offset;
	    end_x = width-((((nsamp/2)*x_draw_width)*(1-xdet_start))/(nsamp/2))-x_offset;
	    /* end_x - start_x is X screen space in pixels 
	     * the idea is to reduce the number of gdk_draw_lines to 
	     * the number in x_travel, instead of nsamp/2. which saves drawing
	     * over the same location on the screen and wasting time.
	     * I guess when combining pips together we should AVG them. What
	     * other way might be better? (suggestions welcome...)
	     */

	    /* disp_val[] is a malloc'd array storing pip values for ALL pips, 
	     * (1/2 NSAMP). pip_arr[] is malloc'd array that is length 
	     * "spikes_per_pip"and contains anti-aliased reduction of 
	     * disp[val] using linear interpolation to combine/average 
	     * multiple pip values into one viewable spike. Should be 
	     * fully scaling with best results of having spikes_per pip 
	     * being a multiple of nsamp/2.
	     */
	    spikes_per_pip = ((float)nsamp/2.0)/(fabs(end_x-start_x));
	    x_travel = abs(end_x-start_x);

	    reducer(spikes_per_pip, x_travel);

	    for( i=0; i < x_travel; i++ )
	    {
		pt[0].x=width-(((i*x_draw_width)*(1-xdet_start))/(x_travel))-((((x_travel-i)*x_draw_width)*(1-xdet_end))/(x_travel))-x_offset; 
		pt[0].y=height-(((i*spikes_per_pip)*y_draw_height*ydet_start)/(nsamp/2))-((((nsamp/2)-(i*spikes_per_pip))*y_draw_height*ydet_end)/(nsamp/2))-y_offset;
		pt[1].x=width-(((i*x_draw_width)*(1-xdet_start))/(x_travel))-((((x_travel-i)*x_draw_width)*(1-xdet_end))/(x_travel))-x_offset;
		pt[1].y=height-(((i*spikes_per_pip)*y_draw_height*ydet_start)/(nsamp/2))-((((nsamp/2)-(i*spikes_per_pip))*y_draw_height*ydet_end)/(nsamp/2))-(gint)pip_arr[i]-y_offset; 
		lvl=(gint)pip_arr[i]*2;
		if (lvl > (MAXBANDS-1))
		    lvl=(MAXBANDS-1);

		cl.pixel=colortab[16][lvl];
		gdk_gc_set_foreground(gc,&cl);
		gdk_draw_line(win,gc,pt[0].x,pt[0].y,pt[1].x,pt[1].y);
	    }
	    break;
	case SPECGRAM:
	    if (display_markers)
	    {
		update_markers();
		update_time_markers();
		display_markers = 0;
	    }
	    if(spec_drag)
	    {
		break;
	    }
	    gdk_window_copy_area(win,gc,0,0,win,
				 tape_scroll,0,spec_start*width,height-time_border);
	    spikes_per_pip = ((float)nsamp/2.0)/(fabs(height-time_border));

	    reducer(spikes_per_pip, (height - time_border));

	    for (i=0; i < (height - time_border); i++)
	    {
		lvl=(gint)pip_arr[i]*2;
		if (lvl > (MAXBANDS-1))
		    lvl=(MAXBANDS-1);
		cl.pixel=colortab[16][lvl];
		gdk_gc_set_foreground(gc,&cl);

		gdk_draw_line(win,gc, (spec_start*width)-tape_scroll, height-time_border-i,spec_start*width,height-time_border-i);
	    }

	    break;

	default:
	    break;
    }
    // shift current levels into the previous levels array,
    for( i=0; i < bands; i++ ) 
	plevels[i]=levels[i];

}

