/*  spacescope.c
 *  Copyright (C) 1998 Andy Lo A Foe <arloafoe@cs.vu.nl>
 *  Original code by Tinic Uro
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 
#include <dirent.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <sys/time.h>
#include <time.h>   
#include <math.h>
#include <stdio.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <assert.h>
#include <pthread.h>
#include "scope_config.h"

#define SPACE_WH	128	// Leave this at 128 for now

static char actEq[257];
static char oldEq[257];       

static char scX[256];
static char scY[256];     

static GdkImage *image = NULL;
static GtkWidget *scope_win = NULL;
static pthread_t spacescope_thread;
static pthread_mutex_t spacescope_mutex;
static gint is_init = 0;
static gint running = 0;


static void spacescope_hide();


void spacescope_set_data(void *audio_buffer, int size)
{
	int i;
	short *sound = (short *)audio_buffer;
	
	if (!sound) {
			memset(&actEq, 0, sizeof(actEq));
			return;
	}		
	if (running && sound) {
		char *newset = actEq;
        	int bufsize = size / (size >= 512 ? 512 : size);
		for (i=0; i < 256; i++) {
			*newset++=(char)(((int)(*sound)+(int)(*(sound+1)))>>10);
			sound += bufsize;
		}
	}
}

#define SPACESCOPE_DOLOOP() \
while (running) { \
	int w;\
	for (w=0; w < SPACE_WH * SPACE_WH; w++) { \
		bits[w] = bg_color.pixel; \
	} \
	memcpy(oldset,newset,256); \
\
	for (i=0; i < 256; i++) { \
		tmp = cols[foo=(oldset[i]+64)>>1]; \
		bar = ((( scX[i]*foo)>>7 )+(64)) + \
			((((scY[i]*foo) ) + (64 * SPACE_WH)) & 0xffffff80); \
\
		if ((bar > 0) && (bar < (SPACE_WH * SPACE_WH))) { \
			loc = bits + bar; \
			*loc++ = tmp; \
			*loc = tmp; \
			loc += 127; \
			*loc++ = tmp; \
			*loc = tmp; \
		} \
	} \
	gdk_threads_enter(); \
	gdk_draw_image(win->window,gc,image,0,0,0,0,-1,-1); \
	gdk_flush(); \
	gdk_threads_leave(); \
	dosleep(SCOPE_SLEEP); \
}


void spacescope32(GtkWidget *win)
{
        int *loc;
        int tmp, foo;
        char *oldset = oldEq;
        char *newset = actEq;
        int *bits;
        int bar;  
	int colEq[65];
	int i;
	GdkColormap *c;
	GdkVisual *v;
	GdkGC *gc;
	GdkColor bg_color;
	int *cols = colEq;

	gdk_threads_enter();
	c = gtk_widget_get_colormap(win);
	gc = gdk_gc_new(win->window);
	v = gtk_widget_get_visual(win);
	

	for (i = 0; i < 32; i++) {
		GdkColor color;
		color.red = (i*8) << 8;
		color.green = 255 << 8;
		color.blue = 0;
	        gdk_color_alloc(c, &color);
		colEq[i] = color.pixel; 
		color.red = 255 << 8;
		color.green = ((31 - i) * 8) << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEq[i + 32] = color.pixel;
  	}

	// Create render image
	if (image) {
		gdk_image_destroy(image);	
		image = NULL;
	}
	image = gdk_image_new(GDK_IMAGE_FASTEST, v, SPACE_WH, SPACE_WH);
        bg_color.red = SCOPE_BG_RED << 8;
        bg_color.blue = SCOPE_BG_BLUE << 8;
        bg_color.green = SCOPE_BG_GREEN << 8;
	gdk_color_alloc(c, &bg_color);
	gdk_threads_leave();       

	assert(image);
	assert(image->bpp == 4);
	
	bits = (int *)image->mem;	
	
	running = 1;
	
	SPACESCOPE_DOLOOP();
	
	gdk_threads_enter();
	gdk_gc_destroy(gc);
	spacescope_hide();
	gdk_threads_leave();
	
}


void spacescope16(GtkWidget *win)
{
	short *loc;
	short tmp, foo;
	char *oldset = oldEq;
	char *newset = actEq;
	short *bits;
	int bar;  
	short colEq[65];
	int i;
	GdkColormap *c;
	GdkVisual *v;
	GdkGC *gc;
	GdkColor bg_color;
	short *cols = colEq;

	gdk_threads_enter();
	c = gtk_widget_get_colormap(win);
	gc = gdk_gc_new(win->window);
	v = gtk_widget_get_visual(win);


	for (i = 0; i < 32; i++) {
		GdkColor color;
		color.red = (i*8) << 8;
		color.green = 255 << 8;
		color.blue = 0;
	        gdk_color_alloc(c, &color);
		colEq[i] = color.pixel; 
		color.red = 255 << 8;
		color.green = ((31 - i) * 8) << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEq[i + 32] = color.pixel;
  	}

	// Create render image
	if (image) {
		gdk_image_destroy(image);
		image = NULL;
	}
	image = gdk_image_new(GDK_IMAGE_FASTEST, v, SPACE_WH, SPACE_WH);
        bg_color.red = SCOPE_BG_RED << 8;
        bg_color.blue = SCOPE_BG_BLUE << 8;
        bg_color.green = SCOPE_BG_GREEN << 8;
	gdk_color_alloc(c, &bg_color);
	gdk_threads_leave();      
 
	assert(image);
	assert(image->bpp == 2);
	
	bits = (short *)image->mem;	

	running = 1;

	SPACESCOPE_DOLOOP();

	gdk_threads_enter();
	gdk_gc_destroy(gc);
	spacescope_hide();
	gdk_threads_leave();
}


void spacescope8(GtkWidget *win)
{
        guint8 *loc;
        gint tmp, foo;
        char *oldset = oldEq;
        char *newset = actEq;
        guint8 *bits;
        int bar;  
	guint8 colEq[65];
	int i;
	GdkColormap *c;
	GdkVisual *v;
	GdkGC *gc;
	GdkColor bg_color;
	guint8 *cols = colEq;

	gdk_threads_enter();
	c = gtk_widget_get_colormap(win);
	gc = gdk_gc_new(win->window);
	v = gtk_widget_get_visual(win);


	for (i = 0; i < 32; i++) {
		GdkColor color;
		color.red = (i*8) << 8;
		color.green = 255 << 8;
		color.blue = 0;
	        gdk_color_alloc(c, &color);
		colEq[i] = color.pixel; 
		color.red = 255 << 8;
		color.green = ((31 - i) * 8) << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEq[i + 32] = color.pixel;
  	}

	// Create render image
	if (image) {
		gdk_image_destroy(image);
		image = NULL;
	}
	image = gdk_image_new(GDK_IMAGE_FASTEST, v, SPACE_WH, SPACE_WH);
	bg_color.red = SCOPE_BG_RED << 8;
        bg_color.blue = SCOPE_BG_BLUE << 8;
        bg_color.green = SCOPE_BG_GREEN << 8;
	gdk_color_alloc(c, &bg_color);
	gdk_threads_leave();      
 
	assert(image);
	assert(image->bpp == 1);
	
	bits = (guint8 *)image->mem;	

	running = 1;
	
	SPACESCOPE_DOLOOP();

	gdk_threads_enter();
	gdk_gc_destroy(gc);
	spacescope_hide();
	gdk_threads_leave();

}


void stop_spacescope();

static gboolean close_spacescope_window(GtkWidget *widget, GdkEvent *event, gpointer data)
{
        stop_spacescope();

		return TRUE;
}



GtkWidget *init_spacescope_window()
{
	int i;
	
	GtkWidget *spacescope_win;
	GtkStyle *style;
	GdkVisual *visual;
	GdkWindow *win;	
	GdkColor *color;

	pthread_mutex_init(&spacescope_mutex, NULL);

	style = gtk_style_new();

	spacescope_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(spacescope_win), "Spacescope");
	gtk_widget_set_usize(spacescope_win, SPACE_WH, SPACE_WH);	
	gtk_window_set_wmclass (GTK_WINDOW(spacescope_win), "Spacescope", "AlsaPlayer");
        gtk_window_set_policy (GTK_WINDOW (spacescope_win), FALSE, FALSE, TRUE);  

	// Set bg color, why does this sucks so much!!!?
	style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(spacescope_win)));
        color = &style->bg[GTK_STATE_NORMAL];
        color->red = SCOPE_BG_RED << 8;
	color->blue = SCOPE_BG_BLUE << 8;
	color->green = SCOPE_BG_GREEN << 8;
        gdk_color_alloc(gtk_widget_get_colormap(GTK_WIDGET(spacescope_win)), color);
        gtk_widget_set_style(GTK_WIDGET(spacescope_win), style);

	gtk_widget_show(spacescope_win);

	win = spacescope_win->window;

	visual = gdk_window_get_visual(win);


	// Signals

	gtk_signal_connect(GTK_OBJECT(spacescope_win), "delete_event",
                GTK_SIGNAL_FUNC(close_spacescope_window), spacescope_win);

	
	// Clear and show the window
	
	gdk_window_clear(win);
	gdk_window_show(win);
	
	gdk_flush(); 
        
	// Create sin/cos tables
	
	for (i = 0; i < 256; i++) {
                scX[i] = (char) (sin(((2*M_PI)/255)*i)*128);
                scY[i] = (char) (-cos(((2*M_PI)/255)*i)*128);
        } 

	return spacescope_win;
}  

void spacescope_hide()
{
	gint x, y;
	 
	if (scope_win) {
		gdk_window_get_root_origin(scope_win->window, &x, &y);	
		gtk_widget_hide(scope_win);
		gtk_widget_set_uposition(scope_win, x, y);	
	}
}

void stop_spacescope()
{
	running = 0;
}

void run_spacescope(void *data)
{
	GdkVisual *visual;
	
	nice(SCOPE_NICE);

	gdk_threads_enter();
	visual = gtk_widget_get_visual(scope_win);
	gdk_threads_leave();

	switch (visual->depth) {
		case 8:
			spacescope8(scope_win);
			break;
		case 16:
			spacescope16(scope_win);
			break;
		case 24:	
		case 32:
			spacescope32(scope_win);
			break;
	}
	//delete sub;
	pthread_mutex_unlock(&spacescope_mutex);
	return;
}


void start_spacescope(void *data)
{
	if (!is_init) {
		is_init = 1;
		scope_win = init_spacescope_window();
	}
	if (pthread_mutex_trylock(&spacescope_mutex) != 0) {
		printf("spacescope already running\n");
		return;
	}		 
	gtk_widget_show(scope_win);
	pthread_create(&spacescope_thread, NULL, (void * (*)(void *))run_spacescope, data);
	pthread_detach(spacescope_thread);
}

static int open_spacescope()
{
	return 1;
}

static int init_spacescope()
{
	return 1;
}

static void close_spacescope()
{
}


static int spacescope_running()
{
	return running;
}


scope_plugin spacescope_plugin = {
	SCOPE_PLUGIN_VERSION,
	{ "Spacescope" },
	{ "Andy Lo A Foe"},
	init_spacescope,
	open_spacescope,
	start_spacescope,
	spacescope_running,
	stop_spacescope,
	close_spacescope,
	spacescope_set_data
};


scope_plugin *scope_plugin_info()
{
	return &spacescope_plugin;
}		
