#
#  $Id: DiddleBug.py,v 1.2 1999/12/11 12:35:11 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""DiddleBug
"""

__version__ = '$Id: DiddleBug.py,v 1.2 1999/12/11 12:35:11 rob Exp $'

__copyright__ = 'Copyright 1998-1999 Rob Tillotson <robt@debian.org>'

import Pyrite
import Pyrite.Connector
from Pyrite import FLD_STRING, FLD_BOOLEAN, _
import struct, string
from Pyrite import Blocks

# pil
try:
    import Image
except ImportError:
    Image = None

class Connector(Pyrite.Connector.Connector):
    name = 'DiddleBug'
    version = Pyrite.version
    author = Pyrite.author
    url = ''
    description = _("DiddleBug by Mitch Blevins <mblevin@debian.org>.")

    def __init__(self, *a, **kw):
	apply(Pyrite.Connector.Connector.__init__, (self,)+a, kw)
	self.default_name = 'DiddleBugDB'
	self.default_class = Database
	self.default_creator = 'DIDB'
	self.default_type = 'Data'
	
    def classify(self, info={}):
	if info.get('type') == 'Data' and info.get('creator') == 'DIDB':
	    return Database
	
class Record(Blocks.Record):
    def __init__(self, *a, **kw):
	self.fields = {'sketch':       (FLD_STRING, ' '*3200),
		       'is_alarm_set': (FLD_BOOLEAN, 0),
		       'is_countdown': (FLD_BOOLEAN, 0),
		       'alarm_secs':   (FLD_INT, 0),
		       'repeat_mode':  (FLD_INT, 0),
		       'repeat_secs':  (FLD_INT, 0),
		       'is_locked':    (FLD_BOOLEAN, 0)
		       }
	apply(Blocks.Record.__init__, (self,)+a, kw)

    def unpack(self, raw):
	self.raw = raw
	self.unpackfields('>3200sBBLhLB', ['sketch','is_alarm_set',
					   'is_countdown', 'alarm_secs',
					   'repeat_mode', 'repeat_secs',
					   'is_locked'], raw[:3213])

    def pack(self):
	self.raw = self.packfields('>3200sBBLhLB', ['sketch', 'is_alarm_set',
						    'is_countdown', 'alarm_secs',
						    'repeat_mode', 'repeat_secs',
						    'is_locked'])
	self.raw = (self.raw + ('\0'*5))[:3218]
	return self.raw

    def to_image(self):
	if Image is None: raise RuntimeError, _("the Python Imaging Library is not available")
	return Image.fromstring("1",(160,160),self['sketch'],"raw","1;I")

class Database(Pyrite.Database):
    def __init__(self, *a, **kw):
	apply(Pyrite.Database.__init__, (self,)+a, kw)
	self.record_class = Record
	self.appblock_class = AppBlock


