/* cache Directory entries for faster access */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "preferences.h"
#include "dirlow.h"
#include "dircache.h"

dircache_cacheentry *dircache_entry[DIRCACHE_MAXDIRS];
int dircache_entries=0;

dircache_cacheentry *dircache_getentry(char *name)
{
	int x;
	dircache_cacheentry *e;

	e=NULL;
	for (x=0;x<dircache_entries;x++)
	  {
		  if (!strcmp((char*)&dircache_entry[x]->name,name))
		    {
			    e=dircache_entry[x];
		    }
		  ;
	  }
	;
	return e;
}
;

dircache_cacheentry *dircache_createentry(char *name)
{
	int entrynum;

	if (dircache_entries>=DIRCACHE_MAXDIRS)
	  {		  
		  entrynum=0;                // overwrite first entry
		  free(dircache_entry[entrynum]);
	  }
	else
	  {
		  entrynum=dircache_entries; // default to the next free entry
		  dircache_entries++;
	  }
	;
	dircache_entry[entrynum]=
	    (dircache_cacheentry*)malloc(sizeof(dircache_cacheentry));
	strcpy((char*)&(dircache_entry[entrynum]->name),name);
	dircache_entry[entrynum]->subdirs=DIRCACHE_UNKNOWN;
	dircache_entry[entrynum]->timestamp=DIRCACHE_UNKNOWN;
	return dircache_entry[entrynum];
}
;

void dircache_savecache(char *name)  // store the whole cache 
{
	FILE *o;
	int x;
	
	o=fopen(name,"w");
	if (o!=NULL)
	  {		  
		  for (x=0;x<dircache_entries;x++)
		    {
			    fprintf(o,"%d %d %s\n",
				    dircache_entry[x]->subdirs,
				    dircache_entry[x]->timestamp,
				    (char*)&dircache_entry[x]->name);
		    }
		  ;	
		  fclose(o);
	  }
	;
}
;

void dircache_loadcache(char *name) // reload cache
{
	FILE *i;
	dircache_cacheentry read;
	dircache_cacheentry *e;
	char buf[MAXPATHLENGTH];
	char *ce;
	char *le;

	if (dirlow_filesize(name)>0)
	  {		  
		  i=fopen(name,"r");
		  if (i!=NULL)
		    {
			    while (!feof(i))
			      {
				      fgets((char*)&buf,256,i);
				      
				      ce=(char*)&buf;
				      
				      le=strchr(ce,10);    // cut LF+CR
				      if (le!=NULL) *le=0;
				      le=strchr(ce,13);
				      if (le!=NULL) *le=0;
				      
				      sscanf(ce,"%d",&read.subdirs);
				      ce=strchr(ce,32);ce++;
				      sscanf(ce,"%d",&read.timestamp);
				      ce=strchr(ce,32);ce++;
				      strcpy((char*)&read.name,ce);
				      
				      if (strlen((char*)&read.name)>0)
					{				      
						e=dircache_createentry((char*)&read.name);
						memcpy(e,&read,sizeof(dircache_cacheentry));
					}
				      ;
			      }
			    ;
			    fclose(i);
		    }
		  ;
	  }
	;
}
;

int dircache_isdir(char *name)
{
 	dircache_cacheentry *e;
	int isdir;
	e=dircache_getentry(name);
	if (e==NULL)
	  {
		e=dircache_createentry(name);
	  }
	;
	if (e->subdirs==DIRCACHE_UNKNOWN)
	  {
		  if (dirlow_isdir(name))
		      e->subdirs=DIRCACHE_COUNT_UNKNOWN;
		      else e->subdirs=DIRCACHE_NODIR;
	  }
	;
	if (e->subdirs==DIRCACHE_NODIR) isdir=0; else isdir=1;
	return isdir;
}
;

int dircache_subdirentries(char *name)
{
	dircache_cacheentry *e;
	int subdirs;
	unsigned int newtimestamp;
	
	subdirs=-1;
	e=dircache_getentry(name);
	if (e==NULL)
	  {
		e=dircache_createentry(name);
	  }
	;
        if (dircache_isdir(name))
	  {
		  newtimestamp=dirlow_timestamp(name);
		  if ((e->subdirs==DIRCACHE_COUNT_UNKNOWN) ||
		      (e->timestamp!=newtimestamp))
		    {
			    e->subdirs=dirlow_subdirentries(name);
			    e->timestamp=newtimestamp;
		    }
		  ;
		  subdirs=e->subdirs;
	  }
	else subdirs=-1;
	return subdirs;
}
;
	
	
int dircache_isdirin(char *path,char *name)
{
	char *buf;
	int isdirin;
	
	buf=(char*)malloc(MAXPATHLENGTH);
	strcpy(buf,path);
	if (path[strlen(path)-1]!="/"[0])
	    strcat(buf,"/");
	strcat(buf,name);
	isdirin=dircache_isdir(buf);
	free(buf);
	return isdirin;
};


unsigned int dircache_filesizein(char*path,char*name)
{
	char *buf;
	int filesizein;
	
	buf=(char*)malloc(MAXPATHLENGTH);
	strcpy(buf,path);
	if (path[strlen(path)-1]!="/"[0])
	    strcat(buf,"/");
	strcat(buf,name);
	filesizein=dircache_filesize(buf);
	free(buf);
	return filesizein;
};

	
