/* The Type of Track representing an audiotrack located on a cdrom */

#include <sys/wait.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "int.h"

#include "tracks.h"
#include "piping.h"
#include "preferences.h"
#include "varmanwidgets.h"
#include "varman.h"
#include "audiotrack.h"
#include "cdromlow.h"
#include "cddrives.h"

/* uncomment if you want to see output of cdda2wav in recording terminal */
/* #define DEBUG */

#ifdef DEBUG
 #include "rterm.h"
 #include "colors.h"
 rterm_pipeinfo *debugtag;
#endif

#define audiotrack_getprecachingflag \
   (!strcmp(varman_getvar(global_defs,"audiotrack_precache"),"true")) \
   *atadd

int audiotrack_openpipe(void*trackinfo)
{	
	int outp=-1;
#ifdef DEBUG
	int errp=-1;
#endif
	char *call;
	audiotrack_info *i;
	int *perrp;
	
	i=(audiotrack_info*)((tracks_trackinfo*)trackinfo)->data;
 	call=varman_getvar_copy(global_defs,"audiotrack_read");
	varman_replacevars(global_defs,call);
	varman_replacestring(call,"$device",(char*)&i->device);
	varman_replacestring(call,
			     "$scsiid",
			     (char*)&cddrives_getrombydevicename((char*)&i->device)->scsiid);
	varman_replacestringbyfloat(call,"$tracknum",i->tracknum); 
	/* only get a std err pipe if in debugging mode,
	 * otherwise redirect output to /dev/zero (piping.c) */
	#ifdef DEBUG
	    perrp=&errp;
	#else
	    perrp=NULL;
	#endif	
	i->cdda2wavpid=piping_create(call,NULL,&outp,perrp);
	i->cdda2wavpipe=outp;
	
	#ifdef DEBUG 
	    debugtag=rterm_connectpipe(&Red,errp);
	#endif
   
   if (outp!=-1)
     cddrives_updatedisable();
	    
   free(call);
   return outp;
}
;

void audiotrack_closepipe(void*trackinfo)
{
   audiotrack_info *i;
	
   i=(audiotrack_info*)((tracks_trackinfo*)trackinfo)->data;
   if (i->cdda2wavpipe!=-1)
     {
	cddrives_updateenable();
	close(i->cdda2wavpipe);
	waitpid(i->cdda2wavpid,&i->cdda2wavstatus,0);
	/* wait for client to finish */
#ifdef DEBUG 
   rterm_disconnectpipe(debugtag);
#endif   
     };   
}
;

int audiotrack_tracksize(void*trackinfo)
{
	audiotrack_info *i;
	
	i=(audiotrack_info*)((tracks_trackinfo*)trackinfo)->data;

	return i->tracksize;
}
;

int audiotrack_dataavail(void*trackinfo)
{
	audiotrack_info *i;
	int dataavail;

	i=(audiotrack_info*)((tracks_trackinfo*)trackinfo)->data;
	dataavail=1;
	if (waitpid(i->cdda2wavpid,&i->cdda2wavstatus,WNOHANG)!=0)
	    dataavail=0;

	return dataavail;
}
;	

/* FIXME: do implement some "track present" check here */
int  audiotrack_valid(void*trackinfo)
{
	return 1;
}
;

void audiotrack_destroy(void*trackinfo)
{
	audiotrack_info *i;
	
	i=(audiotrack_info*)((tracks_trackinfo*)trackinfo)->data;
	
	if ((audiotrack_dataavail(trackinfo))&&(i->cdda2wavpipe!=-1))
	    close (i->cdda2wavpipe);
	free(i);
}
;

void audiotrack_pc_policy_changed(VARMAN_VAR_ENTRY *var,gpointer data)
{
   ((tracks_trackinfo*)data)->precacherequired=audiotrack_getprecachingflag;
};

tracks_trackinfo *audiotrack_create(char *device,int tracknum)
{
	tracks_trackinfo *at;
	audiotrack_info *info;
	char name[255];
	
	info=(audiotrack_info*)malloc(sizeof(audiotrack_info));
	strcpy((char*)&info->device,device);
	info->tracknum=tracknum;
	info->tracksize=cdromlow_tracksize(device,tracknum);

        sprintf((char*)&name,_("CD %#x Audiotrack %d"),
		cdromlow_cddbnumber(device),
		info->tracknum);	
   
	at=tracks_create((char*)&name,audio,audiotrack_getprecachingflag,
			 audiotrack_openpipe,
			 audiotrack_closepipe,
			 audiotrack_tracksize,
			 audiotrack_dataavail,
			 audiotrack_valid,
			 audiotrack_destroy,
			 info);
   
        varman_install_handler(global_defs,"audiotrack_precache",
			       audiotrack_pc_policy_changed,
			       at);
   
	return at;
}
;


/* configure the cdda audio stream from cdrom tracktype */
void audiotrack_init()
{	
	GtkWidget *audiotrack_prefs;
	GtkWidget *label;
	
	varmanwidgets_widget *atc;
	varmanwidgets_widget *read;
   	varmanwidgets_widget *precache;
	
	audiotrack_prefs=gtk_vbox_new(0,0);
	gtk_widget_show(audiotrack_prefs);
	label=gtk_label_new(_("CD Digital Audio"));
	gtk_widget_show(label);
	gtk_notebook_append_page(GTK_NOTEBOOK(preferences_editpad),
				 audiotrack_prefs,
				 label);

	atc=varmanwidgets_entry_new(_("Audio track Client:"),
				    "audiotrack_client",
				    global_defs,APPLYMODE_BUTTON,160,320);
	gtk_box_pack_start(GTK_BOX(audiotrack_prefs),atc->visual,0,0,0);

	read=varmanwidgets_entry_new(_("Audio track reading:"),
				     "audiotrack_read",
				     global_defs,APPLYMODE_BUTTON,160,320);
	gtk_box_pack_start(GTK_BOX(audiotrack_prefs),read->visual,0,0,0);
   
   	precache=varmanwidgets_checkbox_new(_("Precache Audio Tracks:"),
					    "audiotrack_precache",
					    global_defs,APPLYMODE_BUTTON,160,
					    "true","false");
   	gtk_box_pack_start(GTK_BOX(audiotrack_prefs),precache->visual,0,0,0);
}
;
	
