/*
** Copyright (C) 12 Mar 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

#include "preferences.h"
#include "vector_commands.h"
#include "common_gtk.h"
#include "command.h"
#include "rip_audio.h"
#include "cdlabel.h"
#include "mainwindow.h"
#include "progressbars_gui.h"
#include "config_files.h"
#include "detect_scsi.h"
#include "cdrecord_options.h"
#include "globals.h"

/* TODO: path and version check */

GtkWidget *prefs_speed[NO_SPEED];
misc_preferences misc_prefs = { TRUE, TRUE, TRUE, FALSE };
static GtkWidget *mkisofs_path_entry, *mkhybrid_path_entry, *diff_path_entry;
static GtkWidget *cdrecord_path_entry, *cdlabelgen_path_entry, *cdda2wav_path_entry;
static GtkWidget *prefs_enable_tooltips, *prefs_own_progresswin, *prefs_dummy;
static GtkWidget *prefs_eject, *iso_location_entry, *rip_location_entry;
static config_cdr_data *prefs_cdr_info = NULL;

static void new_mkisofs_path(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(mkisofs_path_entry),
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(GTK_WIDGET(data));
}
static void new_mkhybrid_path(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(mkhybrid_path_entry),
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(GTK_WIDGET(data));
}
static void new_cdrecord_path(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(cdrecord_path_entry),
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(GTK_WIDGET(data));
}
static void new_cdlabelgen_path(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(cdlabelgen_path_entry), 
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(GTK_WIDGET(data));
}
static void new_diff_path(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(diff_path_entry), 
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(GTK_WIDGET(data));
}
static void new_cdda2wav_path(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(cdda2wav_path_entry), 
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(GTK_WIDGET(data));
}

static GtkWidget *add_paths_page(void) {
	GtkWidget *frame3, *table1, *button9, *button10;
	GtkWidget *button11, *button12;
	file_req_info *add_info;
	
	frame3 = gtk_frame_new(NULL);
	gtk_widget_show(frame3);

	table1 = gtk_table_new(6, 2, FALSE);
	gtk_widget_show(table1);
	gtk_container_add(GTK_CONTAINER(frame3), table1);
	/* mkisofs */
	button9 = gtk_button_new_with_label(_("mkisofs"));
	gtk_widget_show(button9);
	gtk_table_attach(GTK_TABLE(table1), button9, 0, 1, 0, 1,
			(GtkAttachOptions) GTK_FILL,
			(GtkAttachOptions) GTK_FILL, 0, 0);

	gtk_tooltips_set_tip(tooltips, button9, _("Open up filerequester "
				"and sets the path to the mkisofs program "
				"(eg /usr/bin/mkisofs)"), NULL);
	/* FIXME: this doesn't seem to be freed anywhere */
	add_info = malloc(sizeof(file_req_info));
	add_info->title = g_strdup(_("Select path to mkisofs"));
	add_info->func = (gpointer) &new_mkisofs_path;
      gtk_signal_connect(GTK_OBJECT(button9), "clicked",
                  GTK_SIGNAL_FUNC(choose_path), (gpointer) add_info);

	mkisofs_path_entry = gtk_entry_new();
	gtk_widget_show(mkisofs_path_entry);
	gtk_entry_set_text(GTK_ENTRY(mkisofs_path_entry), mkisofs_path);
	gtk_table_attach(GTK_TABLE(table1), mkisofs_path_entry, 1, 2, 0, 1,
			(GtkAttachOptions) GTK_EXPAND | GTK_FILL,
			(GtkAttachOptions) GTK_FILL, 0, 0);
	/* mkhybrid */
	button10 = gtk_button_new_with_label(_("mkhybrid"));
	gtk_widget_show(button10);
	gtk_table_attach(GTK_TABLE(table1), button10, 0, 1, 1, 2,
			(GtkAttachOptions) GTK_FILL,
			(GtkAttachOptions) GTK_FILL, 0, 0);

	gtk_tooltips_set_tip(tooltips, button10, _("Open up filerequester "
				"and sets the path to the mkhbrid program "
				"(eg /usr/bin/mkhybrid)"), NULL);
	add_info = malloc(sizeof(file_req_info));
	add_info->title = g_strdup(_("Select path to mkhbyrd"));
	add_info->func = (gpointer) &new_mkhybrid_path;
      gtk_signal_connect(GTK_OBJECT(button10), "clicked",
                  GTK_SIGNAL_FUNC(choose_path), (gpointer) add_info);

	mkhybrid_path_entry = gtk_entry_new();
	gtk_widget_show(mkhybrid_path_entry);
	gtk_entry_set_text(GTK_ENTRY(mkhybrid_path_entry), mkhybrid_path);
	gtk_table_attach(GTK_TABLE(table1), mkhybrid_path_entry, 1, 2, 1, 2,
			GTK_EXPAND | GTK_FILL,
			GTK_FILL, 0, 0);
	/* cdrecord */
	button11 = gtk_button_new_with_label(_("cdrecord"));
	gtk_widget_show(button11);
	gtk_table_attach(GTK_TABLE(table1), button11, 0, 1, 2, 3,
			(GtkAttachOptions) GTK_FILL,
			(GtkAttachOptions) GTK_FILL, 0, 0);

	gtk_tooltips_set_tip(tooltips, button11, _("Open up filerequester "
				"and sets the path to the cdrecord program "
				"(eg /usr/bin/cdrecord)"), NULL);
	add_info = malloc(sizeof(file_req_info));
	add_info->title = g_strdup(_("Select path to cdrecord"));
	add_info->func = (gpointer) &new_cdrecord_path;
      gtk_signal_connect(GTK_OBJECT(button11), "clicked",
                  GTK_SIGNAL_FUNC(choose_path), (gpointer) add_info);

	cdrecord_path_entry = gtk_entry_new();
	gtk_widget_show(cdrecord_path_entry);
	gtk_entry_set_text(GTK_ENTRY(cdrecord_path_entry), cdrecord_path);
	gtk_table_attach(GTK_TABLE(table1), cdrecord_path_entry, 1, 2, 2, 3,
			(GtkAttachOptions) GTK_EXPAND | GTK_FILL,
			(GtkAttachOptions) GTK_FILL, 0, 0);
	/* cdlabelgen */
	button12 = gtk_button_new_with_label(_("cdlabelgen"));
	gtk_widget_show(button12);
	gtk_table_attach(GTK_TABLE(table1), button12, 0, 1, 3, 4,
			(GtkAttachOptions) GTK_FILL,
			(GtkAttachOptions) GTK_FILL, 0, 0);

	gtk_tooltips_set_tip(tooltips, button12, _("Open up filerequester "
				"and sets the path to the cdlabelgen program "
				"(eg /usr/bin/cdlabelgen)"), NULL);
	add_info = malloc(sizeof(file_req_info));
	add_info->title = g_strdup(_("Select path to cdlabelgen"));
	add_info->func = (gpointer) &new_cdlabelgen_path;
      gtk_signal_connect(GTK_OBJECT(button12), "clicked",
                  GTK_SIGNAL_FUNC(choose_path), (gpointer) add_info);

	cdlabelgen_path_entry = gtk_entry_new();
	gtk_widget_show(cdlabelgen_path_entry);
	gtk_entry_set_text(GTK_ENTRY(cdlabelgen_path_entry), cdlabelgen_path);
	gtk_table_attach(GTK_TABLE(table1), cdlabelgen_path_entry, 1, 2, 3, 4,
			GTK_EXPAND | GTK_FILL,
			GTK_FILL, 0, 0);
	/* diff */
	button12 = gtk_button_new_with_label(_("diff"));
	gtk_widget_show(button12);
	gtk_table_attach(GTK_TABLE(table1), button12, 0, 1, 4, 5,
			(GtkAttachOptions) GTK_FILL,
			(GtkAttachOptions) GTK_FILL, 0, 0);

	gtk_tooltips_set_tip(tooltips, button12, _("Open up filerequester "
				"and sets the path to the diff program "
				"(tested with GNU diff 2.7, others will probably work)"), NULL);
	add_info = malloc(sizeof(file_req_info));
	add_info->title = g_strdup(_("Select path to diff"));
	add_info->func = (gpointer) &new_diff_path;
      gtk_signal_connect(GTK_OBJECT(button12), "clicked",
                  GTK_SIGNAL_FUNC(choose_path), (gpointer) add_info);

	diff_path_entry = gtk_entry_new();
	gtk_widget_show(diff_path_entry);
	gtk_entry_set_text(GTK_ENTRY(diff_path_entry), diff_path);
	gtk_table_attach(GTK_TABLE(table1), diff_path_entry, 1, 2, 4, 5,
			GTK_EXPAND | GTK_FILL,
			GTK_FILL, 0, 0);
	/* cdda2wav */
	button11 = gtk_button_new_with_label(_("cdda2wav"));
	gtk_widget_show(button11);
	gtk_table_attach(GTK_TABLE(table1), button11, 0, 1, 5, 6,
			(GtkAttachOptions) GTK_FILL,
			(GtkAttachOptions) GTK_FILL, 0, 0);

	gtk_tooltips_set_tip(tooltips, button11, _("Open up filerequester "
				"and sets the path to the cdda2wav program "
				"(eg /usr/bin/cdda2wav)"), NULL);
	add_info = malloc(sizeof(file_req_info));
	add_info->title = g_strdup(_("Select path to cdda2wav"));
	add_info->func = (gpointer) &new_cdda2wav_path;
      gtk_signal_connect(GTK_OBJECT(button11), "clicked",
                  GTK_SIGNAL_FUNC(choose_path), (gpointer) add_info);

	cdda2wav_path_entry = gtk_entry_new();
	gtk_widget_show(cdda2wav_path_entry);
	gtk_entry_set_text(GTK_ENTRY(cdda2wav_path_entry), cdda2wav_path);
	gtk_table_attach(GTK_TABLE(table1), cdda2wav_path_entry, 1, 2, 5, 6,
			GTK_EXPAND | GTK_FILL,
			GTK_FILL, 0, 0);

	return frame3;
}
static GtkWidget *add_devices_page(void) {
	GtkWidget *swab_audio, *hbox, *vbox, *sep;
	int i;

	prefs_cdr_info = config_cdr(0);

	gtk_spin_button_set_value(
			GTK_SPIN_BUTTON(prefs_cdr_info->scsibus),
			gtk_spin_button_get_value_as_int(
				GTK_SPIN_BUTTON(mainptr->cdr_option_info->scsibus)));
	gtk_spin_button_set_value(
			GTK_SPIN_BUTTON(prefs_cdr_info->target),
			gtk_spin_button_get_value_as_int(
				GTK_SPIN_BUTTON(mainptr->cdr_option_info->target)));
	gtk_spin_button_set_value(
			GTK_SPIN_BUTTON(prefs_cdr_info->lun),
			gtk_spin_button_get_value_as_int(
				GTK_SPIN_BUTTON(mainptr->cdr_option_info->lun)));

	gtk_entry_set_text(GTK_ENTRY(prefs_cdr_info->driver),
			gtk_entry_get_text(GTK_ENTRY(mainptr->cdr_option_info->driver)));
	gtk_entry_set_text(GTK_ENTRY(prefs_cdr_info->device),
			gtk_entry_get_text(GTK_ENTRY(mainptr->cdr_option_info->device)));

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(prefs_cdr_info->hbox), vbox);

	sep = gtk_hseparator_new();
	gtk_widget_show(sep);
	gtk_box_pack_start(GTK_BOX(vbox), sep, TRUE, TRUE, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

	swab_audio = gtk_check_button_new_with_label(_("Swab audio"));
	gtk_widget_show(swab_audio);
	gtk_box_pack_start(GTK_BOX(hbox), swab_audio, TRUE, TRUE, 0);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(swab_audio),
			GTK_TOGGLE_BUTTON(mainptr->cdr_option_info->swab_audio)->active ? 1 : 0);
	gtk_tooltips_set_tip(tooltips, swab_audio, _("Asume audio data is in byte-swapped "
			"(little-endian) order"), NULL);
	prefs_cdr_info->swab_audio = swab_audio;

	select_speed(hbox, prefs_speed);

	for (i = 0; i < NO_SPEED; i++) {
		if (GTK_TOGGLE_BUTTON(speed_x[i])->active)
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(prefs_speed[i]), TRUE);
	}

	return prefs_cdr_info->widget;
}

static GtkWidget *add_misc_page(void) {
	GtkWidget *frame, *table;

	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);

	table = gtk_table_new(2, 2, FALSE);
	gtk_widget_show(table);
	gtk_container_add(GTK_CONTAINER(frame), table);

	prefs_enable_tooltips = gtk_check_button_new_with_label(_("Enable tooltips"));
	gtk_widget_show(prefs_enable_tooltips);
	gtk_tooltips_set_tip(tooltips, prefs_enable_tooltips,
			_("Toggles display of all tooltips"), NULL);	
	gtk_table_attach(GTK_TABLE(table), prefs_enable_tooltips, 0, 1, 0, 1,
			GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);

	prefs_own_progresswin = gtk_check_button_new_with_label(_("Progressbar has own window"));
	gtk_widget_show(prefs_own_progresswin);
	gtk_tooltips_set_tip(tooltips, prefs_own_progresswin,
			_("If disabled the progressinfo-widget is created as a child to the mainwindow, "
				"and not in a window of it's own"), NULL);	
	gtk_table_attach(GTK_TABLE(table), prefs_own_progresswin, 1, 2, 0, 1,
			GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);

	prefs_dummy = gtk_check_button_new_with_label(_("Dummy enabled by default"));
	gtk_widget_show(prefs_dummy);
	gtk_tooltips_set_tip(tooltips, prefs_dummy,
			_("Have the dummy run checkbox ticked when starting gcombust."), NULL);	
	gtk_table_attach(GTK_TABLE(table), prefs_dummy, 0, 1, 1, 2,
			GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);

	prefs_eject = gtk_check_button_new_with_label(_("Eject enabled by default"));
	gtk_widget_show(prefs_eject);
	gtk_tooltips_set_tip(tooltips, prefs_eject,
			_("Have the eject checkbox ticked when starting gcombust."), NULL);	
	gtk_table_attach(GTK_TABLE(table), prefs_eject, 1, 2, 1, 2,
			GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefs_enable_tooltips),
			misc_prefs.enable_tooltips);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefs_own_progresswin),
			misc_prefs.own_progresswin);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefs_dummy), misc_prefs.dummy);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefs_eject), misc_prefs.eject);

	return frame;
}

static void add_path_location(char *name, char *title, char *tooltip, int n, GtkWidget *table,
		GtkWidget *entry, char *default_path, gpointer *sel_function) {
	GtkWidget *button;
	file_req_info *add_info;

	button = gtk_button_new_with_label(name);
	gtk_widget_show(button);
	gtk_table_attach(GTK_TABLE(table), button, 0, 1, n, n+1,
			(GtkAttachOptions) GTK_FILL,
			(GtkAttachOptions) GTK_FILL, 0, 0);
	gtk_tooltips_set_tip(tooltips, button, tooltip, NULL);

	add_info = malloc(sizeof(file_req_info));
	add_info->title = g_strdup(title);
	add_info->func = sel_function;
      gtk_signal_connect(GTK_OBJECT(button), "clicked",
                  GTK_SIGNAL_FUNC(choose_path), (gpointer) add_info);

	gtk_widget_show(entry);
	gtk_entry_set_text(GTK_ENTRY(entry), default_path);
	gtk_table_attach(GTK_TABLE(table), entry, 1, 2, n, n+1,
			GTK_EXPAND | GTK_FILL,
			GTK_FILL, 0, 0);
}

static void new_iso_location(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(iso_location_entry), 
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(GTK_WIDGET(data));
}
static void new_rip_location(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(rip_location_entry), 
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(GTK_WIDGET(data));
}

static GtkWidget *add_storage_page(void) {
	GtkWidget *frame, *table;

	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);

	table = gtk_table_new(6, 2, FALSE);
	gtk_widget_show(table);
	gtk_container_add(GTK_CONTAINER(frame), table);

	iso_location_entry = gtk_entry_new();
	add_path_location(_("ISO"), _("Select default file to write ISO images to"),
			_("Default file to write ISO images to."), 0, table, iso_location_entry, "",
			(gpointer) &new_iso_location);
	gtk_entry_set_text(GTK_ENTRY(iso_location_entry), def_image_path);

	rip_location_entry = gtk_entry_new();
	add_path_location(_("WAV"), _("Select default dir to write WAV files to"),
			_("Default dir to write WAV files to."), 1, table, rip_location_entry, "",
			(gpointer) &new_rip_location);
	if (NULL == def_rip_path)
		def_rip_path = g_strdup("");
	gtk_entry_set_text(GTK_ENTRY(rip_location_entry), def_rip_path);

	return frame;
}

static void check_path(char *path) {
	struct stat buf;
	char *message;

	if (-1 == (stat(path, &buf))) {
		char *m = _(" %s does not exist, \n some of gcombusts "
				"operations will not work ");
		message = malloc(strlen(m) + strlen(path));
		g_snprintf(message, strlen(m) + strlen(path), m, path);
		alert_user_of_error(message);
		free(message);
      }
	if (S_ISDIR(buf.st_mode)) {
		char *m = _(" %s is a directory, \n it should be "
					"the complete path to the executable file, \n"
					"including the program name");
		message = malloc(strlen(m) + strlen(path));
		g_snprintf(message, strlen(m) + strlen(path), m, path);
		alert_user_of_error(message);
		free(message);
	}
}

static void check_all_paths_set(void) {
	/* TODO: check versions */
	check_path(mkisofs_path);
	check_path(mkhybrid_path);
	check_path(cdrecord_path);
	check_path(cdlabelgen_path);
	check_path(diff_path);
	check_path(cdda2wav_path);
}

static int destroy_prefs_win(GtkWidget *widget, gpointer data) {
	free(prefs_cdr_info);
	return 0;
}

static void forget_changes(GtkWidget *widget, gpointer data) {
	gtk_widget_destroy(GTK_WIDGET(data));

	check_all_paths_set();

	destroy_prefs_win(NULL, 0);
}

static void accept_path_changes(void) {
	char *path;

	if (NULL != (path = gtk_entry_get_text(GTK_ENTRY(mkisofs_path_entry)))) {
		free(mkisofs_path);
		mkisofs_path = g_strdup(path);
	}

	if (NULL != (path = gtk_entry_get_text(GTK_ENTRY(mkhybrid_path_entry)))) {
		free(mkhybrid_path);
		mkhybrid_path = g_strdup(path);
	}

	if (NULL != (path = gtk_entry_get_text(GTK_ENTRY(cdrecord_path_entry)))) {
		free(cdrecord_path);
		cdrecord_path = g_strdup(path);
	}

	if (NULL != (path = gtk_entry_get_text(GTK_ENTRY(cdlabelgen_path_entry)))) {
		free(cdlabelgen_path);
		cdlabelgen_path = g_strdup(path);
	}

	if (NULL != (path = gtk_entry_get_text(GTK_ENTRY(diff_path_entry)))) {
		free(diff_path);
		diff_path = g_strdup(path);
	}

	if (NULL != (path = gtk_entry_get_text(GTK_ENTRY(cdda2wav_path_entry)))) {
		free(cdda2wav_path);
		cdda2wav_path = g_strdup(path);
	}

	check_all_paths_set();
}

void apply_misc_changes(void) {

	if (misc_prefs.enable_tooltips)
		gtk_tooltips_enable(tooltips);
	else
		gtk_tooltips_disable(tooltips);

	if (misc_prefs.own_progresswin)
		detach_progresswin();
	else
		attach_progresswin();

	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(dummy), misc_prefs.dummy);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(eject), misc_prefs.eject);

	if (NULL != cdda_device_path)
		gtk_entry_set_text(GTK_ENTRY(audio_device_path), cdda_device_path);
}

static void accept_misc_changes(void) {
	misc_prefs.enable_tooltips = GTK_TOGGLE_BUTTON(prefs_enable_tooltips)->active;
	misc_prefs.own_progresswin = GTK_TOGGLE_BUTTON(prefs_own_progresswin)->active;
	misc_prefs.dummy = GTK_TOGGLE_BUTTON(prefs_dummy)->active;
	misc_prefs.eject = GTK_TOGGLE_BUTTON(prefs_eject)->active;

	apply_misc_changes();
}

static void accept_scsi_changes(void) {
	int i;
	gtk_spin_button_set_value(
			GTK_SPIN_BUTTON(mainptr->cdr_option_info->scsibus),
			gtk_spin_button_get_value_as_int(
				GTK_SPIN_BUTTON(prefs_cdr_info->scsibus)));
	gtk_spin_button_set_value(
			GTK_SPIN_BUTTON(mainptr->cdr_option_info->target),
			gtk_spin_button_get_value_as_int(
				GTK_SPIN_BUTTON(prefs_cdr_info->target)));
	gtk_spin_button_set_value(
			GTK_SPIN_BUTTON(mainptr->cdr_option_info->lun),
			gtk_spin_button_get_value_as_int(
				GTK_SPIN_BUTTON(prefs_cdr_info->lun)));

	gtk_entry_set_text(GTK_ENTRY(mainptr->cdr_option_info->driver),
			gtk_entry_get_text(GTK_ENTRY(prefs_cdr_info->driver)));
	gtk_entry_set_text(GTK_ENTRY(mainptr->cdr_option_info->device),
			gtk_entry_get_text(GTK_ENTRY(prefs_cdr_info->device)));

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(mainptr->cdr_option_info->swab_audio),
			GTK_TOGGLE_BUTTON(prefs_cdr_info->swab_audio)->active ? TRUE : FALSE);

	for (i = 0; i < NO_SPEED; i++) {
		if (GTK_TOGGLE_BUTTON(prefs_speed[i])->active)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(speed_x[i]), TRUE);
	}
}

void apply_storage_changes(void) {
	gtk_entry_set_text(GTK_ENTRY(image_path), def_image_path);
}

static void accept_storage_changes(void) {
	char *path;

	if (NULL != (path = gtk_entry_get_text(GTK_ENTRY(iso_location_entry)))) {
		g_free(def_image_path);
		def_image_path = g_strdup(path);
	}

	if (NULL != (path = gtk_entry_get_text(GTK_ENTRY(rip_location_entry)))) {
		g_free(def_rip_path);
		def_rip_path = g_strdup(path);
	}

	apply_storage_changes();
}

static void accept_changes(GtkWidget *widget, gpointer data) {
	accept_path_changes();
	accept_misc_changes();
	accept_scsi_changes();
	accept_storage_changes();

	save_config_file(prefs_cdr_info);
	gtk_widget_destroy(GTK_WIDGET(data));
	destroy_prefs_win(NULL, 0);
}

/* opens up the preferences window */
void preferences_cmd_callback(GtkWidget *widget, gpointer data) {
	GtkWidget *prefs_win, *notebook, *page, *label, *vbox, *hbox;
	GtkWidget *ok, *cancel;
  
	prefs_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(prefs_win), _("Preferences"));
/*	gtk_window_set_policy(GTK_WINDOW(prefs_win), TRUE, TRUE, FALSE); */

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(prefs_win), vbox);
	gtk_widget_show(vbox);

	/* add notebook pages */
	notebook = gtk_notebook_new();
	gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);
	gtk_widget_show(notebook);

	page = add_paths_page();
	gtk_container_add(GTK_CONTAINER(notebook), page);
	gtk_widget_show(page);

	page = add_devices_page();
	gtk_container_add(GTK_CONTAINER(notebook), page);
	gtk_widget_show_all(page);

	page = add_misc_page();
	gtk_container_add(GTK_CONTAINER(notebook), page);

	page = add_storage_page();
	gtk_container_add(GTK_CONTAINER(notebook), page);

	/* add notebookpage labels */
	label = gtk_label_new(_("Program paths"));
	set_notebook_tab(notebook, 0, label);
	gtk_widget_show(label);

	label = gtk_label_new(_("Devices"));
	set_notebook_tab(notebook, 1, label);

	label = gtk_label_new(_("Misc"));
	set_notebook_tab(notebook, 2, label);

	label = gtk_label_new(_("Storage paths"));
	set_notebook_tab(notebook, 3, label);

	/* add buttons */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_widget_show(cancel);
	gtk_tooltips_set_tip(tooltips, cancel, _("Forget changes"), NULL);
	gtk_box_pack_end(GTK_BOX(hbox), cancel, FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
                  GTK_SIGNAL_FUNC(forget_changes), (gpointer) prefs_win);

	ok = gtk_button_new_with_label(_("Ok"));
	gtk_widget_show(ok);
	gtk_tooltips_set_tip(tooltips, ok, _("Accept and save changes"), NULL);
	gtk_box_pack_end(GTK_BOX(hbox), ok, FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(ok), "clicked",
                  GTK_SIGNAL_FUNC(accept_changes), (gpointer) prefs_win);

      gtk_signal_connect(GTK_OBJECT(prefs_win), "delete_event",
                  GTK_SIGNAL_FUNC(destroy_prefs_win), NULL);

	gtk_widget_show(prefs_win);
}

