/*
** Copyright (C) 17 Jun 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>

#include "multisession.h"
#include "common_gtk.h"
#include "mainwindow.h"
#include "globals.h"

GtkWidget *enable_multisession, *old_session;

void multisession_options(GtkWidget *vbox) {
	GtkWidget *frame, *hbox, *label;

	frame = make_frame(_("Multisession"), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, TRUE, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(frame), hbox);

	enable_multisession = gtk_check_button_new_with_label(_("multisession"));
	gtk_widget_show(enable_multisession);
	gtk_box_pack_start(GTK_BOX(hbox), enable_multisession, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, enable_multisession, _("Make multisession image "
				"(appends new image to old image) - first additional session "
				"will waste about 22 MB, sequent sessions about 13 MB in overhead."
				"NOTE: currently directories in the old sessions gets completely "
				"overwritten when a new dir with the same name in a new session is "
				"added (ie the files inside it not in the new session \"disappears\") "
				"(some OSes allow you to mount individual sessions).\n"
				"**NOTE** multisession support in mkisofs is quite unstable at the moment, I recommend you DO NOT use it until it gets fixed! You have been warned."),
			NULL);

	old_session = gtk_entry_new();
	gtk_widget_show(old_session);
	gtk_box_pack_end(GTK_BOX(hbox), old_session, FALSE, FALSE, 0);
#ifdef __FreeBSD__
	gtk_tooltips_set_tip(tooltips, old_session, _("Path to old session image, usually "
				"the drive where the multisession CD is (/dev/cd0a), but can also "
				"be an existing image on disk. Leave this empty for first session."),
			NULL);
#else
	gtk_tooltips_set_tip(tooltips, old_session, _("Path to old session image, usually "
				"the drive where the multisession CD is (/dev/hdb), but can also "
				"be an existing image on disk. Leave this empty for first session."),
			NULL);
#endif

	label = gtk_label_new(_("Path to old session: "));
	gtk_widget_show(label);
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 0);
}

