\function{article_as_string}
\synopsis{-}
\usage{String article_as_string ()}
\description
   This function will return the entire contents of the current
   article as a string.
\seealso{}
\done

\function{get_next_art_pgdn_action}
\synopsis{-}
\usage{Integer get_next_art_pgdn_action ()}
\description
   This function may be used to get information about what action slrn
   will take when an attempt is made to go to the next page of the
   current article, e.g., by pressing the space key.  It returns one
   of the following integers:
#v+
       -1  Not in article mode
        0  Next page of the article will be displayed
        1  The next unread article will be displayed
        2  The newsreader will go to the next newsgroup
#v-
\done

\function{is_article_visible}
\synopsis{-}
\usage{Integer is_article_visible ()}
\description
   This function returns information about whether or not the article
   associated with the current header is visible in a window.
   Specifically, it returns:
#v+
      0  : if the article window is hidden
      1  : if the article window is showing but the current header
             does not refer to the article
      3  : if the article window contains the current header article
#v-
\seealso{is_article_window_zoomed, call}
\done

\function{is_article_window_zoomed}
\synopsis{-}
\usage{Integer is_article_window_zoomed ()}
\description
   This function returns 1 if the article window is zoomed, or 0
   otherwise.
\seealso{is_article_visible, call}
\done

\function{pipe_article}
\synopsis{-}
\usage{Void pipe_article (String cmd)}
\description
   This function may be used to pipe the current article to the command
   given by the \var{cmd} argument.
\seealso{read_mini}
\done

\function{re_search_article}
\synopsis{-}
\usage{Integer re_search_article (String pat)}
\description
   This function searches forward in the article associated with the
   currently selected header for a string matching the regular
   expression given by the parameter \var{pat}.  It returns 0 if no
   matching line is found.   Otherwise, it returns 1 and the matching
   line will be left on the stack as a string.
\seealso{search_article}
\done

\function{save_current_article}
\synopsis{-}
\usage{Integer save_current_article (String filename)}
\description
   This function saves the currently selected article to a file
   specified by \var{filename}.  It returns 0 upon success or -1 upon
   failure.
\notes
   This function always creates a new file.
\seealso{}
\done

\function{search_article}
\synopsis{-}
\usage{Integre search_article (String str)}
\description
   This function searches forward in the article associated with the
   currently selected header for the string given by the parameter
   \var{str}.  It returns 0 if no matching line is found.  Otherwise, it
   returns 1 and the matching line will be left on the stack as a
   string.
\seealso{re_search_article}
\done

\function{set_article_window_size}
\synopsis{-}
\usage{Void set_article_window_size (Integer nrows)}
\description
   The \var{set_article_window_size} may be used to set the height of the
   article window.  The variable \var{SCREEN_HEIGHT} may be used to
   facilitate this.
\seealso{}
\done

