#include <ctype.h>

#include "npconfig.h"

void new_folder_callback( GtkWidget *widget, gpointer data )
{
   GtkWidget *entry = ( GtkWidget *)gtk_object_get_data(
      GTK_OBJECT( widget->parent ), "name_entry" );

   char *line[ 2 ];
   if (( line[ 0 ] = gtk_entry_get_text( GTK_ENTRY( entry ))) == '\0' )
      return;

   NP_Config *config = ( NP_Config *)data;

   NP_Folders *folders =
      ( NP_Folders *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                          "object" );
   
   entry = ( GtkWidget *)gtk_object_get_data(
      GTK_OBJECT( widget->parent->parent->parent ), "filter_entry" );

   if ( entry != NULL )
      line[ 1 ] = gtk_entry_get_text( GTK_ENTRY( entry ));

   int result;
   if (( result = folders->add( line[ 0 ], line[ 1 ] )))
   {
      if ( result == 2 )
      {
         char buffer[ 128 ];
         snprintf( buffer, sizeof buffer,
                   "Folder %s already exists.", line[ 0 ] );
         config->show_message( buffer, 0 );
      }
      else
         folders->print_error();
      return;
   }

   GtkWidget *clist =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                         "clist" );

   gtk_clist_append( GTK_CLIST( clist ), line );

   config->dirty = 1;

   return;
}
