
#include "npconfig.h"

void lists_update_callback( GtkWidget *widget, gpointer data )
{
   NP_Config *config = ( NP_Config *)data;

   GtkWidget *active_clist =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                         "active" );

   const char *server = config->subscription[ config->current_server ];
   if ( server == NULL )
   {
      config->subscription.print_error();
      return;
   }

   char buffer[ 256 ];
   char message[ 1024 ];
   snprintf( buffer, sizeof buffer, "Connecting to %s...", server );
   config->show_message( buffer, 1 );
   config->stop = 0;
   
   if ( config->server.do_connect( server, "r", server_callback, data ))
   {
      message_callback( config->message_button, data );
      config->show_message( config->server.get_error(), 0 );
      while( config->message_window != NULL )
         while( gtk_events_pending())
            gtk_main_iteration();

      return;
   }

   const char *user = config->subscription.get_user( config->current_server );
   const char *pass = config->subscription.get_pass( config->current_server );

   if ( user != NULL && *user != '\0' && pass != NULL && *pass != '\0' )
   {
      snprintf( buffer, sizeof buffer, "authinfo user %s\r\n", user );
      if ( config->server.put_string( buffer ) )
      {
         config->server.disconnect();
         message_callback( config->message_button, data );
         config->show_message( config->server.get_error(), 0 );
         return;
      }

      if ( config->server.get_string( buffer, sizeof buffer ))
      {
         config->server.disconnect();
         message_callback( config->message_button, data );
         config->show_message( config->server.get_error(), 0 );
         return;
      }
      
      if ( strncmp( buffer, "381", 3 ))
      {
         config->server.disconnect();
         snprintf( message, sizeof message, "lists_update_callback(): "
                 "server responded to user name with: %s.", buffer );
         message_callback( config->message_button, data );
         config->show_message( message, 0 );
         return;
      }

      snprintf( buffer, sizeof buffer, "authinfo pass %s\r\n", pass );
      config->server.put_string( buffer );

      if ( config->server.get_string( buffer, sizeof buffer ))
      {
         config->server.disconnect();
         message_callback( config->message_button, data );
         config->show_message( config->server.get_error(), 0 );
         return;
      }
      
      if ( strncmp( buffer, "281", 3 ))
      {
         config->server.disconnect();
         snprintf( message, sizeof message, "lists_update_callback(): "
                 "server responded to password with: %s", buffer );
         message_callback( config->message_button, data );
         config->show_message( message, 0 );
         return;
      }
   }

   int result;
   if (( result = config->server.get_list() ))
   {
      message_callback( config->message_button, data );
      config->show_message( config->server.get_error(), 0 );
      while( config->message_window != NULL )
         while( gtk_events_pending() )
            gtk_main_iteration();
   }

   if ( config->message_window != NULL )
      message_callback( config->message_button, data );
   
   config->server.disconnect();
   config->stop = 0;
   
   config->load_clist( active_clist );
   
   return;
}
