/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>
#include <gnome.h>

#include "globals.h"
#include "statistics.h"
#include "util.h"

PanStatistics pan_stats;
PanStatsWindow psw;

/*--------------------------------------------------------------------
 * intialize the statistics engine, simply setting all the variables
 * in the global struct to zero to begin with.
 *--------------------------------------------------------------------*/
void
stats_init (PanStatistics stats)
{
	pan_stats.bytes_received = 0;
	pan_stats.bytes_sent = 0;
	pan_stats.time_online = 0;
}

void
stats_window_init (void)
{
//	psw.bytes_rec = gtk_label_new (stats_make_ulong_commatized (pan_stats.bytes_received));
//	psw.bytes_sent = gtk_label_new (stats_make_ulong_commatized (pan_stats.bytes_sent));
}


/*--------------------------------------------------------------------
 *
 *--------------------------------------------------------------------*/
gchar *
stats_make_time_online_string (void)
{
	gchar *p = NULL;
	gushort mins, hours;
	gulong onlinetime;

	onlinetime = pan_stats.time_online;

	if (onlinetime < 60)
		p = g_strdup_printf ("%ld s", onlinetime);
	else if (onlinetime > 60) {
		mins = onlinetime % 60;
		mins = (onlinetime - mins) / 60;
		p = g_strdup_printf ("%dm %lds", mins, onlinetime - (60*mins));
	}
	else if (onlinetime > 3600) {
		hours = onlinetime % 60;
		hours = (onlinetime - hours) / 60;
		mins = hours % 60;
		mins = (hours - mins) / 60;
		p = g_strdup_printf ("%dh %dm %lds", hours, mins - 60*hours, onlinetime - 3600*hours);
	}

	return p;
}


/*--------------------------------------------------------------------
 *
 *--------------------------------------------------------------------*/
void
stats_window_spawn (void)
{
	GtkWidget *hbox;
	GtkWidget *label;
	char buf[16];

	psw.dialog = gnome_dialog_new ("Pan Online Statistics",
					      GNOME_STOCK_BUTTON_OK,
					      NULL);

	gnome_dialog_set_parent (GNOME_DIALOG (psw.dialog), GTK_WINDOW (Pan.window));

	hbox = gtk_hbox_new (FALSE, 0);
	label = gtk_label_new (_("Total Bytes Received: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
//old	label = gtk_label_new (g_strdup_printf ("%ld", pan_stats.bytes_received));
	commatize_ulong ( pan_stats.bytes_received, buf );
	label = gtk_label_new ( buf );
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (psw.dialog)->vbox), hbox, FALSE, FALSE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	label = gtk_label_new (_("Total Bytes Sent: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
//old	label = gtk_label_new (g_strdup_printf ("%ld", pan_stats.bytes_sent));
        commatize_ulong ( pan_stats.bytes_sent, buf );
	label = gtk_label_new ( buf );
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (psw.dialog)->vbox), hbox, FALSE, FALSE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	label = gtk_label_new (_("Total Time Online: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
//old	label = gtk_label_new (g_strdup_printf ("%ld secs", pan_stats.time_online));
	label = gtk_label_new (stats_make_time_online_string());
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (psw.dialog)->vbox), hbox, FALSE, FALSE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	label = gtk_label_new (_("Transfer Rate: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	if (pan_stats.time_online > 0)
		label = gtk_label_new (g_strdup_printf ("%0.2f kb/sec", (pan_stats.bytes_received / pan_stats.time_online) / 1024.0));
	else
		label = gtk_label_new (g_strdup_printf ("0 kb/sec"));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (psw.dialog)->vbox), hbox, FALSE, FALSE, 0);

	gtk_widget_show_all (GTK_WIDGET (GNOME_DIALOG (psw.dialog)->vbox));

	gnome_dialog_run_and_close (GNOME_DIALOG (psw.dialog));
}
