/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*********************
**********************  Includes
*********************/

#include <config.h>

#include <glib.h>
#include <gtk/gtk.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>
#include <libgnomeui/gnome-dialog.h>
#include <libgnomeui/gnome-dialog-util.h>

#include "acache.h"
#include "globals.h"
#include "gui.h"
#include "log.h"
#include "save.h"
#include "util.h"

/*********************
**********************  Defines / Enumerated types
*********************/

/*********************
**********************  Macros
*********************/

/*********************
**********************  Structures / Typedefs
*********************/

/*********************
**********************  Private Function Prototypes
*********************/

static void save_file_cb (GtkWidget* entry, gpointer user_data);

#if 0
static void article_load_cb (GtkObject *object, gpointer user_data);
#endif

/*********************
**********************  Variables
*********************/

/***********
************  Extern
***********/

/***********
************  Public
***********/

/***********
************  Private
***********/

/*********************
**********************  BEGINNING OF SOURCE
*********************/

/************
*************  PUBLIC ROUTINES
************/

void save_current_article_cb(GtkWidget* w, gpointer p)
{
	save_current_article();
}

void save_current_article(void)
{
	if (Pan.active_message_id && *Pan.active_message_id)
		save_article (Pan.active_message_id);
}

void save_article (const gchar* message_id)
{
	GtkWidget* gfs = NULL;
	gchar* head = NULL;
	gchar* body = NULL;

	g_return_if_fail (message_id!=NULL);
	g_return_if_fail (*message_id!='\0');

	/* if we don't have the article already, download it */
        if ( !acache_body_exists(message_id)
	     || !acache_header_exists(message_id))
	{
#if 0
		QueueItem *item = QUEUE_ITEM(
			queue_item_body_new(sdata, gdata, message_id);
		gtk_object_set_data_full (GTK_OBJECT(item),
			"message-id", g_strdup(message_id), g_free());
		gtk_signal_connect (GTK_OBJECT(item),
			"destroy", article_load_cb, NULL);
#else
		pan_error_dialog ( "Must load the article first." );
#endif
		return;
	}

	head = acache_load_header (message_id);
	body = acache_load_body (message_id);
	gfs = gtk_file_selection_new ("Save As...");
	gtk_object_set_data_full (GTK_OBJECT(gfs), "body", body, g_free);
	gtk_object_set_data_full (GTK_OBJECT(gfs), "head", head, g_free);

	gtk_signal_connect (
		GTK_OBJECT(GTK_FILE_SELECTION(gfs)->ok_button),
		"clicked", save_file_cb, (gpointer)gfs );
	gtk_signal_connect_object (
		GTK_OBJECT(GTK_FILE_SELECTION(gfs)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
		(gpointer)gfs);
		            
	gtk_widget_show(gfs);
}

/************
*************  PRIVATE ROUTINES
************/

static void
real_save_file (GtkFileSelection *gfs)
{
	FILE *fp;
	gchar* body = gtk_object_get_data (GTK_OBJECT(gfs), "body");
	gchar* head = gtk_object_get_data (GTK_OBJECT(gfs), "head");
	gchar* filename = gtk_object_get_data (GTK_OBJECT(gfs), "filename");
      
	/* open the file... */	
	fp = fopen (filename, "w+");
	if (!fp) {
		pan_error_dialog (_("Unable to create file ``%s''"), filename);
		return;
	}

	/* write the file... */
	fputs(head, fp);
	fputs("\n\n", fp);
	fputs(body, fp);
	fclose(fp);

	log_add_va ("Saved file ``%s''", filename);
	gtk_widget_destroy (GTK_WIDGET(gfs));
}

static void
yes_im_sure_cb(gint reply, gpointer data)
{
	if (reply==0) /* yes */
		real_save_file (GTK_FILE_SELECTION(data));
}

/*****
******
*****/

static void
save_file_cb(GtkWidget* entry, gpointer user_data)
{
	GtkFileSelection *gfs = GTK_FILE_SELECTION(user_data);
	gchar *filename = gtk_file_selection_get_filename(gfs);
	if (filename && *filename)
	{
		gtk_object_set_data(GTK_OBJECT(gfs),"filename",filename);
		if (file_exists(filename))
		{
			GtkWidget *w = NULL;
			w = gnome_question_dialog_parented (
				_("File Exists.  Overwrite this file?"),
				yes_im_sure_cb, gfs,
				GTK_WINDOW(Pan.window) );
		}
		else
		{
			real_save_file (gfs);
		}
	}
}

/*****
******
*****/

/**
 * This callback is invoked whenever the queue-item to load the specified
 * article is being destroyed.  So at this point we should know whether or
 * not we were successful in pulling the article down from the server.
 */
#if 0
static void article_load_cb (GtkObject *object, gpointer user_data)
{
	const gchar* msg_id = gtk_object_get_data(object, "message-id");
        if ( !acache_body_exists(msg_id) || !acache_header_exists(msg_id))
	{
		pan_error_dialog ("Couldn't retreive message '%s'.", msg_id);
	}
	else g_warning ( "FIXME: add code here" );
}
#endif
