/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __QUEUE_ITEM_BODY__H__
#define __QUEUE_ITEM_BODY__H__

#include "queue-item.h"
#include "group.h"
#include "message.h"

#define QUEUE_ITEM_BODY(obj) ((QueueItemBody*)(obj))

typedef struct _QueueItemBody QueueItemBody;

struct _QueueItemBody
{
	QueueItem queue_item;

	/* private */
	group_data *gdata;
	Message *message;
	gboolean checkout;
};

extern PanObject* queue_item_body_new (server_data*, group_data*, Message*);

#endif /* __QUEUE_ITEM_BODY__H__ */
