/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __MESSAGE_WINDOW_H__
#define __MESSAGE_WINDOW_H__

#include "message.h"

struct _MessageWindow
{
	GtkWidget *window; /* GnomeApp */
	GtkWidget *appbar; /* GnomeAppBar */

	GtkWidget *read_info_pane;

	GtkWidget *from;
	GtkWidget *organization;
	GtkWidget *date;
	GtkWidget *newsgroups;		/* where the message was posted, or where we're posting to */
	GtkWidget *users;		/* who you're mailing this message to, or who sent the mail */
	GtkWidget *subject;

        GtkWidget *followup_to;
        GtkWidget *reply_to;

	GtkWidget *body;

	Message *message;
};

extern gboolean use_message_window_always;

void message_read_window (GtkWidget *widget, Message *msg);
void message_reply_window (GtkWidget *widget, Message *msg);
void message_reply_external (GtkWidget *widget, Message *msg);
void message_followup_window (GtkWidget *widget, Message *msg);
void message_post_window (GtkWidget *widget, Message *msg);

void update_body_pane (GtkWidget *body_widget, const gchar *body);
void message_window_new (Message *msg);


#endif
