/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <glib.h>
#include <gtk/gtk.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>

#include "articlelist.h"
#include "globals.h"
#include "grouplist.h"
#include "gui.h"
#include "gui-paned.h"
#include "text.h"

gint one_click_preview = 0;


void
gui_paned_select_all (void)
{
	switch (gui_paned_get_current_pane ()) {
	case 0: /* groups tab */
		grouplist_select_all ();
		break;
	case 1: /* articles tab */
		articlelist_select_all ();
		break;
	case 2: /* message tab */
		text_select_all ();
		break;
	default:
		break;
	}
}


/*---[ gui_paned_construct ]------------------------------------------
 * build the paned GUI layout
 *--------------------------------------------------------------------*/
void
gui_paned_construct (void)
{
	GtkWidget *vpane;
	GtkWidget *hpane;

	if (Pan.viewmode == GUI_PANED) return;
	if (Pan.viewmode == GUI_NOTEBOOK)
	{
		gtk_widget_ref (groups_vbox);
		gtk_container_remove (GTK_CONTAINER (groups_vbox->parent), groups_vbox);
		gtk_widget_ref (articlelist_ctree);
		gtk_container_remove (GTK_CONTAINER (articlelist_ctree->parent), articlelist_ctree);
		gtk_widget_ref (text_box);
		gtk_container_remove (GTK_CONTAINER (text_box->parent), text_box);
		gtk_container_foreach (GTK_CONTAINER (contents_vbox), (GtkCallback) gtk_widget_destroy, NULL);
	}

/* saving old layout 
	hpane = gtk_hpaned_new ();
	gtk_paned_add1 (GTK_PANED(hpane), groups_vbox);
	gtk_paned_add2 (GTK_PANED(hpane), articlelist_ctree);

	vpane = gtk_vpaned_new ();
	gtk_paned_add1 (GTK_PANED(vpane), hpane);
	gtk_paned_add2 (GTK_PANED(vpane), text_box);
*/

	vpane = gtk_vpaned_new ();
	gtk_paned_add1 (GTK_PANED (vpane), articlelist_ctree);
	gtk_paned_add2 (GTK_PANED (vpane), text_box);
	gtk_paned_set_position (GTK_PANED (vpane), gnome_config_get_int_with_default ("/Pan/Geometry/vpaned=140", NULL));

	hpane = gtk_hpaned_new ();
	gtk_paned_add1 (GTK_PANED (hpane), groups_vbox);
	gtk_paned_add2 (GTK_PANED (hpane), vpane);
	gtk_paned_set_position (GTK_PANED (hpane), gnome_config_get_int_with_default ("/Pan/Geometry/hpaned=265", NULL));

	gtk_box_pack_start (GTK_BOX (contents_vbox), hpane, TRUE, TRUE, 0);

	gui_restore_column_widths (Pan.group_clist, "group");
	gui_restore_column_widths (Pan.article_ctree, "articlelist");

	if (Pan.viewmode == GUI_NOTEBOOK)
	{
		gtk_widget_unref (groups_vbox);
		gtk_widget_unref (articlelist_ctree);
		gtk_widget_unref (text_box);
	}

	Pan.viewmode = GUI_PANED;
	gtk_widget_show_all (GTK_WIDGET(contents_vbox));
}


/*---[ gui_paned_get_current_pane ]-----------------------------------
 * get the current pane, returns an integer reflecting which pane
 * the user is 'in' ... almost identical to the gtk_notebook_get_page
 * functions
 *--------------------------------------------------------------------*/
int
gui_paned_get_current_pane (void)
{
	if (GTK_WIDGET_HAS_FOCUS (Pan.group_clist))
		return 0;
	if (GTK_WIDGET_HAS_FOCUS (Pan.article_ctree))
		return 1;
	if (GTK_WIDGET_HAS_FOCUS (Pan.text))
		return 2;
	
	return -1;
}


/*--------------------------------------------------------------------
 * ENTER key pressed while in the paned mode, process accordingly
 *--------------------------------------------------------------------*/
void
gui_paned_enter_clicked (void)
{
	switch (gui_paned_get_current_pane())
	{
		case 0: /* enter was pressed inside the 'group list' pane */
		{
			group_data* gdata = NULL;
			GList* sel = GTK_CLIST(Pan.group_clist)->selection;

			if (sel!=NULL)
			{
				GSList *l= grouplist_get_selected_groups();
				if (l!=NULL)
				{
					gdata = (group_data*) l->data;
					g_slist_free (l);
				}
			}
			if (gdata)
			{
		   		articlelist_set_current_group (
					grouplist_get_current_server(), gdata );
			}
			break;
		}
		case 1: /* enter key pressed inside the 'article list' pane */
		{
			const gchar* msg_id = NULL;
			GList* sel = GTK_CLIST(Pan.article_ctree)->selection;

			if (sel!=NULL)
				msg_id = articlelist_get_selected_message_id();
			if (msg_id)
				text_set_from_message_id (
					articlelist_get_current_server(),
					articlelist_get_current_group (),
					msg_id, NNTP_ARTICLE_READ, FALSE );
			break;
		}
		case 2: /* enter key pressed inside the 'message' pane */
		{
			break;
		}
		default:
		{
			g_warning ("reached default case in gui_paned_enter_clicked()");
			break;
		}
	}
}
