/*  VER 011  TAB P  $Id: sim.c,v 1.2 1999/03/31 05:53:46 src Exp $
 *
 *  "simulated" storage-API interface
 *  retrieves traditional articles in a way
 *  that emulates the API to allow consistent handling
 *
 *  $Log: sim.c,v $
 *  Revision 1.2  1999/03/31 05:53:46  src
 *  Seperated MAXHEADERSIZE from NNTP_STRLEN
 *
 *  Revision 1.1  1999/03/11 08:00:53  src
 *  Moved from storage
 *
 *  Revision 1.1  1999/03/07 14:58:24  src
 *  Storage API supported.
 */

#include "common.h"
#include "proto.h"
#include "nntp.h"
#include "stat.h"
#include "sim.h"
#include "news.h" /* MAXHEADERSIZE */

#define CHUNK_LEN (5*MAXHEADERSIZE)

static char *newline = "\r\n";

/*
 *  retrieve entire article
 */
ARTHANDLE *
SIMretrieve(const char *name)
{
    FILE *fp;
    char *art;
    int art_len;
    int alloc_len = CHUNK_LEN;
    int multi_1st = 0;
    int is_newline = 1;
    char *line;
    int len;
    ARTHANDLE *ap;
    struct stat st;

    SMerrorstr = NULL;

    if ((fp = fopen(name, "r")) == NULL) {
	SMerrorstr = strerror(errno);
	return 0;
    }

    line = art = xmalloc(alloc_len);
    art_len = 0;

    for (;;) {
	/* allocate more room, if needed */
	if (alloc_len-art_len <= MAXHEADERSIZE+2+1) {
	    alloc_len += CHUNK_LEN;
	    art = realloc(art, alloc_len);
	}

	line[MAXHEADERSIZE] = '\0';
	if (!fgets(line, MAXHEADERSIZE, fp)) break;

	/* must remove trailing linefeed */
	if ((len=strlen(line)) == 0) break;

	multi_1st = is_newline; /* if previous line ended here */
	if (line[len-1] == '\n') {
	    /* a complete line, or line termination */
	    is_newline = 1;
	    line[--len] = '\0';
	} else {
	    /*
	     * no newline detected - handle very long lines too
	     * problem pinpointed by Riku Saikkonen <rjs@isil.lloke.dna.fi>
	     */
	    is_newline = 0;
	}
	if (multi_1st && len == 1 && line[0] == '.') {
	    /*
	     * posting contains EOF, so convert to something
	     * harmless according to RFC-977, section 3.10.1
	     * fix by Riku Saikkonen <rjs@isil.lloke.dna.fi>
	     */
	    strcpy(line,"..");
	    len = 2;
	}
	if (is_newline) {
	    strcpy(line+len,newline);
	    len += strlen(newline);
	}
	line += len;
	art_len += len;
    }

    /* finished */
    if (!is_newline) {
	/* no trailing newline, so we need to add one */
	strcpy(line,newline);
	line += strlen(newline);
    }
    /* add end-of-file */
    sprintf(line, ".%s", newline);
    line += 3;

    if (ferror(fp)) {
	SMerrorstr = strerror(errno);
	fclose(fp);
	free(art);
	return 0;
    }

    /* all set */
    ap = xmalloc(sizeof(ARTHANDLE));

    ap->data = art;
    ap->len = line-art;
    time(&ap->arrived);
    if (fstat(fileno(fp),&st) >= 0) ap->arrived = st.st_mtime;

    fclose(fp);

    return ap;
}

/*
 *  free up storage following SIMretrieve
 */
void
SIMfreearticle(ARTHANDLE *article)
{
    if (article) {
	free(article->data);
	free(article);
    }
}
