/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@goatnet.ml.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@goatnet.ml.org>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

void whois_dialog __P((void));
void callback_opt __P((char *));
void callback_apply __P((void));
void callback_clear __P((void));
void callback_cancel __P((GtkWidget *, GtkWidget *));
void cb_chk_add __P((GtkWidget *));
void cb_chk_modify __P((GtkWidget *));
void cb_chk_remove __P((GtkWidget *));

__END_DECLS

GtkWidget *w_dialog;
GtkWidget *e_server;
GtkWidget *e_comment;
GtkWidget *b_check_add;
GtkWidget *b_check_modify;
GtkWidget *b_check_remove;
char optsrv[256];
int chk_flag = 0;
int newsrv_flag = 1;

void callback_cancel(GtkWidget *widget, GtkWidget *dialog)
{
  newsrv_flag = 1;
  SERVER_DIALOG_FLAG = 0;
  gtk_widget_destroy (dialog);
}

void callback_clear(void)
{
  gtk_entry_set_text (GTK_ENTRY (e_server), "");
  gtk_entry_set_text (GTK_ENTRY (e_comment), "");
}

void callback_apply(void)
{
  FILE *fp;
  char *c_server;
  char *c_comment;
  char **srv = malloc(10000);
  char path[BUFSIZE],buf[BUFSIZE],tmp[256];
  int remove_flag = 0;
  int i = 0;

  if (GTK_TOGGLE_BUTTON(b_check_remove)->active)
    {
      remove_flag = 1;
    }

  /*
   * Check if user got a personal server file.
   */
  sprintf(path,"%s%s",getenv("HOME"),SERVFILE);

#ifdef DEBUG
  fprintf(stderr,"(servmod.c/callback_apply:char path[%d] %d): %s\n",
	  sizeof(path),strlen(path),path);
#endif

  if (!(fp = fopen(path, "r")))
    {
      sprintf(path, "%s", XWHOIS_SERVERS);
      if (!(fp = fopen(path, "r")))
	{
	  perror("fopen");
	  exit(-1);
	}
    }

  /*
   * If new server, read old server strings into mem and apply new server last.
   * If modify, apply change to the server string matching change server entry.
   */

  c_server = NULL;
  c_comment = NULL;

  c_server = gtk_entry_get_text (GTK_ENTRY(e_server));
  c_comment = gtk_entry_get_text (GTK_ENTRY(e_comment));

#ifdef DEBUG
  fprintf(stderr,"(servmod.c/callback_apply:char *c_server[%d] %d): %s\n",
	  sizeof(c_server),strlen(c_server),c_server);
  fprintf(stderr,"(servmod.c/callback_apply:char *c_comment[%d] %d): %s\n",
	  sizeof(c_comment),strlen(c_comment),c_comment);
#endif

  if (strlen(c_server) == 0 || strlen(c_comment) == 0)
    {
      return;
    }

#ifdef DEBUG
  fprintf(stderr,"(servmod.c/callback_apply:int newsrv_flag): %d\n",
	  newsrv_flag);
#endif

  if (newsrv_flag == 1)
    {
      i = 0;
      while (fgets(buf,BUFSIZE-1,fp))
	{
	  srv[i] = malloc(strlen(buf)+1);
	  sprintf(srv[i], "%s", buf);
	  i++;
	}

      sprintf(buf, "%s # %s\n", c_server, c_comment);
      srv[i] = malloc(strlen(buf)+1);
      sprintf(srv[i], "%s", buf);
      fclose(fp);
    }
  else
    {
      i = 0;
      while (fgets(buf, BUFSIZE-1, fp))
	{
	  srv[i] = malloc(strlen(buf)+1);
	  sprintf(srv[i], "%s", buf);
	  sscanf(buf, "%s", tmp);

	  if (!strcmp(tmp,optsrv))
	    {
	      if (remove_flag == 1)
		{
		  i=i-1;
		}
	      else
		{
		  sprintf(buf, "%s # %s\n", c_server, c_comment);
		  srv[i] = malloc(strlen(buf)+1);
		  sprintf(srv[i], "%s", buf);
		}
	    }
	  i++;
	}
      fclose(fp);
      srv[i]=NULL;
    }

  /*
   * Write whois servers from mem to users homedir and close dialog window.
   */

  sprintf(path,"%s%s",getenv("HOME"),SERVFILE);

  if ((fp = fopen(path,"w")))
    {
      i=0;
      while(srv[i] != '\0')
	{
	  fprintf(fp, "%s", srv[i]);
	  i++;
	}
      fclose(fp);
    }

  /* free memory used to store the entries */
  for (i=0 ; srv[i] != '\0' ; i++)
    {
      free(srv[i]);
    }

  callback_cancel(NULL, w_dialog);
}

void cb_chk_modify(GtkWidget *widget)
{
  /*
   * If "New server" is active, force unactive, dont do anything.
   */

  if (newsrv_flag == 1)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_modify), FALSE);
      return;
    } 

  if (chk_flag == 0)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_remove), TRUE);
      chk_flag = 1;
      return;
    }

  if (chk_flag == 1)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_remove), FALSE);
      chk_flag = 0;
      return;
    }
}

void cb_chk_add(GtkWidget *widget)
{
  /*
   * If "New server" is active, force active, dont do anything.
   */

  if (newsrv_flag == 1)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_add), TRUE);
      return;
    }

  /*
   * If "New server" is inactive, force inactive, dont do anything.
   */

  if (newsrv_flag == 0)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_add), FALSE);
      return;
    }
}

void cb_chk_remove(GtkWidget *widget)
{
  /*
   * If "New server" active, force inactive, dont do anything.
   */

  if (newsrv_flag == 1)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_remove), FALSE);
      return;
    }

  if (chk_flag == 1)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_modify), TRUE);
      chk_flag = 0;
      return;
    }

  if (chk_flag == 0)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_modify), FALSE);
      chk_flag = 1;
      return;
    }
}

void callback_opt(char *server)
{
  FILE *fp;
  char buf[BUFSIZE], tmp1[BUFSIZE], tmp2[BUFSIZE];
  char *sp;
  int i = 0;

  sprintf(optsrv, "%s", server);

  if (strcmp(server, "New server"))
    {
      gtk_entry_set_text (GTK_ENTRY (e_server), server);

      /*
       * Get comment from whois server file and put
       * it in the comment entry field widget.
       */

      sprintf(buf,"%s%s",getenv("HOME"),SERVFILE);

      if (!(fp = fopen(buf, "r")))
	{
	  sprintf(buf, "%s", XWHOIS_SERVERS);
	  if (!(fp = fopen(buf, "r")))
	    {
	      printf("Cant open xwhois server file, %s", buf);
	      exit(-1);
	    }
	}
      while (fgets(buf, BUFSIZE-1, fp))
	{
	  sscanf(buf, "%s", tmp1);
	  
	  if (!strcmp(tmp1, server))
	    {
	      sp = strtok(buf, "#");
	      sp = strtok(NULL, "#");
	      sp++;
	      for (i=0 ; sp[i] != 10 ; i++) /* read until LF/newline */
		{
		  tmp2[i] = sp[i];
		}
	      tmp2[i] = '\0';
	      gtk_entry_set_text (GTK_ENTRY (e_comment), tmp2);
	    }
	}
      fclose(fp);
      newsrv_flag = 0;
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_add), FALSE);
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_modify), TRUE);
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_remove), FALSE);
    }
  else
    {
      gtk_entry_set_text (GTK_ENTRY (e_server), "");
      gtk_entry_set_text (GTK_ENTRY (e_comment), "");

      newsrv_flag = 1;
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_add), TRUE);
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_modify), FALSE);
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_remove), FALSE);
    }
}

void whois_dialog(void)
{
  FILE *fp;
  /*  GtkWidget *w_dialog; */
  GtkWidget *w_main_box;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *box;
  GtkWidget *h_box;
  GtkWidget *label_box;
  GtkWidget *widget_box;
  GtkWidget *m_opt_serv;
  GtkWidget *m_opt_serv_root;
  GtkWidget **m_opt_serv_menu = malloc(100000);
  GtkWidget *h_box_check;
  /*
  GtkWidget *b_check_add;
  GtkWidget *b_check_modify;
  GtkWidget *b_check_remove;
  */
  GtkWidget *b_apply;
  GtkWidget *b_clear;
  GtkWidget *b_cancel;
  char **servers = malloc(100000);
  char buf[256], tmp[256];
  int i = 0;

  /*
   * Dont open dialog if other dialog is already open.
   */

  if (SERVER_DIALOG_FLAG == 0)
    {
      SERVER_DIALOG_FLAG = 1;
    }
  else
    {
      return;
    }

  /*
   * Main dialog handler.
   */

  w_dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW (w_dialog), "whois server");
  gtk_signal_connect(GTK_OBJECT (w_dialog), "destroy",
		     GTK_SIGNAL_FUNC (callback_cancel), w_dialog);
  gtk_widget_show(w_dialog);

  /*
   * Upper option and entry frame.
   */

  frame = gtk_frame_new ("Server");
  gtk_container_border_width (GTK_CONTAINER (frame), 5);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (w_dialog)->vbox), frame);
  gtk_widget_show (frame);

  w_main_box = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), w_main_box);
  /*
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(w_dialog)->vbox), w_main_box,
			       TRUE, TRUE, 0);
  */
  gtk_widget_show (w_main_box);

  /*
   * Text labels.
   */

  label_box = gtk_vbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (w_main_box), label_box, TRUE, TRUE, 5);
  gtk_widget_show (label_box);

  label = gtk_label_new ("Whois server");
  gtk_box_pack_start (GTK_BOX (label_box), label, FALSE, FALSE, 7);
  gtk_widget_show (label);

  label = gtk_label_new ("Server field");
  gtk_box_pack_start (GTK_BOX (label_box), label, FALSE, FALSE, 2);
  gtk_widget_show (label);

  label = gtk_label_new ("Comment field");
  gtk_box_pack_start (GTK_BOX (label_box), label, FALSE, FALSE, 4);
  gtk_widget_show (label);

  box = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (label_box), box, FALSE, FALSE, 0);
  gtk_widget_show (box);

  /*
   * Widget box for option menu and entry fields.
   */

  widget_box = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (w_main_box), widget_box, FALSE, FALSE, 5);
  gtk_widget_show (widget_box);

  /*
   * Option menu for whois servers.
   */

  m_opt_serv = gtk_option_menu_new ();
  gtk_box_pack_start (GTK_BOX (widget_box), m_opt_serv, FALSE, FALSE, 0);
  gtk_widget_show (m_opt_serv);

  m_opt_serv_root = gtk_menu_new ();

  sprintf(buf,"%s",getenv("HOME"));
  strcat(buf,"/.xwhois.servers");
  if (!(fp = fopen(buf,"r")))
    {
      sprintf(buf, "%s", XWHOIS_SERVERS);
      if (!(fp = fopen(buf,"r")))
	{
	  perror("fopen");
	  exit(-1);
	}
    }

  servers[i] = malloc(strlen("New server")+1);
  sprintf(servers[i], "%s", "New server");
  i++;
  while (fgets(buf, 255, fp))
    {
      if (!(buf[0] == '#' || buf[0] == '\n'))
	{
	  sscanf(buf, "%s", tmp);
	  servers[i] = malloc(strlen(tmp)+1);
	  sprintf(servers[i], "%s", tmp);
	  i++;
	}
    }
  fclose(fp);

  i=0;
  while (servers[i] != '\0')
    {
      m_opt_serv_menu[i] = gtk_menu_item_new_with_label (servers[i]);
      gtk_menu_append (GTK_MENU (m_opt_serv_root), m_opt_serv_menu[i]);
      gtk_widget_show (m_opt_serv_menu[i]);
      gtk_signal_connect_object (GTK_OBJECT (m_opt_serv_menu[i]), "activate",
				 GTK_SIGNAL_FUNC (callback_opt),
				 (void *)servers[i]);
      i++;
    }

  /*
  for (i=0 ; servers[i] != NULL ; i++)
    {
      m_opt_serv_menu = gtk_menu_item_new_with_label (servers[i]);
      gtk_menu_append (GTK_MENU (m_opt_serv_root), m_opt_serv_menu);
      gtk_widget_show (m_opt_serv_menu);
      gtk_signal_connect_object (GTK_OBJECT (m_opt_serv_menu), "activate",
				 GTK_SIGNAL_FUNC (callback_opt),
				 (void *)servers[i]);
    }
  */

  gtk_option_menu_set_menu (GTK_OPTION_MENU (m_opt_serv), m_opt_serv_root);
  sprintf(optsrv, "%s", "New server");

  /*
   * List and entry field widgets.
   */

  e_server = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (widget_box), e_server, FALSE, FALSE, 5);
  gtk_widget_show (e_server);

  e_comment = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (widget_box), e_comment, FALSE, FALSE, 0);
  gtk_widget_show (e_comment);

  /*
   * Options frame.
   */

  frame = gtk_frame_new ("Options");
  gtk_container_border_width (GTK_CONTAINER (frame), 5);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (w_dialog)->vbox), frame);
  gtk_widget_show (frame);

  /*
   * Option check buttons.
   */

  h_box_check = gtk_hbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (frame), h_box_check);
  gtk_widget_show (h_box_check);

  b_check_add = gtk_check_button_new_with_label ("Add");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_add), TRUE);
  gtk_signal_connect (GTK_OBJECT (b_check_add), "clicked",
		      GTK_SIGNAL_FUNC (cb_chk_add), NULL);
  gtk_box_pack_start (GTK_BOX (h_box_check), b_check_add, FALSE, FALSE, 0);
  gtk_widget_show (b_check_add);

  b_check_modify = gtk_check_button_new_with_label ("Modify");
  gtk_signal_connect (GTK_OBJECT (b_check_modify), "clicked",
		      GTK_SIGNAL_FUNC (cb_chk_modify), NULL);
  gtk_box_pack_start (GTK_BOX (h_box_check), b_check_modify, FALSE, FALSE, 0);
  gtk_widget_show (b_check_modify);
  /*  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b_check_modify), FALSE); */

  b_check_remove = gtk_check_button_new_with_label ("Remove");
  gtk_signal_connect (GTK_OBJECT (b_check_remove), "clicked",
		      GTK_SIGNAL_FUNC (cb_chk_remove), NULL);
  gtk_box_pack_start (GTK_BOX (h_box_check), b_check_remove, FALSE, FALSE, 0);
  gtk_widget_show (b_check_remove);

  /*
   * Canned apply button.
   */

  b_apply = gtk_button_new_with_label (" Apply ");
  gtk_signal_connect (GTK_OBJECT (b_apply), "clicked",
		      GTK_SIGNAL_FUNC (callback_apply), NULL);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (w_dialog)->action_area),
		      b_apply, FALSE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (b_apply, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (b_apply);
  gtk_widget_show (b_apply);

  /*
   * Shape boxes for the clear button.
   */

  box = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (w_dialog)->action_area),
		      box, TRUE, FALSE, 0);
  gtk_widget_show (box);

  h_box = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), h_box, TRUE, TRUE, 5);
  gtk_widget_show (h_box);

  b_clear = gtk_button_new_with_label (" Clear ");
  gtk_signal_connect (GTK_OBJECT (b_clear), "clicked",
		      GTK_SIGNAL_FUNC (callback_clear), NULL);
  gtk_box_pack_start (GTK_BOX (h_box), b_clear, FALSE, FALSE, 0);
  gtk_widget_show (b_clear);

  /*
   * Shape boxes for the cancel button.
   */

  box = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (w_dialog)->action_area),
		      box, TRUE, FALSE, 0);
  gtk_widget_show (box);

  h_box = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), h_box, TRUE, TRUE, 5);
  gtk_widget_show (h_box);

  b_cancel = gtk_button_new_with_label (" Cancel ");
  gtk_signal_connect (GTK_OBJECT (b_cancel), "clicked",
		      GTK_SIGNAL_FUNC (callback_cancel), (GtkWidget *)w_dialog);
  gtk_box_pack_start (GTK_BOX (h_box), b_cancel, FALSE, FALSE, 0);
  gtk_widget_show (b_cancel);
}
