#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "ppxplink.h"
#include "xppxp.h"

int ppxpFd;
XtInputId InputId;

static int
ppxpEnv(struct xcio_s *xc)
{

        return 0;
}

static int
ppxpOut(struct xcio_s *xc)
{
        return 0;
}

static int
ppxpEnvUpdate(struct xcio_s *xc)
{
        if (strncasecmp(xc->buf, "NAME", 4)==0) {
                NewLabel(xc->buf+5);
        }
}

static int
ppxpUpdate(unsigned char *xcbuf)
{
        int p_auto, p_chat, p_estb, p_line, p_auth, p_net;
        int inrate, outrate;
        int ct;
        int auto_b, link_b;
        static int auto_bo = BS_Unchange;
        static int link_bo = BS_Unchange;
        struct pppinfo_s pppinfo;

        memcpy(&pppinfo, xcbuf, sizeof(pppinfo));
        p_auto = pppinfo.m_flag & MFLAG_AUTO;
        p_chat = (pppinfo.l_stat & (LSTAT_CHAT|LSTAT_DIAL));
        p_estb = (pppinfo.phase >= PS_ESTABLISH);
        p_line = pppinfo.l_stat  & LSTAT_PPP;
        p_auth = pppinfo.phase > PS_ESTABLISH;
        if (pppinfo.n_stat) {
                if (pppinfo.idle > 60 || pppinfo.idle <= 0 || !p_line) {
                        p_net = 1;
                } else if (pppinfo.idle > 30) {
                        p_net = 3;
                } else {
                        p_net = 6 + (pppinfo.idle/6);
                }
        } else {
                p_net = 0;
        }
        showLeds(p_auto, p_chat, p_estb, p_line, p_auth, p_net);

        inrate  = pppinfo.r.nsize - pppInfo.r.nsize;
        outrate = pppinfo.s.nsize - pppInfo.s.nsize;
        showMeters(inrate, outrate);

        if (p_line) {
                ct  = pppinfo.connect;
        } else {
                ct  = -1;
        }
        showConnectTime(ct);

        if (p_auto) {
                auto_b = BS_True;
        } else {
                auto_b = BS_False;
        }
        if (auto_b == auto_bo) {
                auto_b = BS_Unchange;
        } else {
                auto_bo = auto_b;
        }

        if (p_line) {
                link_b = BS_True;
        } else {
                link_b = BS_False;
        }
        if (link_b == link_bo) {
                link_b = BS_Unchange;
        } else {
                link_bo = link_b;
        }
        ButtonSet(auto_b, link_b);
        memcpy(&pppInfo, xcbuf, sizeof(pppInfo));

        return 0;
}

int
ppxpInit(int *argc, char *argv[])
{

        if ((ppxpFd = PPxPSetup(argc, argv)) < 0)
                return (ppxpFd);
        PPxPAutoUpdate(ppxpFd, TRUE);

        return ppxpFd;
}

int
ppxpGetState()
{
        PPxPUpdateRequest(ppxpFd);

        return 0;
}

int
ppxpCheck(XtPointer data, int* fid, XtInputId *id)
{
        int n;
        struct xcio_s xc;

        n = PPxPRead(*fid, XID_ANY, &xc);
        if (n > 0) {
                switch(xc.type) {
                case XCIO_UP_ENVS:
			if (app_data.debug) {
				fprintf(stderr, "XCIO_UP_ENVS:%s\n", xc.buf );
			}
                        ppxpEnvUpdate(&xc);
                        break;
                case XCIO_UP_INFO:
                        ppxpUpdate(xc.buf);
                        break;
                case XCIO_S_OUT:
                        ppxpOut(&xc);
                        break;
                case XCIO_ENV_SET:
                        ppxpEnv(&xc);
                        break;
                case XCIO_RETURN:
                        break;
                default:
                        if (app_data.debug) {
                                fprintf(stderr, 
                                "%s: warning: unkonw xcio_packet\n", NAME);
                        }
                }
        } else if (n < 0) {
                ppxpFd = -1;
                XtRemoveInput(InputId);
                showLeds(BS_False, BS_False, BS_False, 
                         BS_False, BS_False, BS_False);
                ButtonSet(BS_False, BS_False);
                if (app_data.polling > 0) {
                        ppxpRetry();
                } else if (app_data.polling < 0) {
                        FreeAll();
                        exit(0);
                }
        }

        return(n);
}

int
ppxpFinish()
{
        XcioClose(ppxpFd);

        return 0;
}

char *
ppxpGetEnv(char *env)
{
        xcmd_t xid;

        xid = PPxPEnvRequestv(ppxpFd, env, NULL);
        return PPxPEnvGet(ppxpFd, xid);
}
