/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <string.h>
#include "main.h"

extern char *filter[SONAME]; /* holds the name of the filter program and its arguments */


#ifdef USE_POSIX_THREAD
int init_struct(void)
{
   int strnum=1;

   for (strnum=1; (*(statstr+strnum)) && (!(*(statstr+strnum))->free) \
        && strnum <= (*statstr)->maxclients; strnum++);
   if (strnum > (*statstr)->maxclients) return 0; /* Client will be denied */

   if (!(*(statstr+strnum))) if (!(*(statstr+strnum) \
    = (status_type *)calloc(1, sizeof(status_type)))) return 0;
   (*(statstr+strnum))->free              = 0;
   (*(statstr+strnum))->_STANDARD_INPUT_  = (*statstr)->_STANDARD_INPUT_;
   (*(statstr+strnum))->_PFTP_DAEMON_     = (*statstr)->_PFTP_DAEMON_;
   (*(statstr+strnum))->_RECURS_          = (*statstr)->_RECURS_;
   (*(statstr+strnum))->lol               = (*statstr)->lol;
   (*(statstr+strnum))->OVERWRITE         = (*statstr)->OVERWRITE;
   (*(statstr+strnum))->_SKIP_            = (*statstr)->_SKIP_;
   (*(statstr+strnum))->_OPTIONS_         = (*statstr)->_OPTIONS_;
   (*(statstr+strnum))->usefilter         = (*statstr)->usefilter;
   (*(statstr+strnum))->testbsize         = (*statstr)->testbsize;
   (*(statstr+strnum))->fad_info          = 0;
   (*(statstr+strnum))->calc_dir          = 0;
   (*(statstr+strnum))->mul               = 0;
   (*(statstr+strnum))->start             = 0;
   (*(statstr+strnum))->first             = 0;
   (*(statstr+strnum))->accept_file_info  = (*statstr)->accept_file_info;
   (*(statstr+strnum))->rename            = (*statstr)->_PFTP_DAEMON_? 0: (*statstr)->rename;
   (*(statstr+strnum))->cwd_last_ch       = (*(statstr+strnum))->cwd;
   *((*(statstr+strnum))->cwd)            = 0;
   *((*(statstr+strnum))->home)           = 0;
   *((*(statstr+strnum))->incoming_lock)  = 0;
   *((*(statstr+strnum))->uplimit_lock)   = 0;
   *((*(statstr+strnum))->pw_passwd)      = 0;
   *((*(statstr+strnum))->pw_name)        = 0;
   *((*(statstr+strnum))->pw_dir)         = 0;
   *((*(statstr+strnum))->from)           = 0;
   *((*(statstr+strnum))->uploaddir)      = 0;
   *((*(statstr+strnum))->REMOTEHOSTNAME) = 0;
   *((*(statstr+strnum))->REMOTEIP)       = 0;
   if (!(*statstr)->_PFTP_DAEMON_) {
      strcpy((*(statstr+strnum))->home, (*statstr)->home);
   }
   if (!CHILDNUM) OUTPUT=0;
      
   return strnum;
}
#endif


void init_to_zero()
{
   int y=0;

   for (y=0; y < SONAME; y++) *(filter+y) = NULL;
   for (y=0; y < MAXCLIENTHOSTS; y++) _CLIENTHOSTNAME_[y] = NULL;
   for (y=1; y <= MAXCLIENTS; y++) *(statstr+y) = NULL;
   MEM_CHECK(((*statstr) = (status_type *)calloc(1, sizeof(status_type))));
   (*statstr)->version           = NULL;
   (*statstr)->sstatus           = NULL;
   (*statstr)->_HOSTNAME_        = NULL;
   (*statstr)->SENDMAKELINKS     = NULL;
   data_subject                  = NULL;
   data_info                     = NULL;
   pftplog                       = NULL;
#ifdef HAVE_INET6               
   (*statstr)->adin              = NULL;
   (*statstr)->priority          = 0;
#endif                          
   (*statstr)->autobitrate       = 0;
   (*statstr)->file_skipped      = 0;
   (*statstr)->ttys              = 0;
   (*statstr)->start             = 0;
   (*statstr)->testbsize         = 0;
   (*statstr)->first             = 0;
   (*statstr)->rename            = 0;
   (*statstr)->send_file_info    = 0;
   (*statstr)->accept_file_info  = 0;
   (*statstr)->use_udp           = 0;
   (*statstr)->show_bytes        = 0;
   (*statstr)->verbose           = 0;
   (*statstr)->show_percent      = 0;
   (*statstr)->single_connection = 0;
   (*statstr)->exit_afc          = 0;
   (*statstr)->sinlen            = 0;
   (*statstr)->fad_info          = 0;
   (*statstr)->mul               = 0;
   (*statstr)->throw_away        = 0;
   (*statstr)->lognames          = 0;
   (*statstr)->host_number       = 0;
   (*statstr)->_STDIN_BUFSIZ_    = 0;
   (*statstr)->FORCE_STDOUT      = 0;
   (*statstr)->_STANDARD_INPUT_  = 0;
   (*statstr)->_PFTP_DAEMON_     = 0;
   (*statstr)->_BANDWIDTH_       = 0;
   (*statstr)->READFROMSTDIN     = 0;
   (*statstr)->QT_FRONTEND       = 0;
   (*statstr)->_RECURS_          = 0;
   *((*statstr)->REMOTEHOSTNAME) = 0;
   *((*statstr)->incoming_lock)  = 0;
   *((*statstr)->uplimit_lock)   = 0;
   *((*statstr)->pw_passwd)      = 0;
   *((*statstr)->rlogin)         = 0;
   *((*statstr)->from)           = 0;
   (*statstr)->maxclients        = 0;
#if defined IPV6_ADD_MEMBERSHIP || (defined IP_ADD_MEMBERSHIP && !defined HAVE_INET6)
   (*statstr)->multicast         = 0;
   (*statstr)->mloop             = 0;
   (*statstr)->mttl              = 1;
#ifndef USE_POSIX_THREAD
   (*statstr)->isparent          = 1;
#endif
   (*statstr)->_INTERFACE_       = NULL;
   (*statstr)->_MULTICASTGROUP_  = NULL;
#endif
#ifndef USE_POSIX_THREAD
   (*statstr)->no_clients        = 0;
#endif
#if defined HAVE_FASYNC
   (*statstr)->new_line          = 0;
   (*statstr)->key_pressed       = 0;
#endif
}
