/*
 *  vollist.c
 *
 *  List server volumes, ncp_volume_list_{init,next,done} API demo
 *
 *  Copyright (C) 1999 by Petr Vandrovec
 *
 */

#include "config.h"

#include <ncp/nwcalls.h>
#include <ncp/nwnet.h>

#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <wchar.h>
#include <errno.h>
#include <string.h>

#include <libintl.h>
#define _(X) gettext(X)

static char *progname;

static void
usage(void)
{
	fprintf(stderr, _("usage: %s [options]\n"), progname);
}

static void
help(void)
{
	printf(_("\n"
	         "usage: %s [options] path\n"), progname);
	printf(_("\n"
	       "-h                Print this help text\n"
	       "-n namespace      0=DOS, 1=MAC, 2=NFS, 3=FTAM, 4=OS2\n"
	       "\n"));
}
			
int main(int argc, char *argv[]) {
	NWDSCCODE dserr;
	NWCONN_HANDLE conn;
	int opt;
	u_int32_t destns = NW_NS_DOS;
	NWVOL_HANDLE handle;
			
	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	
	progname = argv[0];

	NWCallsInit(NULL, NULL);
//	NWDSInitRequester();

	while ((opt = getopt(argc, argv, "h?n:")) != EOF)
	{
		switch (opt)
		{
		case 'n':
			destns = strtoul(optarg, NULL, 0);
			break;
		case 'h':
		case '?':
			help();
			goto finished;
		default:
			usage();
			goto finished;
		}
	}

	dserr = ncp_open_mount(argv[optind++], &conn);
	if (dserr) {
		fprintf(stderr, "ncp_open_mount failed: %s\n",
			strnwerror(dserr));
		return 123;
	}
	
	dserr = ncp_volume_list_init(conn, destns, 1, &handle);
	if (dserr)
		fprintf(stderr, "Cannot initialize list: %s (%08X)\n", strnwerror(dserr), dserr);
	else {
		unsigned int num;
		char name[256];
		
		while ((dserr = ncp_volume_list_next(handle, &num, name, sizeof(name))) == 0) {
			printf("Volume %02X: %s\n", num, name);
		}
		ncp_volume_list_end(handle);
	}
	ncp_close(conn);
finished:;
	return 0;
}
	
